/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data.avro;

import java.io.File;
import java.io.IOException;
import org.apache.iceberg.Files;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.AvroIterable;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.TestReadProjection;
import org.apache.iceberg.data.avro.DataWriter;
import org.apache.iceberg.data.avro.PlannedDataReader;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.assertj.core.api.Assertions;

public class TestGenericReadProjection
extends TestReadProjection {
    @Override
    protected Record writeAndRead(String desc, Schema writeSchema, Schema readSchema, Record record) throws IOException {
        File file = File.createTempFile("junit", ".avro", this.tempDir);
        Assertions.assertThat((boolean)file.delete()).isTrue();
        try (FileAppender appender = Avro.write((OutputFile)Files.localOutput((File)file)).schema(writeSchema).createWriterFunc(DataWriter::create).build();){
            appender.add((Object)record);
        }
        AvroIterable records = Avro.read((InputFile)Files.localInput((File)file)).project(readSchema).createResolvingReader(PlannedDataReader::create).build();
        return (Record)Iterables.getOnlyElement((Iterable)records);
    }
}

