/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data.parquet;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.Files;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.data.DataTest;
import org.apache.iceberg.data.DataTestHelpers;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.RandomGenericData;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.parquet.GenericParquetReaders;
import org.apache.iceberg.data.parquet.GenericParquetWriter;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.parquet.avro.AvroParquetWriter;
import org.apache.parquet.crypto.FileEncryptionProperties;
import org.apache.parquet.crypto.ParquetCryptoRuntimeException;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.schema.MessageType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestParquetEncryptionWithWriteSupport
extends DataTest {
    private static final ByteBuffer FILE_DEK = ByteBuffer.allocate(16);
    private static final ByteBuffer AAD_PREFIX = ByteBuffer.allocate(16);

    @Override
    protected void writeAndValidate(Schema schema) throws IOException {
        List<Record> expected = RandomGenericData.generate(schema, 100, 0L);
        this.writeAndValidate(schema, expected);
    }

    @Override
    protected void writeAndValidate(Schema schema, List<Record> expected) throws IOException {
        ArrayList rows;
        File testFile = File.createTempFile("junit", null, this.temp.toFile());
        Assertions.assertThat((boolean)testFile.delete()).isTrue();
        SecureRandom rand = new SecureRandom();
        rand.nextBytes(FILE_DEK.array());
        rand.nextBytes(AAD_PREFIX.array());
        try (FileAppender appender = Parquet.write((OutputFile)Files.localOutput((File)testFile)).schema(schema).withFileEncryptionKey(FILE_DEK).withAADPrefix(AAD_PREFIX).createWriterFunc(GenericParquetWriter::buildWriter).build();){
            appender.addAll(expected);
        }
        Assertions.assertThatThrownBy(() -> Parquet.read((InputFile)Files.localInput((File)testFile)).project(schema).createReaderFunc(fileSchema -> GenericParquetReaders.buildReader((Schema)schema, (MessageType)fileSchema)).build().iterator()).hasMessage("Trying to read file with encrypted footer. No keys available").isInstanceOf(ParquetCryptoRuntimeException.class);
        try (CloseableIterable reader = Parquet.read((InputFile)Files.localInput((File)testFile)).project(schema).withFileEncryptionKey(FILE_DEK).withAADPrefix(AAD_PREFIX).createReaderFunc(fileSchema -> GenericParquetReaders.buildReader((Schema)schema, (MessageType)fileSchema)).build();){
            rows = Lists.newArrayList((Iterable)reader);
        }
        for (int i = 0; i < expected.size(); ++i) {
            DataTestHelpers.assertEquals(schema.asStruct(), expected.get(i), (Record)rows.get(i));
        }
        reader = Parquet.read((InputFile)Files.localInput((File)testFile)).project(schema).withFileEncryptionKey(FILE_DEK).withAADPrefix(AAD_PREFIX).reuseContainers().createReaderFunc(fileSchema -> GenericParquetReaders.buildReader((Schema)schema, (MessageType)fileSchema)).build();
        try {
            CloseableIterator it = reader.iterator();
            int idx = 0;
            while (it.hasNext()) {
                GenericRecord actualRecord = (GenericRecord)it.next();
                DataTestHelpers.assertEquals(schema.asStruct(), expected.get(idx), (Record)actualRecord);
                ++idx;
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    @Test
    public void testTwoLevelList() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"arraybytes", (Type)Types.ListType.ofRequired((int)3, (Type)Types.BinaryType.get())), Types.NestedField.optional((int)2, (String)"topbytes", (Type)Types.BinaryType.get())});
        org.apache.avro.Schema avroSchema = AvroSchemaUtil.convert((Type)schema.asStruct());
        File testFile = File.createTempFile("junit", null, this.temp.toFile());
        Assertions.assertThat((boolean)testFile.delete()).isTrue();
        SecureRandom rand = new SecureRandom();
        rand.nextBytes(FILE_DEK.array());
        rand.nextBytes(AAD_PREFIX.array());
        FileEncryptionProperties fileEncryptionProperties = FileEncryptionProperties.builder((byte[])FILE_DEK.array()).withAADPrefix(AAD_PREFIX.array()).build();
        ParquetWriter writer = ((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)AvroParquetWriter.builder((Path)new Path(testFile.toURI())).withDataModel(GenericData.get()).withSchema(avroSchema).withEncryption(fileEncryptionProperties)).config("parquet.avro.add-list-element-records", "true")).config("parquet.avro.write-old-list-structure", "true")).build();
        GenericRecordBuilder recordBuilder = new GenericRecordBuilder(avroSchema);
        ArrayList<ByteBuffer> expectedByteList = new ArrayList<ByteBuffer>();
        byte[] expectedByte = new byte[]{0, 1};
        ByteBuffer expectedBinary = ByteBuffer.wrap(expectedByte);
        expectedByteList.add(expectedBinary);
        recordBuilder.set("arraybytes", expectedByteList);
        recordBuilder.set("topbytes", (Object)expectedBinary);
        GenericData.Record expectedRecord = recordBuilder.build();
        writer.write((Object)expectedRecord);
        writer.close();
        try (CloseableIterable reader = Parquet.read((InputFile)Files.localInput((File)testFile)).project(schema).withFileEncryptionKey(FILE_DEK).withAADPrefix(AAD_PREFIX).reuseContainers().createReaderFunc(fileSchema -> GenericParquetReaders.buildReader((Schema)schema, (MessageType)fileSchema)).build();){
            CloseableIterator it = reader.iterator();
            Assertions.assertThat((Iterator)it).hasNext();
            while (it.hasNext()) {
                GenericRecord actualRecord = (GenericRecord)it.next();
                Assertions.assertThat((List)((List)actualRecord.get(0, ArrayList.class))).first().isEqualTo((Object)expectedBinary);
                Assertions.assertThat((Comparable)((ByteBuffer)actualRecord.get(1, ByteBuffer.class))).isEqualTo((Object)expectedBinary);
                Assertions.assertThat((Iterator)it).isExhausted();
            }
        }
    }
}

