/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.BaseDeleteLoader;
import org.apache.iceberg.data.DeleteLoader;
import org.apache.iceberg.deletes.BaseDVFileWriter;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.deletes.PositionDeleteIndex;
import org.apache.iceberg.deletes.PositionDeleteWriter;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.DeleteWriteResult;
import org.apache.iceberg.io.FileWriterFactory;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.WriterTestBase;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.StructLikeSet;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public abstract class TestDVWriters<T>
extends WriterTestBase<T> {
    private OutputFileFactory fileFactory = null;
    private OutputFileFactory parquetFileFactory = null;

    @Parameters(name="formatVersion = {0}")
    protected static List<Object> parameters() {
        return Arrays.asList(2, 3);
    }

    protected abstract StructLikeSet toSet(Iterable<T> var1);

    protected FileFormat dataFormat() {
        return FileFormat.PARQUET;
    }

    @BeforeEach
    public void setupTable() throws Exception {
        this.table = this.create(SCHEMA, PartitionSpec.unpartitioned());
        this.fileFactory = OutputFileFactory.builderFor((Table)this.table, (int)1, (long)1L).format(FileFormat.PUFFIN).build();
        this.parquetFileFactory = OutputFileFactory.builderFor((Table)this.table, (int)1, (long)1L).format(FileFormat.PARQUET).build();
    }

    @TestTemplate
    public void testBasicDVs() throws IOException {
        Assumptions.assumeThat((int)this.formatVersion).isGreaterThanOrEqualTo(3);
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        ImmutableList rows1 = ImmutableList.of(this.toRow(1, "aaa"), this.toRow(2, "aaa"), this.toRow(11, "aaa"));
        DataFile dataFile1 = this.writeData(writerFactory, this.fileFactory, rows1, this.table.spec(), (StructLike)null);
        this.table.newFastAppend().appendFile(dataFile1).commit();
        ImmutableList rows2 = ImmutableList.of(this.toRow(3, "aaa"), this.toRow(4, "aaa"), this.toRow(12, "aaa"));
        DataFile dataFile2 = this.writeData(writerFactory, this.fileFactory, rows2, this.table.spec(), (StructLike)null);
        this.table.newFastAppend().appendFile(dataFile2).commit();
        BaseDVFileWriter dvWriter = new BaseDVFileWriter(this.fileFactory, (Function)new PreviousDeleteLoader((Table)this.table, (Map<String, DeleteFile>)ImmutableMap.of()));
        dvWriter.delete(dataFile1.location(), 1L, this.table.spec(), null);
        dvWriter.delete(dataFile2.location(), 0L, this.table.spec(), null);
        dvWriter.delete(dataFile1.location(), 0L, this.table.spec(), null);
        dvWriter.delete(dataFile2.location(), 1L, this.table.spec(), null);
        dvWriter.close();
        DeleteWriteResult result = dvWriter.result();
        Assertions.assertThat((List)result.deleteFiles()).hasSize(2);
        ((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat((Collection)result.referencedDataFiles()).hasSize(2)).contains((Object[])new CharSequence[]{dataFile1.location()})).contains((Object[])new CharSequence[]{dataFile2.location()});
        Assertions.assertThat((boolean)result.referencesDataFiles()).isTrue();
        this.commit(result);
        this.assertRows((Iterable<T>)ImmutableList.of(this.toRow(11, "aaa"), this.toRow(12, "aaa")));
    }

    @TestTemplate
    public void testRewriteDVs() throws IOException {
        Assumptions.assumeThat((int)this.formatVersion).isGreaterThanOrEqualTo(3);
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        ImmutableList rows = ImmutableList.of(this.toRow(1, "aaa"), this.toRow(2, "aaa"), this.toRow(3, "aaa"));
        DataFile dataFile = this.writeData(writerFactory, this.parquetFileFactory, rows, this.table.spec(), (StructLike)null);
        this.table.newFastAppend().appendFile(dataFile).commit();
        BaseDVFileWriter dvWriter1 = new BaseDVFileWriter(this.fileFactory, (Function)new PreviousDeleteLoader((Table)this.table, (Map<String, DeleteFile>)ImmutableMap.of()));
        dvWriter1.delete(dataFile.location(), 1L, this.table.spec(), null);
        dvWriter1.close();
        DeleteWriteResult result1 = dvWriter1.result();
        Assertions.assertThat((List)result1.deleteFiles()).hasSize(1);
        Assertions.assertThat((Collection)result1.referencedDataFiles()).containsOnly((Object[])new CharSequence[]{dataFile.location()});
        Assertions.assertThat((boolean)result1.referencesDataFiles()).isTrue();
        Assertions.assertThat((List)result1.rewrittenDeleteFiles()).isEmpty();
        this.commit(result1);
        Assertions.assertThat((Iterable)this.table.currentSnapshot().addedDeleteFiles(this.table.io())).hasSize(1);
        Assertions.assertThat((Iterable)this.table.currentSnapshot().removedDeleteFiles(this.table.io())).isEmpty();
        this.assertRows((Iterable<T>)ImmutableList.of(this.toRow(1, "aaa"), this.toRow(3, "aaa")));
        DeleteFile dv1 = (DeleteFile)Iterables.getOnlyElement((Iterable)result1.deleteFiles());
        BaseDVFileWriter dvWriter2 = new BaseDVFileWriter(this.fileFactory, (Function)new PreviousDeleteLoader((Table)this.table, (Map<String, DeleteFile>)ImmutableMap.of((Object)dataFile.location(), (Object)dv1)));
        dvWriter2.delete(dataFile.location(), 2L, this.table.spec(), null);
        dvWriter2.close();
        DeleteWriteResult result2 = dvWriter2.result();
        Assertions.assertThat((List)result2.deleteFiles()).hasSize(1);
        Assertions.assertThat((Collection)result2.referencedDataFiles()).containsOnly((Object[])new CharSequence[]{dataFile.location()});
        Assertions.assertThat((boolean)result2.referencesDataFiles()).isTrue();
        Assertions.assertThat((List)result2.rewrittenDeleteFiles()).hasSize(1);
        this.commit(result2);
        Assertions.assertThat((Iterable)this.table.currentSnapshot().addedDeleteFiles(this.table.io())).hasSize(1);
        Assertions.assertThat((Iterable)this.table.currentSnapshot().removedDeleteFiles(this.table.io())).hasSize(1);
        this.assertRows((Iterable<T>)ImmutableList.of(this.toRow(1, "aaa")));
    }

    @TestTemplate
    public void testRewriteFileScopedPositionDeletes() throws IOException {
        Assumptions.assumeThat((int)this.formatVersion).isEqualTo(2);
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        ImmutableList rows = ImmutableList.of(this.toRow(1, "aaa"), this.toRow(2, "aaa"), this.toRow(3, "aaa"));
        DataFile dataFile = this.writeData(writerFactory, this.parquetFileFactory, rows, this.table.spec(), (StructLike)null);
        this.table.newFastAppend().appendFile(dataFile).commit();
        DeleteFile deleteFile = this.writePositionDeletes(writerFactory, (List<Pair<String, Long>>)ImmutableList.of((Object)Pair.of((Object)dataFile.location(), (Object)0L)));
        this.table.newRowDelta().addDeletes(deleteFile).commit();
        this.assertRows((Iterable<T>)ImmutableList.of(this.toRow(2, "aaa"), this.toRow(3, "aaa")));
        this.table.updateProperties().set("format-version", "3").commit();
        BaseDVFileWriter dvWriter = new BaseDVFileWriter(this.fileFactory, (Function)new PreviousDeleteLoader((Table)this.table, (Map<String, DeleteFile>)ImmutableMap.of((Object)dataFile.location(), (Object)deleteFile)));
        dvWriter.delete(dataFile.location(), 1L, this.table.spec(), null);
        dvWriter.close();
        DeleteWriteResult result = dvWriter.result();
        Assertions.assertThat((List)result.deleteFiles()).hasSize(1);
        Assertions.assertThat((Collection)result.referencedDataFiles()).containsOnly((Object[])new CharSequence[]{dataFile.location()});
        Assertions.assertThat((boolean)result.referencesDataFiles()).isTrue();
        Assertions.assertThat((List)result.rewrittenDeleteFiles()).hasSize(1);
        this.commit(result);
        Assertions.assertThat((Iterable)this.table.currentSnapshot().addedDeleteFiles(this.table.io())).hasSize(1);
        Assertions.assertThat((Iterable)this.table.currentSnapshot().removedDeleteFiles(this.table.io())).hasSize(1);
        this.assertRows((Iterable<T>)ImmutableList.of(this.toRow(3, "aaa")));
    }

    @TestTemplate
    public void testApplyPartitionScopedPositionDeletes() throws IOException {
        Assumptions.assumeThat((int)this.formatVersion).isEqualTo(2);
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        ImmutableList rows1 = ImmutableList.of(this.toRow(1, "aaa"), this.toRow(2, "aaa"), this.toRow(3, "aaa"));
        DataFile dataFile1 = this.writeData(writerFactory, this.parquetFileFactory, rows1, this.table.spec(), (StructLike)null);
        this.table.newFastAppend().appendFile(dataFile1).commit();
        ImmutableList rows2 = ImmutableList.of(this.toRow(4, "aaa"), this.toRow(5, "aaa"), this.toRow(6, "aaa"));
        DataFile dataFile2 = this.writeData(writerFactory, this.parquetFileFactory, rows2, this.table.spec(), (StructLike)null);
        this.table.newFastAppend().appendFile(dataFile2).commit();
        DeleteFile deleteFile = this.writePositionDeletes(writerFactory, (List<Pair<String, Long>>)ImmutableList.of((Object)Pair.of((Object)dataFile1.location(), (Object)0L), (Object)Pair.of((Object)dataFile1.location(), (Object)1L), (Object)Pair.of((Object)dataFile2.location(), (Object)0L)));
        this.table.newRowDelta().addDeletes(deleteFile).commit();
        this.assertRows((Iterable<T>)ImmutableList.of(this.toRow(3, "aaa"), this.toRow(5, "aaa"), this.toRow(6, "aaa")));
        this.table.updateProperties().set("format-version", "3").commit();
        BaseDVFileWriter dvWriter = new BaseDVFileWriter(this.fileFactory, (Function)new PreviousDeleteLoader((Table)this.table, (Map<String, DeleteFile>)ImmutableMap.of((Object)dataFile2.location(), (Object)deleteFile)));
        dvWriter.delete(dataFile2.location(), 1L, this.table.spec(), null);
        dvWriter.close();
        DeleteWriteResult result = dvWriter.result();
        Assertions.assertThat((List)result.deleteFiles()).hasSize(1);
        Assertions.assertThat((Collection)result.referencedDataFiles()).containsOnly((Object[])new CharSequence[]{dataFile2.location()});
        Assertions.assertThat((boolean)result.referencesDataFiles()).isTrue();
        Assertions.assertThat((List)result.rewrittenDeleteFiles()).isEmpty();
        DeleteFile dv = (DeleteFile)Iterables.getOnlyElement((Iterable)result.deleteFiles());
        this.commit(result);
        Assertions.assertThat((Iterable)this.table.currentSnapshot().addedDeleteFiles(this.table.io())).hasSize(1);
        Assertions.assertThat((Iterable)this.table.currentSnapshot().removedDeleteFiles(this.table.io())).isEmpty();
        this.assertRows((Iterable<T>)ImmutableList.of(this.toRow(3, "aaa"), this.toRow(6, "aaa")));
        try (CloseableIterable tasks = this.table.newScan().planFiles();){
            for (FileScanTask task : tasks) {
                DeleteFile taskDeleteFile = (DeleteFile)Iterables.getOnlyElement((Iterable)task.deletes());
                if (((DataFile)task.file()).location().equals(dataFile1.location())) {
                    Assertions.assertThat((String)taskDeleteFile.location()).isEqualTo(deleteFile.location());
                    continue;
                }
                Assertions.assertThat((String)taskDeleteFile.location()).isEqualTo(dv.location());
            }
        }
    }

    private void commit(DeleteWriteResult result) {
        Snapshot startSnapshot = this.table.currentSnapshot();
        RowDelta rowDelta = this.table.newRowDelta();
        result.rewrittenDeleteFiles().forEach(arg_0 -> ((RowDelta)rowDelta).removeDeletes(arg_0));
        result.deleteFiles().forEach(arg_0 -> ((RowDelta)rowDelta).addDeletes(arg_0));
        if (startSnapshot != null) {
            rowDelta.validateFromSnapshot(startSnapshot.snapshotId());
        }
        rowDelta.commit();
    }

    private void assertRows(Iterable<T> expectedRows) throws IOException {
        Assertions.assertThat((Collection)this.actualRowSet("*")).isEqualTo((Object)this.toSet(expectedRows));
    }

    private DeleteFile writePositionDeletes(FileWriterFactory<T> writerFactory, List<Pair<String, Long>> deletes) throws IOException {
        EncryptedOutputFile file = this.parquetFileFactory.newOutputFile(this.table.spec(), null);
        PositionDeleteWriter writer = writerFactory.newPositionDeleteWriter(file, this.table.spec(), null);
        PositionDelete posDelete = PositionDelete.create();
        try (PositionDeleteWriter closableWriter = writer;){
            for (Pair<String, Long> delete : deletes) {
                closableWriter.write(posDelete.set((CharSequence)delete.first(), ((Long)delete.second()).longValue()));
            }
        }
        return writer.toDeleteFile();
    }

    private static class PreviousDeleteLoader
    implements Function<String, PositionDeleteIndex> {
        private final Map<String, DeleteFile> deleteFiles;
        private final DeleteLoader deleteLoader;

        PreviousDeleteLoader(Table table, Map<String, DeleteFile> deleteFiles) {
            this.deleteFiles = deleteFiles;
            this.deleteLoader = new BaseDeleteLoader(deleteFile -> table.io().newInputFile(deleteFile));
        }

        @Override
        public PositionDeleteIndex apply(String path) {
            DeleteFile deleteFile = this.deleteFiles.get(path);
            if (deleteFile == null) {
                return null;
            }
            return this.deleteLoader.loadPositionDeletes((Iterable)ImmutableList.of((Object)deleteFile), (CharSequence)path);
        }
    }
}

