/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.BaseDeleteLoader;
import org.apache.iceberg.data.DeleteLoader;
import org.apache.iceberg.deletes.DeleteGranularity;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.deletes.PositionDeleteIndex;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.io.ClusteredDataWriter;
import org.apache.iceberg.io.ClusteredEqualityDeleteWriter;
import org.apache.iceberg.io.ClusteredPositionDeleteWriter;
import org.apache.iceberg.io.DataWriteResult;
import org.apache.iceberg.io.DeleteWriteResult;
import org.apache.iceberg.io.FanoutDataWriter;
import org.apache.iceberg.io.FanoutPositionOnlyDeleteWriter;
import org.apache.iceberg.io.FileWriterFactory;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.WriterTestBase;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.util.ContentFileUtil;
import org.apache.iceberg.util.StructLikeSet;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public abstract class TestPartitioningWriters<T>
extends WriterTestBase<T> {
    private static final long TARGET_FILE_SIZE = 0x8000000L;
    @Parameter(index=1)
    private FileFormat fileFormat;
    private OutputFileFactory fileFactory = null;

    @Parameters(name="formatVersion = {0}, fileFormat = {1}")
    protected static List<Object> parameters() {
        return Arrays.asList(new Object[]{2, FileFormat.AVRO}, new Object[]{2, FileFormat.PARQUET}, new Object[]{2, FileFormat.ORC});
    }

    protected abstract StructLikeSet toSet(Iterable<T> var1);

    protected FileFormat format() {
        return this.fileFormat;
    }

    @BeforeEach
    public void setupTable() throws Exception {
        this.metadataDir = new File(this.tableDir, "metadata");
        this.table = this.create(SCHEMA, PartitionSpec.unpartitioned());
        this.fileFactory = OutputFileFactory.builderFor((Table)this.table, (int)1, (long)1L).format(this.fileFormat).build();
    }

    @TestTemplate
    public void testClusteredDataWriterNoRecords() throws IOException {
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        ClusteredDataWriter writer = new ClusteredDataWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        writer.close();
        Assertions.assertThat((List)((DataWriteResult)writer.result()).dataFiles()).isEmpty();
        writer.close();
        Assertions.assertThat((List)((DataWriteResult)writer.result()).dataFiles()).isEmpty();
    }

    @TestTemplate
    public void testClusteredDataWriterMultiplePartitions() throws IOException {
        this.table.updateSpec().addField((Term)Expressions.ref((String)"data")).commit();
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        ClusteredDataWriter writer = new ClusteredDataWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        PartitionSpec spec = this.table.spec();
        writer.write(this.toRow(1, "aaa"), spec, (StructLike)this.partitionKey(spec, "aaa"));
        writer.write(this.toRow(2, "aaa"), spec, (StructLike)this.partitionKey(spec, "aaa"));
        writer.write(this.toRow(3, "bbb"), spec, (StructLike)this.partitionKey(spec, "bbb"));
        writer.write(this.toRow(4, "bbb"), spec, (StructLike)this.partitionKey(spec, "bbb"));
        writer.write(this.toRow(5, "ccc"), spec, (StructLike)this.partitionKey(spec, "ccc"));
        writer.close();
        DataWriteResult result = (DataWriteResult)writer.result();
        Assertions.assertThat((List)result.dataFiles()).hasSize(3);
        RowDelta rowDelta = this.table.newRowDelta();
        result.dataFiles().forEach(arg_0 -> ((RowDelta)rowDelta).addRows(arg_0));
        rowDelta.commit();
        ImmutableList expectedRows = ImmutableList.of(this.toRow(1, "aaa"), this.toRow(2, "aaa"), this.toRow(3, "bbb"), this.toRow(4, "bbb"), this.toRow(5, "ccc"));
        Assertions.assertThat((Collection)this.actualRowSet("*")).isEqualTo((Object)this.toSet((Iterable<T>)expectedRows));
    }

    @TestTemplate
    public void testClusteredDataWriterOutOfOrderPartitions() throws IOException {
        this.table.updateSpec().addField((Term)Expressions.ref((String)"data")).commit();
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        ClusteredDataWriter writer = new ClusteredDataWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        PartitionSpec spec = this.table.spec();
        writer.write(this.toRow(1, "aaa"), spec, (StructLike)this.partitionKey(spec, "aaa"));
        writer.write(this.toRow(2, "aaa"), spec, (StructLike)this.partitionKey(spec, "aaa"));
        writer.write(this.toRow(3, "bbb"), spec, (StructLike)this.partitionKey(spec, "bbb"));
        writer.write(this.toRow(4, "bbb"), spec, (StructLike)this.partitionKey(spec, "bbb"));
        writer.write(this.toRow(5, "ccc"), spec, (StructLike)this.partitionKey(spec, "ccc"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> writer.write(this.toRow(6, "aaa"), spec, (StructLike)this.partitionKey(spec, "aaa"))).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Encountered records that belong to already closed files").hasMessageEndingWith("partition 'data=aaa' in spec " + spec);
        writer.close();
    }

    @TestTemplate
    public void testClusteredEqualityDeleteWriterNoRecords() throws IOException {
        ImmutableList equalityFieldIds = ImmutableList.of((Object)this.table.schema().findField("id").fieldId());
        Schema equalityDeleteRowSchema = this.table.schema().select(new String[]{"id"});
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema(), (List<Integer>)equalityFieldIds, equalityDeleteRowSchema);
        ClusteredEqualityDeleteWriter writer = new ClusteredEqualityDeleteWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        writer.close();
        Assertions.assertThat((List)((DeleteWriteResult)writer.result()).deleteFiles()).isEmpty();
        Assertions.assertThat((Collection)((DeleteWriteResult)writer.result()).referencedDataFiles()).isEmpty();
        Assertions.assertThat((boolean)((DeleteWriteResult)writer.result()).referencesDataFiles()).isFalse();
        writer.close();
        Assertions.assertThat((List)((DeleteWriteResult)writer.result()).deleteFiles()).isEmpty();
        Assertions.assertThat((Collection)((DeleteWriteResult)writer.result()).referencedDataFiles()).isEmpty();
        Assertions.assertThat((boolean)((DeleteWriteResult)writer.result()).referencesDataFiles()).isFalse();
    }

    @TestTemplate
    public void testClusteredEqualityDeleteWriterMultipleSpecs() throws IOException {
        ImmutableList equalityFieldIds = ImmutableList.of((Object)this.table.schema().findField("id").fieldId());
        Schema equalityDeleteRowSchema = this.table.schema().select(new String[]{"id"});
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema(), (List<Integer>)equalityFieldIds, equalityDeleteRowSchema);
        ImmutableList rows1 = ImmutableList.of(this.toRow(1, "aaa"), this.toRow(2, "aaa"), this.toRow(11, "aaa"));
        DataFile dataFile1 = this.writeData(writerFactory, this.fileFactory, rows1, this.table.spec(), (StructLike)null);
        this.table.newFastAppend().appendFile(dataFile1).commit();
        this.table.updateSpec().addField((Term)Expressions.bucket((String)"data", (int)16)).commit();
        ImmutableList rows2 = ImmutableList.of(this.toRow(3, "bbb"), this.toRow(4, "bbb"), this.toRow(12, "bbb"));
        DataFile dataFile2 = this.writeData(writerFactory, this.fileFactory, rows2, this.table.spec(), (StructLike)this.partitionKey(this.table.spec(), "bbb"));
        this.table.newFastAppend().appendFile(dataFile2).commit();
        this.table.updateSpec().removeField((Term)Expressions.bucket((String)"data", (int)16)).addField((Term)Expressions.ref((String)"data")).commit();
        ImmutableList rows3 = ImmutableList.of(this.toRow(5, "ccc"), this.toRow(13, "ccc"));
        DataFile dataFile3 = this.writeData(writerFactory, this.fileFactory, rows3, this.table.spec(), (StructLike)this.partitionKey(this.table.spec(), "ccc"));
        this.table.newFastAppend().appendFile(dataFile3).commit();
        ClusteredEqualityDeleteWriter writer = new ClusteredEqualityDeleteWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        PartitionSpec unpartitionedSpec = (PartitionSpec)this.table.specs().get(0);
        PartitionSpec bucketSpec = (PartitionSpec)this.table.specs().get(1);
        PartitionSpec identitySpec = (PartitionSpec)this.table.specs().get(2);
        writer.write(this.toRow(1, "aaa"), unpartitionedSpec, null);
        writer.write(this.toRow(2, "aaa"), unpartitionedSpec, null);
        writer.write(this.toRow(3, "bbb"), bucketSpec, (StructLike)this.partitionKey(bucketSpec, "bbb"));
        writer.write(this.toRow(4, "bbb"), bucketSpec, (StructLike)this.partitionKey(bucketSpec, "bbb"));
        writer.write(this.toRow(5, "ccc"), identitySpec, (StructLike)this.partitionKey(identitySpec, "ccc"));
        writer.close();
        DeleteWriteResult result = (DeleteWriteResult)writer.result();
        Assertions.assertThat((List)result.deleteFiles()).hasSize(3);
        Assertions.assertThat((Collection)((DeleteWriteResult)writer.result()).referencedDataFiles()).isEmpty();
        Assertions.assertThat((boolean)((DeleteWriteResult)writer.result()).referencesDataFiles()).isFalse();
        RowDelta rowDelta = this.table.newRowDelta();
        result.deleteFiles().forEach(arg_0 -> ((RowDelta)rowDelta).addDeletes(arg_0));
        rowDelta.commit();
        ImmutableList expectedRows = ImmutableList.of(this.toRow(11, "aaa"), this.toRow(12, "bbb"), this.toRow(13, "ccc"));
        Assertions.assertThat((Collection)this.actualRowSet("*")).isEqualTo((Object)this.toSet((Iterable<T>)expectedRows));
    }

    @TestTemplate
    public void testClusteredEqualityDeleteWriterOutOfOrderSpecsAndPartitions() throws IOException {
        ImmutableList equalityFieldIds = ImmutableList.of((Object)this.table.schema().findField("id").fieldId());
        Schema equalityDeleteRowSchema = this.table.schema().select(new String[]{"id"});
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema(), (List<Integer>)equalityFieldIds, equalityDeleteRowSchema);
        this.table.updateSpec().addField((Term)Expressions.bucket((String)"data", (int)16)).commit();
        this.table.updateSpec().removeField((Term)Expressions.bucket((String)"data", (int)16)).addField((Term)Expressions.ref((String)"data")).commit();
        ClusteredEqualityDeleteWriter writer = new ClusteredEqualityDeleteWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        PartitionSpec unpartitionedSpec = (PartitionSpec)this.table.specs().get(0);
        PartitionSpec bucketSpec = (PartitionSpec)this.table.specs().get(1);
        PartitionSpec identitySpec = (PartitionSpec)this.table.specs().get(2);
        writer.write(this.toRow(1, "aaa"), unpartitionedSpec, null);
        writer.write(this.toRow(2, "aaa"), unpartitionedSpec, null);
        writer.write(this.toRow(3, "bbb"), bucketSpec, (StructLike)this.partitionKey(bucketSpec, "bbb"));
        writer.write(this.toRow(4, "bbb"), bucketSpec, (StructLike)this.partitionKey(bucketSpec, "bbb"));
        writer.write(this.toRow(5, "ccc"), identitySpec, (StructLike)this.partitionKey(identitySpec, "ccc"));
        writer.write(this.toRow(6, "ddd"), identitySpec, (StructLike)this.partitionKey(identitySpec, "ddd"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> writer.write(this.toRow(7, "ccc"), identitySpec, (StructLike)this.partitionKey(identitySpec, "ccc"))).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Encountered records that belong to already closed files").hasMessageEndingWith("partition 'data=ccc' in spec " + identitySpec);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> writer.write(this.toRow(7, "aaa"), unpartitionedSpec, null)).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Encountered records that belong to already closed files").hasMessageEndingWith("spec []");
        writer.close();
    }

    @TestTemplate
    public void testClusteredPositionDeleteWriterNoRecordsPartitionGranularity() throws IOException {
        this.checkClusteredPositionDeleteWriterNoRecords(DeleteGranularity.PARTITION);
    }

    @TestTemplate
    public void testClusteredPositionDeleteWriterNoRecordsFileGranularity() throws IOException {
        this.checkClusteredPositionDeleteWriterNoRecords(DeleteGranularity.FILE);
    }

    private void checkClusteredPositionDeleteWriterNoRecords(DeleteGranularity deleteGranularity) throws IOException {
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        ClusteredPositionDeleteWriter writer = new ClusteredPositionDeleteWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L, deleteGranularity);
        writer.close();
        Assertions.assertThat((List)((DeleteWriteResult)writer.result()).deleteFiles()).isEmpty();
        Assertions.assertThat((Collection)((DeleteWriteResult)writer.result()).referencedDataFiles()).isEmpty();
        Assertions.assertThat((boolean)((DeleteWriteResult)writer.result()).referencesDataFiles()).isFalse();
        writer.close();
        Assertions.assertThat((List)((DeleteWriteResult)writer.result()).deleteFiles()).isEmpty();
        Assertions.assertThat((Collection)((DeleteWriteResult)writer.result()).referencedDataFiles()).isEmpty();
        Assertions.assertThat((boolean)((DeleteWriteResult)writer.result()).referencesDataFiles()).isFalse();
    }

    @TestTemplate
    public void testClusteredPositionDeleteWriterMultipleSpecsPartitionGranularity() throws IOException {
        this.checkClusteredPositionDeleteWriterMultipleSpecs(DeleteGranularity.PARTITION);
    }

    @TestTemplate
    public void testClusteredPositionDeleteWriterMultipleSpecsFileGranularity() throws IOException {
        this.checkClusteredPositionDeleteWriterMultipleSpecs(DeleteGranularity.FILE);
    }

    private void checkClusteredPositionDeleteWriterMultipleSpecs(DeleteGranularity deleteGranularity) throws IOException {
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        ImmutableList rows1 = ImmutableList.of(this.toRow(1, "aaa"), this.toRow(2, "aaa"), this.toRow(11, "aaa"));
        DataFile dataFile1 = this.writeData(writerFactory, this.fileFactory, rows1, this.table.spec(), (StructLike)null);
        this.table.newFastAppend().appendFile(dataFile1).commit();
        this.table.updateSpec().addField((Term)Expressions.bucket((String)"data", (int)16)).commit();
        ImmutableList rows2 = ImmutableList.of(this.toRow(3, "bbb"), this.toRow(4, "bbb"), this.toRow(12, "bbb"));
        DataFile dataFile2 = this.writeData(writerFactory, this.fileFactory, rows2, this.table.spec(), (StructLike)this.partitionKey(this.table.spec(), "bbb"));
        this.table.newFastAppend().appendFile(dataFile2).commit();
        this.table.updateSpec().removeField((Term)Expressions.bucket((String)"data", (int)16)).addField((Term)Expressions.ref((String)"data")).commit();
        ImmutableList rows3 = ImmutableList.of(this.toRow(5, "ccc"), this.toRow(13, "ccc"));
        DataFile dataFile3 = this.writeData(writerFactory, this.fileFactory, rows3, this.table.spec(), (StructLike)this.partitionKey(this.table.spec(), "ccc"));
        this.table.newFastAppend().appendFile(dataFile3).commit();
        ClusteredPositionDeleteWriter writer = new ClusteredPositionDeleteWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L, deleteGranularity);
        PartitionSpec unpartitionedSpec = (PartitionSpec)this.table.specs().get(0);
        PartitionSpec bucketSpec = (PartitionSpec)this.table.specs().get(1);
        PartitionSpec identitySpec = (PartitionSpec)this.table.specs().get(2);
        writer.write((Object)this.positionDelete(dataFile1.location(), 0L, null), unpartitionedSpec, null);
        writer.write((Object)this.positionDelete(dataFile1.location(), 1L, null), unpartitionedSpec, null);
        writer.write((Object)this.positionDelete(dataFile2.location(), 0L, null), bucketSpec, (StructLike)this.partitionKey(bucketSpec, "bbb"));
        writer.write((Object)this.positionDelete(dataFile2.location(), 1L, null), bucketSpec, (StructLike)this.partitionKey(bucketSpec, "bbb"));
        writer.write((Object)this.positionDelete(dataFile3.location(), 0L, null), identitySpec, (StructLike)this.partitionKey(identitySpec, "ccc"));
        writer.close();
        DeleteWriteResult result = (DeleteWriteResult)writer.result();
        Assertions.assertThat((List)((DeleteWriteResult)writer.result()).deleteFiles()).hasSize(3);
        Assertions.assertThat((Collection)((DeleteWriteResult)writer.result()).referencedDataFiles()).hasSize(3);
        Assertions.assertThat((boolean)((DeleteWriteResult)writer.result()).referencesDataFiles()).isTrue();
        RowDelta rowDelta = this.table.newRowDelta();
        result.deleteFiles().forEach(arg_0 -> ((RowDelta)rowDelta).addDeletes(arg_0));
        rowDelta.commit();
        ImmutableList expectedRows = ImmutableList.of(this.toRow(11, "aaa"), this.toRow(12, "bbb"), this.toRow(13, "ccc"));
        Assertions.assertThat((Collection)this.actualRowSet("*")).isEqualTo((Object)this.toSet((Iterable<T>)expectedRows));
    }

    @TestTemplate
    public void testClusteredPositionDeleteWriterOutOfOrderSpecsAndPartitionsPartitionGranularity() throws IOException {
        this.checkClusteredPositionDeleteWriterOutOfOrderSpecsAndPartitions(DeleteGranularity.PARTITION);
    }

    @TestTemplate
    public void testClusteredPositionDeleteWriterOutOfOrderSpecsAndPartitionsFileGranularity() throws IOException {
        this.checkClusteredPositionDeleteWriterOutOfOrderSpecsAndPartitions(DeleteGranularity.FILE);
    }

    private void checkClusteredPositionDeleteWriterOutOfOrderSpecsAndPartitions(DeleteGranularity deleteGranularity) throws IOException {
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        this.table.updateSpec().addField((Term)Expressions.bucket((String)"data", (int)16)).commit();
        this.table.updateSpec().removeField((Term)Expressions.bucket((String)"data", (int)16)).addField((Term)Expressions.ref((String)"data")).commit();
        ClusteredPositionDeleteWriter writer = new ClusteredPositionDeleteWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L, deleteGranularity);
        PartitionSpec unpartitionedSpec = (PartitionSpec)this.table.specs().get(0);
        PartitionSpec bucketSpec = (PartitionSpec)this.table.specs().get(1);
        PartitionSpec identitySpec = (PartitionSpec)this.table.specs().get(2);
        writer.write((Object)this.positionDelete("file-1.parquet", 0L, null), unpartitionedSpec, null);
        writer.write((Object)this.positionDelete("file-1.parquet", 1L, null), unpartitionedSpec, null);
        writer.write((Object)this.positionDelete("file-2.parquet", 0L, null), bucketSpec, (StructLike)this.partitionKey(bucketSpec, "bbb"));
        writer.write((Object)this.positionDelete("file-2.parquet", 1L, null), bucketSpec, (StructLike)this.partitionKey(bucketSpec, "bbb"));
        writer.write((Object)this.positionDelete("file-3.parquet", 0L, null), identitySpec, (StructLike)this.partitionKey(identitySpec, "ccc"));
        writer.write((Object)this.positionDelete("file-4.parquet", 0L, null), identitySpec, (StructLike)this.partitionKey(identitySpec, "ddd"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            PositionDelete positionDelete = this.positionDelete("file-5.parquet", 1L, null);
            writer.write((Object)positionDelete, identitySpec, (StructLike)this.partitionKey(identitySpec, "ccc"));
        }).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Encountered records that belong to already closed files").hasMessageEndingWith("partition 'data=ccc' in spec " + identitySpec);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            PositionDelete positionDelete = this.positionDelete("file-1.parquet", 3L, null);
            writer.write((Object)positionDelete, unpartitionedSpec, null);
        }).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Encountered records that belong to already closed files").hasMessageEndingWith("spec []");
        writer.close();
    }

    @TestTemplate
    public void testClusteredPositionDeleteWriterPartitionGranularity() throws IOException {
        this.checkClusteredPositionDeleteWriterGranularity(DeleteGranularity.PARTITION);
    }

    @TestTemplate
    public void testClusteredPositionDeleteWriterFileGranularity() throws IOException {
        this.checkClusteredPositionDeleteWriterGranularity(DeleteGranularity.FILE);
    }

    private void checkClusteredPositionDeleteWriterGranularity(DeleteGranularity deleteGranularity) throws IOException {
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        ImmutableList rows1 = ImmutableList.of(this.toRow(1, "aaa"), this.toRow(2, "aaa"), this.toRow(11, "aaa"));
        DataFile dataFile1 = this.writeData(writerFactory, this.fileFactory, rows1, this.table.spec(), (StructLike)null);
        this.table.newFastAppend().appendFile(dataFile1).commit();
        ImmutableList rows2 = ImmutableList.of(this.toRow(3, "aaa"), this.toRow(4, "aaa"), this.toRow(12, "aaa"));
        DataFile dataFile2 = this.writeData(writerFactory, this.fileFactory, rows2, this.table.spec(), (StructLike)null);
        this.table.newFastAppend().appendFile(dataFile2).commit();
        ClusteredPositionDeleteWriter writer = new ClusteredPositionDeleteWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L, deleteGranularity);
        PartitionSpec spec = this.table.spec();
        writer.write((Object)this.positionDelete(dataFile1.location(), 0L, null), spec, null);
        writer.write((Object)this.positionDelete(dataFile1.location(), 1L, null), spec, null);
        writer.write((Object)this.positionDelete(dataFile2.location(), 0L, null), spec, null);
        writer.write((Object)this.positionDelete(dataFile2.location(), 1L, null), spec, null);
        writer.close();
        DeleteWriteResult result = (DeleteWriteResult)writer.result();
        int expectedNumDeleteFiles = deleteGranularity == DeleteGranularity.FILE ? 2 : 1;
        Assertions.assertThat((List)result.deleteFiles()).hasSize(expectedNumDeleteFiles);
        Assertions.assertThat((Collection)result.referencedDataFiles()).hasSize(2);
        Assertions.assertThat((boolean)result.referencesDataFiles()).isTrue();
        RowDelta rowDelta = this.table.newRowDelta();
        result.deleteFiles().forEach(arg_0 -> ((RowDelta)rowDelta).addDeletes(arg_0));
        rowDelta.commit();
        ImmutableList expectedRows = ImmutableList.of(this.toRow(11, "aaa"), this.toRow(12, "aaa"));
        Assertions.assertThat((Collection)this.actualRowSet("*")).isEqualTo((Object)this.toSet((Iterable<T>)expectedRows));
    }

    @TestTemplate
    public void testFanoutDataWriterNoRecords() throws IOException {
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        FanoutDataWriter writer = new FanoutDataWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        writer.close();
        Assertions.assertThat((List)((DataWriteResult)writer.result()).dataFiles()).isEmpty();
        writer.close();
        Assertions.assertThat((List)((DataWriteResult)writer.result()).dataFiles()).isEmpty();
    }

    @TestTemplate
    public void testFanoutDataWriterMultiplePartitions() throws IOException {
        this.table.updateSpec().addField((Term)Expressions.ref((String)"data")).commit();
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        FanoutDataWriter writer = new FanoutDataWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        PartitionSpec spec = this.table.spec();
        writer.write(this.toRow(1, "aaa"), spec, (StructLike)this.partitionKey(spec, "aaa"));
        writer.write(this.toRow(3, "bbb"), spec, (StructLike)this.partitionKey(spec, "bbb"));
        writer.write(this.toRow(2, "aaa"), spec, (StructLike)this.partitionKey(spec, "aaa"));
        writer.write(this.toRow(4, "bbb"), spec, (StructLike)this.partitionKey(spec, "bbb"));
        writer.write(this.toRow(5, "ccc"), spec, (StructLike)this.partitionKey(spec, "ccc"));
        writer.close();
        DataWriteResult result = (DataWriteResult)writer.result();
        Assertions.assertThat((List)result.dataFiles()).hasSize(3);
        RowDelta rowDelta = this.table.newRowDelta();
        result.dataFiles().forEach(arg_0 -> ((RowDelta)rowDelta).addRows(arg_0));
        rowDelta.commit();
        ImmutableList expectedRows = ImmutableList.of(this.toRow(1, "aaa"), this.toRow(2, "aaa"), this.toRow(3, "bbb"), this.toRow(4, "bbb"), this.toRow(5, "ccc"));
        Assertions.assertThat((Collection)this.actualRowSet("*")).isEqualTo((Object)this.toSet((Iterable<T>)expectedRows));
    }

    @TestTemplate
    public void testFanoutPositionOnlyDeleteWriterNoRecordsPartitionGranularity() throws IOException {
        this.checkFanoutPositionOnlyDeleteWriterNoRecords(DeleteGranularity.PARTITION);
    }

    @TestTemplate
    public void testFanoutPositionOnlyDeleteWriterNoRecordsFileGranularity() throws IOException {
        this.checkFanoutPositionOnlyDeleteWriterNoRecords(DeleteGranularity.FILE);
    }

    private void checkFanoutPositionOnlyDeleteWriterNoRecords(DeleteGranularity deleteGranularity) throws IOException {
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        FanoutPositionOnlyDeleteWriter writer = new FanoutPositionOnlyDeleteWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L, deleteGranularity);
        writer.close();
        Assertions.assertThat((List)((DeleteWriteResult)writer.result()).deleteFiles()).isEmpty();
        Assertions.assertThat((Collection)((DeleteWriteResult)writer.result()).referencedDataFiles()).isEmpty();
        Assertions.assertThat((boolean)((DeleteWriteResult)writer.result()).referencesDataFiles()).isFalse();
        writer.close();
        Assertions.assertThat((List)((DeleteWriteResult)writer.result()).deleteFiles()).isEmpty();
        Assertions.assertThat((Collection)((DeleteWriteResult)writer.result()).referencedDataFiles()).isEmpty();
        Assertions.assertThat((boolean)((DeleteWriteResult)writer.result()).referencesDataFiles()).isFalse();
    }

    @TestTemplate
    public void testFanoutPositionOnlyDeleteWriterOutOfOrderRecordsPartitionGranularity() throws IOException {
        this.checkFanoutPositionOnlyDeleteWriterOutOfOrderRecords(DeleteGranularity.PARTITION);
    }

    @TestTemplate
    public void testFanoutPositionOnlyDeleteWriterOutOfOrderRecordsFileGranularity() throws IOException {
        this.checkFanoutPositionOnlyDeleteWriterOutOfOrderRecords(DeleteGranularity.FILE);
    }

    private void checkFanoutPositionOnlyDeleteWriterOutOfOrderRecords(DeleteGranularity deleteGranularity) throws IOException {
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        ImmutableList rows1 = ImmutableList.of(this.toRow(1, "aaa"), this.toRow(2, "aaa"), this.toRow(11, "aaa"));
        DataFile dataFile1 = this.writeData(writerFactory, this.fileFactory, rows1, this.table.spec(), (StructLike)null);
        this.table.newFastAppend().appendFile(dataFile1).commit();
        this.table.updateSpec().addField((Term)Expressions.bucket((String)"data", (int)16)).commit();
        ImmutableList rows2 = ImmutableList.of(this.toRow(3, "bbb"), this.toRow(4, "bbb"), this.toRow(12, "bbb"));
        DataFile dataFile2 = this.writeData(writerFactory, this.fileFactory, rows2, this.table.spec(), (StructLike)this.partitionKey(this.table.spec(), "bbb"));
        this.table.newFastAppend().appendFile(dataFile2).commit();
        this.table.updateSpec().removeField((Term)Expressions.bucket((String)"data", (int)16)).addField((Term)Expressions.ref((String)"data")).commit();
        ImmutableList rows3 = ImmutableList.of(this.toRow(5, "ccc"), this.toRow(13, "ccc"));
        DataFile dataFile3 = this.writeData(writerFactory, this.fileFactory, rows3, this.table.spec(), (StructLike)this.partitionKey(this.table.spec(), "ccc"));
        this.table.newFastAppend().appendFile(dataFile3).commit();
        FanoutPositionOnlyDeleteWriter writer = new FanoutPositionOnlyDeleteWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L, deleteGranularity);
        PartitionSpec unpartitionedSpec = (PartitionSpec)this.table.specs().get(0);
        PartitionSpec bucketSpec = (PartitionSpec)this.table.specs().get(1);
        PartitionSpec identitySpec = (PartitionSpec)this.table.specs().get(2);
        writer.write((Object)this.positionDelete(dataFile1.location(), 1L, null), unpartitionedSpec, null);
        writer.write((Object)this.positionDelete(dataFile2.location(), 1L, null), bucketSpec, (StructLike)this.partitionKey(bucketSpec, "bbb"));
        writer.write((Object)this.positionDelete(dataFile2.location(), 0L, null), bucketSpec, (StructLike)this.partitionKey(bucketSpec, "bbb"));
        writer.write((Object)this.positionDelete(dataFile3.location(), 1L, null), identitySpec, (StructLike)this.partitionKey(identitySpec, "ccc"));
        writer.write((Object)this.positionDelete(dataFile3.location(), 2L, null), identitySpec, (StructLike)this.partitionKey(identitySpec, "ccc"));
        writer.write((Object)this.positionDelete(dataFile1.location(), 0L, null), unpartitionedSpec, null);
        writer.write((Object)this.positionDelete(dataFile3.location(), 0L, null), identitySpec, (StructLike)this.partitionKey(identitySpec, "ccc"));
        writer.write((Object)this.positionDelete(dataFile1.location(), 2L, null), unpartitionedSpec, null);
        writer.close();
        DeleteWriteResult result = (DeleteWriteResult)writer.result();
        Assertions.assertThat((List)((DeleteWriteResult)writer.result()).deleteFiles()).hasSize(3);
        Assertions.assertThat((Collection)((DeleteWriteResult)writer.result()).referencedDataFiles()).hasSize(3);
        Assertions.assertThat((boolean)((DeleteWriteResult)writer.result()).referencesDataFiles()).isTrue();
        RowDelta rowDelta = this.table.newRowDelta();
        result.deleteFiles().forEach(arg_0 -> ((RowDelta)rowDelta).addDeletes(arg_0));
        rowDelta.commit();
        ImmutableList expectedRows = ImmutableList.of(this.toRow(12, "bbb"));
        Assertions.assertThat((Collection)this.actualRowSet("*")).isEqualTo((Object)this.toSet((Iterable<T>)expectedRows));
    }

    @TestTemplate
    public void testFanoutPositionOnlyDeleteWriterPartitionGranularity() throws IOException {
        this.checkFanoutPositionOnlyDeleteWriterGranularity(DeleteGranularity.PARTITION);
    }

    @TestTemplate
    public void testFanoutPositionOnlyDeleteWriterFileGranularity() throws IOException {
        this.checkFanoutPositionOnlyDeleteWriterGranularity(DeleteGranularity.FILE);
    }

    private void checkFanoutPositionOnlyDeleteWriterGranularity(DeleteGranularity deleteGranularity) throws IOException {
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        ImmutableList rows1 = ImmutableList.of(this.toRow(1, "aaa"), this.toRow(2, "aaa"), this.toRow(11, "aaa"));
        DataFile dataFile1 = this.writeData(writerFactory, this.fileFactory, rows1, this.table.spec(), (StructLike)null);
        this.table.newFastAppend().appendFile(dataFile1).commit();
        ImmutableList rows2 = ImmutableList.of(this.toRow(3, "aaa"), this.toRow(4, "aaa"), this.toRow(12, "aaa"));
        DataFile dataFile2 = this.writeData(writerFactory, this.fileFactory, rows2, this.table.spec(), (StructLike)null);
        this.table.newFastAppend().appendFile(dataFile2).commit();
        FanoutPositionOnlyDeleteWriter writer = new FanoutPositionOnlyDeleteWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L, deleteGranularity);
        PartitionSpec spec = this.table.spec();
        writer.write((Object)this.positionDelete(dataFile1.location(), 1L, null), spec, null);
        writer.write((Object)this.positionDelete(dataFile2.location(), 0L, null), spec, null);
        writer.write((Object)this.positionDelete(dataFile1.location(), 0L, null), spec, null);
        writer.write((Object)this.positionDelete(dataFile2.location(), 1L, null), spec, null);
        writer.close();
        DeleteWriteResult result = (DeleteWriteResult)writer.result();
        int expectedNumDeleteFiles = deleteGranularity == DeleteGranularity.FILE ? 2 : 1;
        Assertions.assertThat((List)result.deleteFiles()).hasSize(expectedNumDeleteFiles);
        Assertions.assertThat((Collection)result.referencedDataFiles()).hasSize(2);
        Assertions.assertThat((boolean)result.referencesDataFiles()).isTrue();
        RowDelta rowDelta = this.table.newRowDelta();
        result.deleteFiles().forEach(arg_0 -> ((RowDelta)rowDelta).addDeletes(arg_0));
        rowDelta.commit();
        ImmutableList expectedRows = ImmutableList.of(this.toRow(11, "aaa"), this.toRow(12, "aaa"));
        Assertions.assertThat((Collection)this.actualRowSet("*")).isEqualTo((Object)this.toSet((Iterable<T>)expectedRows));
    }

    @TestTemplate
    public void testRewriteOfPreviousDeletes() throws IOException {
        Assumptions.assumeThat((Comparable)this.format()).isIn(new Object[]{FileFormat.PARQUET, FileFormat.ORC});
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        ImmutableList rows1 = ImmutableList.of(this.toRow(1, "aaa"), this.toRow(2, "aaa"), this.toRow(11, "aaa"));
        DataFile dataFile1 = this.writeData(writerFactory, this.fileFactory, rows1, this.table.spec(), (StructLike)null);
        this.table.newFastAppend().appendFile(dataFile1).commit();
        ImmutableList rows2 = ImmutableList.of(this.toRow(3, "aaa"), this.toRow(4, "aaa"), this.toRow(12, "aaa"));
        DataFile dataFile2 = this.writeData(writerFactory, this.fileFactory, rows2, this.table.spec(), (StructLike)null);
        this.table.newFastAppend().appendFile(dataFile2).commit();
        PartitionSpec spec = this.table.spec();
        FanoutPositionOnlyDeleteWriter writer1 = new FanoutPositionOnlyDeleteWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L, DeleteGranularity.FILE);
        writer1.write((Object)this.positionDelete(dataFile1.location(), 1L), spec, null);
        writer1.write((Object)this.positionDelete(dataFile2.location(), 1L), spec, null);
        writer1.close();
        DeleteWriteResult result1 = (DeleteWriteResult)writer1.result();
        Assertions.assertThat((List)result1.deleteFiles()).hasSize(2);
        Assertions.assertThat((Collection)result1.referencedDataFiles()).hasSize(2);
        Assertions.assertThat((boolean)result1.referencesDataFiles()).isTrue();
        Assertions.assertThat((List)result1.rewrittenDeleteFiles()).isEmpty();
        RowDelta rowDelta1 = this.table.newRowDelta();
        result1.deleteFiles().forEach(arg_0 -> ((RowDelta)rowDelta1).addDeletes(arg_0));
        rowDelta1.commit();
        ImmutableList expectedRows1 = ImmutableList.of(this.toRow(1, "aaa"), this.toRow(3, "aaa"), this.toRow(11, "aaa"), this.toRow(12, "aaa"));
        Assertions.assertThat((Collection)this.actualRowSet("*")).isEqualTo((Object)this.toSet((Iterable<T>)expectedRows1));
        HashMap previousDeletes = Maps.newHashMap();
        for (DeleteFile deleteFile : result1.deleteFiles()) {
            String dataLocation = ContentFileUtil.referencedDataFile((DeleteFile)deleteFile).toString();
            previousDeletes.put(dataLocation, deleteFile);
        }
        FanoutPositionOnlyDeleteWriter writer2 = new FanoutPositionOnlyDeleteWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L, DeleteGranularity.FILE, (Function)new PreviousDeleteLoader((Table)this.table, previousDeletes));
        writer2.write((Object)this.positionDelete(dataFile1.location(), 0L), spec, null);
        writer2.write((Object)this.positionDelete(dataFile2.location(), 0L), spec, null);
        writer2.close();
        DeleteWriteResult result2 = (DeleteWriteResult)writer2.result();
        Assertions.assertThat((List)result2.deleteFiles()).hasSize(2);
        Assertions.assertThat((Collection)result2.referencedDataFiles()).hasSize(2);
        Assertions.assertThat((boolean)result2.referencesDataFiles()).isTrue();
        Assertions.assertThat((List)result2.rewrittenDeleteFiles()).hasSize(2);
        RowDelta rowDelta2 = this.table.newRowDelta();
        result2.deleteFiles().forEach(arg_0 -> ((RowDelta)rowDelta2).addDeletes(arg_0));
        result2.rewrittenDeleteFiles().forEach(arg_0 -> ((RowDelta)rowDelta2).removeDeletes(arg_0));
        rowDelta2.commit();
        ImmutableList expectedRows2 = ImmutableList.of(this.toRow(11, "aaa"), this.toRow(12, "aaa"));
        Assertions.assertThat((Collection)this.actualRowSet("*")).isEqualTo((Object)this.toSet((Iterable<T>)expectedRows2));
    }

    private static class PreviousDeleteLoader
    implements Function<CharSequence, PositionDeleteIndex> {
        private final Map<String, DeleteFile> deleteFiles;
        private final DeleteLoader deleteLoader;

        PreviousDeleteLoader(Table table, Map<String, DeleteFile> deleteFiles) {
            this.deleteFiles = deleteFiles;
            this.deleteLoader = new BaseDeleteLoader(deleteFile -> table.io().newInputFile(deleteFile));
        }

        @Override
        public PositionDeleteIndex apply(CharSequence path) {
            DeleteFile deleteFile = this.deleteFiles.get(path);
            return this.deleteLoader.loadPositionDeletes((Iterable)ImmutableList.of((Object)deleteFile), path);
        }
    }
}

