/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.io.BasePositionDeltaWriter;
import org.apache.iceberg.io.ClusteredDataWriter;
import org.apache.iceberg.io.ClusteredPositionDeleteWriter;
import org.apache.iceberg.io.FileWriterFactory;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.PartitioningWriter;
import org.apache.iceberg.io.WriteResult;
import org.apache.iceberg.io.WriterTestBase;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.util.StructLikeSet;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public abstract class TestPositionDeltaWriters<T>
extends WriterTestBase<T> {
    private static final long TARGET_FILE_SIZE = 0x8000000L;
    @Parameter(index=1)
    private FileFormat fileFormat;
    private OutputFileFactory fileFactory = null;

    @Parameters(name="formatVersion = {0}, fileFormat = {1}")
    protected static List<Object> parameters() {
        return Arrays.asList(new Object[]{2, FileFormat.AVRO}, new Object[]{2, FileFormat.ORC}, new Object[]{2, FileFormat.PARQUET});
    }

    protected abstract StructLikeSet toSet(Iterable<T> var1);

    protected FileFormat format() {
        return this.fileFormat;
    }

    @BeforeEach
    public void setupTable() throws Exception {
        this.metadataDir = new File(this.tableDir, "metadata");
        this.table = this.create(SCHEMA, PartitionSpec.unpartitioned());
        this.fileFactory = OutputFileFactory.builderFor((Table)this.table, (int)1, (long)1L).format(this.fileFormat).build();
    }

    @TestTemplate
    public void testPositionDeltaWithOneDataWriter() throws IOException {
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        ClusteredDataWriter dataWriter = new ClusteredDataWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        ClusteredPositionDeleteWriter deleteWriter = new ClusteredPositionDeleteWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        BasePositionDeltaWriter deltaWriter = new BasePositionDeltaWriter((PartitioningWriter)dataWriter, (PartitioningWriter)deleteWriter);
        deltaWriter.insert(this.toRow(1, "insert"), this.table.spec(), null);
        deltaWriter.update(this.toRow(2, "update"), this.table.spec(), null);
        deltaWriter.close();
        WriteResult result = deltaWriter.result();
        Object[] dataFiles = result.dataFiles();
        Object[] deleteFiles = result.deleteFiles();
        Object[] referencedDataFiles = result.referencedDataFiles();
        Assertions.assertThat((Object[])dataFiles).hasSize(1);
        Assertions.assertThat((Object[])deleteFiles).isEmpty();
        Assertions.assertThat((Object[])referencedDataFiles).isEmpty();
    }

    @TestTemplate
    public void testPositionDeltaInsertOnly() throws IOException {
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        ClusteredDataWriter insertWriter = new ClusteredDataWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        ClusteredDataWriter updateWriter = new ClusteredDataWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        ClusteredPositionDeleteWriter deleteWriter = new ClusteredPositionDeleteWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        BasePositionDeltaWriter deltaWriter = new BasePositionDeltaWriter((PartitioningWriter)insertWriter, (PartitioningWriter)updateWriter, (PartitioningWriter)deleteWriter);
        deltaWriter.insert(this.toRow(1, "aaa"), this.table.spec(), null);
        deltaWriter.close();
        WriteResult result = deltaWriter.result();
        Object[] dataFiles = result.dataFiles();
        Object[] deleteFiles = result.deleteFiles();
        Object[] referencedDataFiles = result.referencedDataFiles();
        Assertions.assertThat((Object[])dataFiles).hasSize(1);
        Assertions.assertThat((Object[])deleteFiles).isEmpty();
        Assertions.assertThat((Object[])referencedDataFiles).isEmpty();
        RowDelta rowDelta = this.table.newRowDelta();
        for (Object dataFile : dataFiles) {
            rowDelta.addRows((DataFile)dataFile);
        }
        rowDelta.commit();
        ImmutableList expectedRows = ImmutableList.of(this.toRow(1, "aaa"));
        Assertions.assertThat((Collection)this.actualRowSet("*")).isEqualTo((Object)this.toSet((Iterable<T>)expectedRows));
    }

    @TestTemplate
    public void testPositionDeltaDeleteOnly() throws IOException {
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        ImmutableList rows1 = ImmutableList.of(this.toRow(1, "aaa"), this.toRow(2, "aaa"), this.toRow(11, "aaa"));
        DataFile dataFile1 = this.writeData(writerFactory, this.fileFactory, rows1, this.table.spec(), (StructLike)null);
        this.table.newFastAppend().appendFile(dataFile1).commit();
        this.table.updateSpec().addField((Term)Expressions.ref((String)"data")).commit();
        ImmutableList rows2 = ImmutableList.of(this.toRow(3, "bbb"), this.toRow(4, "bbb"));
        DataFile dataFile2 = this.writeData(writerFactory, this.fileFactory, rows2, this.table.spec(), (StructLike)this.partitionKey(this.table.spec(), "bbb"));
        this.table.newFastAppend().appendFile(dataFile2).commit();
        PartitionSpec unpartitionedSpec = (PartitionSpec)this.table.specs().get(0);
        PartitionSpec partitionedSpec = (PartitionSpec)this.table.specs().get(1);
        ClusteredDataWriter insertWriter = new ClusteredDataWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        ClusteredDataWriter updateWriter = new ClusteredDataWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        ClusteredPositionDeleteWriter deleteWriter = new ClusteredPositionDeleteWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        BasePositionDeltaWriter deltaWriter = new BasePositionDeltaWriter((PartitioningWriter)insertWriter, (PartitioningWriter)updateWriter, (PartitioningWriter)deleteWriter);
        deltaWriter.delete((CharSequence)dataFile1.location(), 2L, unpartitionedSpec, null);
        deltaWriter.delete((CharSequence)dataFile2.location(), 1L, partitionedSpec, (StructLike)this.partitionKey(partitionedSpec, "bbb"));
        deltaWriter.close();
        WriteResult result = deltaWriter.result();
        Object[] dataFiles = result.dataFiles();
        Object[] deleteFiles = result.deleteFiles();
        Object[] referencedDataFiles = result.referencedDataFiles();
        Assertions.assertThat((Object[])dataFiles).isEmpty();
        Assertions.assertThat((Object[])deleteFiles).hasSize(2);
        Assertions.assertThat((Object[])referencedDataFiles).hasSize(2);
        RowDelta rowDelta = this.table.newRowDelta();
        for (Object deleteFile : deleteFiles) {
            rowDelta.addDeletes((DeleteFile)deleteFile);
        }
        rowDelta.commit();
        ImmutableList expectedRows = ImmutableList.of(this.toRow(1, "aaa"), this.toRow(2, "aaa"), this.toRow(3, "bbb"));
        Assertions.assertThat((Collection)this.actualRowSet("*")).isEqualTo((Object)this.toSet((Iterable<T>)expectedRows));
    }

    @TestTemplate
    public void testPositionDeltaMultipleSpecs() throws IOException {
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        ImmutableList rows1 = ImmutableList.of(this.toRow(1, "aaa"), this.toRow(2, "aaa"), this.toRow(11, "aaa"));
        DataFile dataFile1 = this.writeData(writerFactory, this.fileFactory, rows1, this.table.spec(), (StructLike)null);
        this.table.newFastAppend().appendFile(dataFile1).commit();
        this.table.updateSpec().addField((Term)Expressions.ref((String)"data")).commit();
        ImmutableList rows2 = ImmutableList.of(this.toRow(3, "bbb"), this.toRow(4, "bbb"));
        DataFile dataFile2 = this.writeData(writerFactory, this.fileFactory, rows2, this.table.spec(), (StructLike)this.partitionKey(this.table.spec(), "bbb"));
        this.table.newFastAppend().appendFile(dataFile2).commit();
        PartitionSpec unpartitionedSpec = (PartitionSpec)this.table.specs().get(0);
        PartitionSpec partitionedSpec = (PartitionSpec)this.table.specs().get(1);
        ClusteredDataWriter insertWriter = new ClusteredDataWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        ClusteredDataWriter updateWriter = new ClusteredDataWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        ClusteredPositionDeleteWriter deleteWriter = new ClusteredPositionDeleteWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        BasePositionDeltaWriter deltaWriter = new BasePositionDeltaWriter((PartitioningWriter)insertWriter, (PartitioningWriter)updateWriter, (PartitioningWriter)deleteWriter);
        deltaWriter.delete((CharSequence)dataFile1.location(), 2L, unpartitionedSpec, null);
        deltaWriter.delete((CharSequence)dataFile2.location(), 1L, partitionedSpec, (StructLike)this.partitionKey(partitionedSpec, "bbb"));
        deltaWriter.insert(this.toRow(10, "ccc"), partitionedSpec, (StructLike)this.partitionKey(partitionedSpec, "ccc"));
        deltaWriter.close();
        WriteResult result = deltaWriter.result();
        Object[] dataFiles = result.dataFiles();
        Object[] deleteFiles = result.deleteFiles();
        Object[] referencedDataFiles = result.referencedDataFiles();
        Assertions.assertThat((Object[])dataFiles).hasSize(1);
        Assertions.assertThat((Object[])deleteFiles).hasSize(2);
        Assertions.assertThat((Object[])referencedDataFiles).hasSize(2);
        RowDelta rowDelta = this.table.newRowDelta();
        for (Object dataFile : dataFiles) {
            rowDelta.addRows((DataFile)dataFile);
        }
        for (Object deleteFile : deleteFiles) {
            rowDelta.addDeletes((DeleteFile)deleteFile);
        }
        rowDelta.commit();
        ImmutableList expectedRows = ImmutableList.of(this.toRow(1, "aaa"), this.toRow(2, "aaa"), this.toRow(3, "bbb"), this.toRow(10, "ccc"));
        Assertions.assertThat((Collection)this.actualRowSet("*")).isEqualTo((Object)this.toSet((Iterable<T>)expectedRows));
    }
}

