/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.dell;

import com.emc.object.s3.S3Client;
import com.emc.object.s3.S3Config;
import com.emc.object.s3.jersey.S3JerseyClient;
import java.net.URI;
import java.util.Map;
import org.apache.iceberg.common.DynConstructors;
import org.apache.iceberg.dell.DellClientFactory;
import org.apache.iceberg.dell.DellProperties;
import org.apache.iceberg.util.PropertyUtil;

public class DellClientFactories {
    private DellClientFactories() {
    }

    public static DellClientFactory from(Map<String, String> properties) {
        String factoryImpl = PropertyUtil.propertyAsString(properties, (String)"client.factory", (String)DefaultDellClientFactory.class.getName());
        return DellClientFactories.loadClientFactory(factoryImpl, properties);
    }

    private static DellClientFactory loadClientFactory(String impl, Map<String, String> properties) {
        DellClientFactory factory;
        DynConstructors.Ctor ctor;
        try {
            ctor = DynConstructors.builder(DellClientFactory.class).hiddenImpl(impl, new Class[0]).buildChecked();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Cannot initialize DellClientFactory, missing no-arg constructor: %s", impl), e);
        }
        try {
            factory = (DellClientFactory)ctor.newInstance(new Object[0]);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format("Cannot initialize DellClientFactory, %s does not implement DellClientFactory.", impl), e);
        }
        factory.initialize(properties);
        return factory;
    }

    static class DefaultDellClientFactory
    implements DellClientFactory {
        private DellProperties dellProperties;

        DefaultDellClientFactory() {
        }

        @Override
        public S3Client ecsS3() {
            S3Config config = new S3Config(URI.create(this.dellProperties.ecsS3Endpoint()));
            ((S3Config)config.withIdentity(this.dellProperties.ecsS3AccessKeyId())).withSecretKey(this.dellProperties.ecsS3SecretAccessKey());
            return new S3JerseyClient(config);
        }

        @Override
        public void initialize(Map<String, String> properties) {
            this.dellProperties = new DellProperties(properties);
        }
    }
}

