/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.dell.ecs;

import com.emc.object.s3.S3Client;
import com.emc.object.s3.S3Exception;
import com.emc.object.s3.S3ObjectMetadata;
import org.apache.iceberg.dell.DellProperties;
import org.apache.iceberg.dell.ecs.EcsURI;
import org.apache.iceberg.metrics.MetricsContext;

abstract class BaseEcsFile {
    private final S3Client client;
    private final EcsURI uri;
    private final DellProperties dellProperties;
    private S3ObjectMetadata metadata;
    private final MetricsContext metrics;

    BaseEcsFile(S3Client client, EcsURI uri, DellProperties dellProperties, MetricsContext metrics) {
        this.client = client;
        this.uri = uri;
        this.dellProperties = dellProperties;
        this.metrics = metrics;
    }

    public String location() {
        return this.uri.location();
    }

    S3Client client() {
        return this.client;
    }

    EcsURI uri() {
        return this.uri;
    }

    public DellProperties dellProperties() {
        return this.dellProperties;
    }

    protected MetricsContext metrics() {
        return this.metrics;
    }

    public boolean exists() {
        try {
            this.getObjectMetadata();
            return true;
        }
        catch (S3Exception e) {
            if (e.getHttpCode() == 404) {
                return false;
            }
            throw e;
        }
    }

    protected S3ObjectMetadata getObjectMetadata() throws S3Exception {
        if (this.metadata == null) {
            this.metadata = this.client().getObjectMetadata(this.uri.bucket(), this.uri.name());
        }
        return this.metadata;
    }

    public String toString() {
        return this.uri.toString();
    }
}

