/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.dell.ecs;

import com.emc.object.s3.S3Client;
import com.emc.object.s3.request.PutObjectRequest;
import java.io.ByteArrayInputStream;
import java.nio.ByteBuffer;
import org.apache.iceberg.dell.ecs.EcsURI;
import org.apache.iceberg.io.PositionOutputStream;
import org.apache.iceberg.metrics.Counter;
import org.apache.iceberg.metrics.MetricsContext;

class EcsAppendOutputStream
extends PositionOutputStream {
    private final S3Client client;
    private final EcsURI uri;
    private final ByteBuffer localCache;
    private boolean firstPart = true;
    private long pos;
    private final Counter writeBytes;
    private final Counter writeOperations;

    private EcsAppendOutputStream(S3Client client, EcsURI uri, byte[] localCache, MetricsContext metrics) {
        this.client = client;
        this.uri = uri;
        this.localCache = ByteBuffer.wrap(localCache);
        this.writeBytes = metrics.counter("write.bytes", MetricsContext.Unit.BYTES);
        this.writeOperations = metrics.counter("write.operations");
    }

    static EcsAppendOutputStream create(S3Client client, EcsURI uri, MetricsContext metrics) {
        return EcsAppendOutputStream.createWithBufferSize(client, uri, 1024, metrics);
    }

    static EcsAppendOutputStream createWithBufferSize(S3Client client, EcsURI uri, int size, MetricsContext metrics) {
        return new EcsAppendOutputStream(client, uri, new byte[size], metrics);
    }

    public void write(int b) {
        if (!this.checkBuffer(1)) {
            this.flush();
        }
        this.localCache.put((byte)b);
        ++this.pos;
        this.writeBytes.increment();
        this.writeOperations.increment();
    }

    public void write(byte[] b, int off, int len) {
        if (!this.checkBuffer(len)) {
            this.flush();
        }
        if (this.checkBuffer(len)) {
            this.localCache.put(b, off, len);
        } else {
            this.flushBuffer(b, off, len);
        }
        this.pos += (long)len;
        this.writeBytes.increment(len);
        this.writeOperations.increment();
    }

    private boolean checkBuffer(int nextWrite) {
        return this.localCache.remaining() >= nextWrite;
    }

    private void flushBuffer(byte[] buffer, int offset, int length) {
        if (this.firstPart) {
            this.client.putObject(new PutObjectRequest(this.uri.bucket(), this.uri.name(), (Object)new ByteArrayInputStream(buffer, offset, length)));
            this.firstPart = false;
        } else {
            this.client.appendObject(this.uri.bucket(), this.uri.name(), (Object)new ByteArrayInputStream(buffer, offset, length));
        }
    }

    public long getPos() {
        return this.pos;
    }

    public void flush() {
        if (this.localCache.remaining() < this.localCache.capacity()) {
            this.localCache.flip();
            this.flushBuffer(this.localCache.array(), this.localCache.arrayOffset(), this.localCache.remaining());
            this.localCache.clear();
        }
    }

    public void close() {
        this.flush();
    }
}

