/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.dell.ecs;

import java.util.Map;
import org.apache.iceberg.BaseMetastoreTableOperations;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.dell.ecs.EcsCatalog;
import org.apache.iceberg.dell.ecs.EcsURI;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;

public class EcsTableOperations
extends BaseMetastoreTableOperations {
    public static final String ICEBERG_METADATA_LOCATION = "iceberg_metadata_location";
    private final String tableName;
    private final FileIO fileIO;
    private final EcsCatalog catalog;
    private final EcsURI tableObject;
    private String eTag;

    public EcsTableOperations(String tableName, EcsURI tableObject, FileIO fileIO, EcsCatalog catalog) {
        this.tableName = tableName;
        this.tableObject = tableObject;
        this.fileIO = fileIO;
        this.catalog = catalog;
    }

    protected String tableName() {
        return this.tableName;
    }

    public FileIO io() {
        return this.fileIO;
    }

    protected void doRefresh() {
        String metadataLocation;
        if (!this.catalog.objectMetadata(this.tableObject).isPresent()) {
            if (this.currentMetadataLocation() != null) {
                throw new NoSuchTableException("Metadata object %s is absent while refresh a loaded table. Maybe the table is deleted/moved.", new Object[]{this.tableObject});
            }
            metadataLocation = null;
        } else {
            EcsCatalog.Properties metadata = this.catalog.loadProperties(this.tableObject);
            this.eTag = metadata.eTag();
            metadataLocation = metadata.content().get(ICEBERG_METADATA_LOCATION);
            Preconditions.checkNotNull((Object)metadataLocation, (String)"Can't find location from table metadata %s", (Object)this.tableObject);
        }
        this.refreshFromMetadataLocation(metadataLocation);
    }

    protected void doCommit(TableMetadata base, TableMetadata metadata) {
        boolean newTable = base == null;
        String newMetadataLocation = this.writeNewMetadataIfRequired(newTable, metadata);
        if (base == null) {
            if (!this.catalog.putNewProperties(this.tableObject, this.buildProperties(newMetadataLocation))) {
                throw new CommitFailedException("Table is existing when create table %s", new Object[]{this.tableName()});
            }
        } else {
            String cachedETag = this.eTag;
            Preconditions.checkNotNull((Object)cachedETag, (Object)"E-Tag must be not null when update table");
            boolean result = this.catalog.updatePropertiesObject(this.tableObject, cachedETag, this.buildProperties(newMetadataLocation));
            if (!result) {
                throw new CommitFailedException("Replace failed, E-Tag %s mismatch for table %s", new Object[]{cachedETag, this.tableName()});
            }
        }
    }

    private Map<String, String> buildProperties(String metadataLocation) {
        return ImmutableMap.of((Object)ICEBERG_METADATA_LOCATION, (Object)metadataLocation);
    }
}

