/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.dell.ecs;

import com.emc.object.Range;
import com.emc.object.s3.S3Client;
import java.io.IOException;
import java.io.InputStream;
import org.apache.iceberg.dell.ecs.EcsURI;
import org.apache.iceberg.io.SeekableInputStream;
import org.apache.iceberg.metrics.Counter;
import org.apache.iceberg.metrics.MetricsContext;

class EcsSeekableInputStream
extends SeekableInputStream {
    private final S3Client client;
    private final EcsURI uri;
    private long newPos = 0L;
    private long pos = -1L;
    private InputStream internalStream;
    private final Counter readBytes;
    private final Counter readOperations;

    EcsSeekableInputStream(S3Client client, EcsURI uri, MetricsContext metrics) {
        this.client = client;
        this.uri = uri;
        this.readBytes = metrics.counter("read.bytes", MetricsContext.Unit.BYTES);
        this.readOperations = metrics.counter("read.operations");
    }

    public long getPos() {
        return this.newPos >= 0L ? this.newPos : this.pos;
    }

    public void seek(long inputNewPos) {
        if (this.pos == inputNewPos) {
            return;
        }
        this.newPos = inputNewPos;
    }

    public int read() throws IOException {
        this.checkAndUseNewPos();
        ++this.pos;
        this.readBytes.increment();
        this.readOperations.increment();
        return this.internalStream.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.checkAndUseNewPos();
        int delta = this.internalStream.read(b, off, len);
        this.pos += (long)delta;
        this.readBytes.increment(delta);
        this.readOperations.increment();
        return delta;
    }

    private void checkAndUseNewPos() throws IOException {
        if (this.newPos < 0L) {
            return;
        }
        if (this.newPos == this.pos) {
            this.newPos = -1L;
            return;
        }
        if (this.internalStream != null) {
            this.internalStream.close();
        }
        this.pos = this.newPos;
        this.internalStream = this.client.readObjectStream(this.uri.bucket(), this.uri.name(), Range.fromOffset((long)this.pos));
        this.newPos = -1L;
    }

    public void close() throws IOException {
        if (this.internalStream != null) {
            this.internalStream.close();
        }
    }
}

