/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.dell.ecs;

import com.emc.object.s3.S3Client;
import com.emc.object.s3.S3Exception;
import com.emc.object.s3.S3ObjectMetadata;
import com.emc.object.s3.bean.GetObjectResult;
import com.emc.object.s3.bean.ListObjectsResult;
import com.emc.object.s3.bean.S3Object;
import com.emc.object.s3.request.ListObjectsRequest;
import com.emc.object.s3.request.PutObjectRequest;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.iceberg.BaseMetastoreCatalog;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.dell.DellClientFactories;
import org.apache.iceberg.dell.ecs.EcsFileIO;
import org.apache.iceberg.dell.ecs.EcsTableOperations;
import org.apache.iceberg.dell.ecs.EcsURI;
import org.apache.iceberg.dell.ecs.PropertiesSerDesUtil;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.hadoop.Configurable;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.base.Strings;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.io.ByteStreams;
import org.apache.iceberg.util.LocationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EcsCatalog
extends BaseMetastoreCatalog
implements SupportsNamespaces,
Configurable<Object> {
    private static final String TABLE_OBJECT_SUFFIX = ".table";
    private static final String NAMESPACE_OBJECT_SUFFIX = ".namespace";
    private static final String PROPERTIES_VERSION_USER_METADATA_KEY = "iceberg_properties_version";
    private static final Logger LOG = LoggerFactory.getLogger(EcsCatalog.class);
    private S3Client client;
    private Object hadoopConf;
    private String catalogName;
    private EcsURI warehouseLocation;
    private FileIO fileIO;
    private CloseableGroup closeableGroup;
    private Map<String, String> catalogProperties;

    public void initialize(String name, Map<String, String> properties) {
        this.catalogProperties = ImmutableMap.copyOf(properties);
        String inputWarehouseLocation = properties.get("warehouse");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)inputWarehouseLocation) ? 1 : 0) != 0, (Object)"Cannot initialize EcsCatalog because warehousePath must not be null or empty");
        this.catalogName = name;
        this.warehouseLocation = new EcsURI(LocationUtil.stripTrailingSlash((String)inputWarehouseLocation));
        this.client = DellClientFactories.from(properties).ecsS3();
        this.fileIO = this.initializeFileIO(properties);
        this.closeableGroup = new CloseableGroup();
        this.closeableGroup.addCloseable(() -> ((S3Client)this.client).destroy());
        this.closeableGroup.addCloseable((Closeable)this.fileIO);
        this.closeableGroup.addCloseable((Closeable)this.metricsReporter());
        this.closeableGroup.setSuppressCloseFailure(true);
    }

    private FileIO initializeFileIO(Map<String, String> properties) {
        String fileIOImpl = properties.get("io-impl");
        if (fileIOImpl == null) {
            EcsFileIO io = new EcsFileIO();
            io.initialize(properties);
            return io;
        }
        return CatalogUtil.loadFileIO((String)fileIOImpl, properties, (Object)this.hadoopConf);
    }

    protected TableOperations newTableOps(TableIdentifier tableIdentifier) {
        return new EcsTableOperations(String.format("%s.%s", this.catalogName, tableIdentifier), this.tableURI(tableIdentifier), this.fileIO, this);
    }

    protected String defaultWarehouseLocation(TableIdentifier tableIdentifier) {
        return String.format("%s/%s", this.namespacePrefix(tableIdentifier.namespace()), tableIdentifier.name());
    }

    public List<TableIdentifier> listTables(Namespace namespace) {
        if (!namespace.isEmpty() && !this.namespaceExists(namespace)) {
            throw new NoSuchNamespaceException("Namespace %s does not exist", new Object[]{namespace});
        }
        String marker = null;
        ArrayList results = Lists.newArrayList();
        EcsURI prefix = new EcsURI(String.format("%s/", this.namespacePrefix(namespace)));
        do {
            ListObjectsResult listObjectsResult = this.client.listObjects(new ListObjectsRequest(prefix.bucket()).withDelimiter("/").withPrefix(prefix.name()).withMarker(marker));
            marker = listObjectsResult.getNextMarker();
            results.addAll(listObjectsResult.getObjects().stream().filter(s3Object -> s3Object.getKey().endsWith(TABLE_OBJECT_SUFFIX)).map(object -> this.parseTableId(namespace, prefix, (S3Object)object)).collect(Collectors.toList()));
        } while (marker != null);
        LOG.debug("Listing of namespace: {} resulted in the following tables: {}", (Object)namespace, (Object)results);
        return results;
    }

    private String namespacePrefix(Namespace namespace) {
        if (namespace.isEmpty()) {
            return this.warehouseLocation.location();
        }
        return String.format("%s/%s", this.warehouseLocation.location(), String.join((CharSequence)"/", namespace.levels()));
    }

    private TableIdentifier parseTableId(Namespace namespace, EcsURI prefix, S3Object s3Object) {
        String key = s3Object.getKey();
        Preconditions.checkArgument((boolean)key.startsWith(prefix.name()), (String)"List result should have same prefix", (Object)key, (Object)prefix);
        String tableName = key.substring(prefix.name().length(), key.length() - TABLE_OBJECT_SUFFIX.length());
        return TableIdentifier.of((Namespace)namespace, (String)tableName);
    }

    public boolean dropTable(TableIdentifier identifier, boolean purge) {
        if (!this.tableExists(identifier)) {
            return false;
        }
        EcsURI tableObjectURI = this.tableURI(identifier);
        if (purge) {
            TableOperations ops = this.newTableOps(identifier);
            TableMetadata current = ops.current();
            if (current == null) {
                return false;
            }
            CatalogUtil.dropTableData((FileIO)ops.io(), (TableMetadata)current);
        }
        this.client.deleteObject(tableObjectURI.bucket(), tableObjectURI.name());
        return true;
    }

    private EcsURI tableURI(TableIdentifier id) {
        return new EcsURI(String.format("%s/%s%s", this.namespacePrefix(id.namespace()), id.name(), TABLE_OBJECT_SUFFIX));
    }

    public void renameTable(TableIdentifier from, TableIdentifier to) {
        if (!this.namespaceExists(to.namespace())) {
            throw new NoSuchNamespaceException("Cannot rename %s to %s because namespace %s does not exist", new Object[]{from, to, to.namespace()});
        }
        if (this.tableExists(to)) {
            throw new AlreadyExistsException("Cannot rename %s because destination table %s exists", new Object[]{from, to});
        }
        EcsURI fromURI = this.tableURI(from);
        if (!this.objectMetadata(fromURI).isPresent()) {
            throw new NoSuchTableException("Cannot rename table because table %s does not exist", new Object[]{from});
        }
        Properties properties = this.loadProperties(fromURI);
        EcsURI toURI = this.tableURI(to);
        if (!this.putNewProperties(toURI, properties.content())) {
            throw new AlreadyExistsException("Cannot rename %s because destination table %s exists", new Object[]{from, to});
        }
        this.client.deleteObject(fromURI.bucket(), fromURI.name());
        LOG.info("Rename table {} to {}", (Object)from, (Object)to);
    }

    public void createNamespace(Namespace namespace, Map<String, String> properties) {
        EcsURI namespaceObject = this.namespaceURI(namespace);
        if (!this.putNewProperties(namespaceObject, properties)) {
            throw new AlreadyExistsException("namespace %s(%s) has already existed", new Object[]{namespace, namespaceObject});
        }
    }

    private EcsURI namespaceURI(Namespace namespace) {
        return new EcsURI(String.format("%s%s", this.namespacePrefix(namespace), NAMESPACE_OBJECT_SUFFIX));
    }

    public List<Namespace> listNamespaces(Namespace namespace) throws NoSuchNamespaceException {
        if (!namespace.isEmpty() && !this.namespaceExists(namespace)) {
            throw new NoSuchNamespaceException("Namespace %s does not exist", new Object[]{namespace});
        }
        String marker = null;
        ArrayList results = Lists.newArrayList();
        EcsURI prefix = new EcsURI(String.format("%s/", this.namespacePrefix(namespace)));
        do {
            ListObjectsResult listObjectsResult = this.client.listObjects(new ListObjectsRequest(prefix.bucket()).withDelimiter("/").withPrefix(prefix.name()).withMarker(marker));
            marker = listObjectsResult.getNextMarker();
            results.addAll(listObjectsResult.getObjects().stream().filter(s3Object -> s3Object.getKey().endsWith(NAMESPACE_OBJECT_SUFFIX)).map(object -> this.parseNamespace(namespace, prefix, (S3Object)object)).collect(Collectors.toList()));
        } while (marker != null);
        LOG.debug("Listing namespace {} returned namespaces: {}", (Object)namespace, (Object)results);
        return results;
    }

    private Namespace parseNamespace(Namespace parent, EcsURI prefix, S3Object s3Object) {
        String key = s3Object.getKey();
        Preconditions.checkArgument((boolean)key.startsWith(prefix.name()), (String)"List result should have same prefix", (Object)key, (Object)prefix);
        String namespaceName = key.substring(prefix.name().length(), key.length() - NAMESPACE_OBJECT_SUFFIX.length());
        String[] namespace = Arrays.copyOf(parent.levels(), parent.levels().length + 1);
        namespace[namespace.length - 1] = namespaceName;
        return Namespace.of((String[])namespace);
    }

    public Map<String, String> loadNamespaceMetadata(Namespace namespace) throws NoSuchNamespaceException {
        EcsURI namespaceObject = this.namespaceURI(namespace);
        if (!this.objectMetadata(namespaceObject).isPresent()) {
            throw new NoSuchNamespaceException("Namespace %s(%s) properties object is absent", new Object[]{namespace, namespaceObject});
        }
        Map<String, String> result = this.loadProperties(namespaceObject).content();
        LOG.debug("Loaded metadata for namespace {} found {}", (Object)namespace, result);
        return result;
    }

    public boolean dropNamespace(Namespace namespace) throws NamespaceNotEmptyException {
        if (!namespace.isEmpty() && !this.namespaceExists(namespace)) {
            throw new NoSuchNamespaceException("Namespace %s does not exist", new Object[]{namespace});
        }
        if (!this.listNamespaces(namespace).isEmpty() || !this.listTables(namespace).isEmpty()) {
            throw new NamespaceNotEmptyException("Namespace %s is not empty", new Object[]{namespace});
        }
        EcsURI namespaceObject = this.namespaceURI(namespace);
        this.client.deleteObject(namespaceObject.bucket(), namespaceObject.name());
        LOG.info("Dropped namespace: {}", (Object)namespace);
        return true;
    }

    public boolean setProperties(Namespace namespace, Map<String, String> properties) throws NoSuchNamespaceException {
        return this.updateProperties(namespace, r -> r.putAll(properties));
    }

    public boolean removeProperties(Namespace namespace, Set<String> properties) throws NoSuchNamespaceException {
        return this.updateProperties(namespace, r -> r.keySet().removeAll(properties));
    }

    public boolean updateProperties(Namespace namespace, Consumer<Map<String, String>> propertiesFn) throws NoSuchNamespaceException {
        Properties oldProperties = this.loadProperties(this.namespaceURI(namespace));
        LinkedHashMap<String, String> newProperties = new LinkedHashMap<String, String>(oldProperties.content());
        propertiesFn.accept(newProperties);
        LOG.debug("Successfully set properties {} for {}", newProperties.keySet(), (Object)namespace);
        return this.updatePropertiesObject(this.namespaceURI(namespace), oldProperties.eTag(), newProperties);
    }

    public boolean namespaceExists(Namespace namespace) {
        return this.objectMetadata(this.namespaceURI(namespace)).isPresent();
    }

    public boolean tableExists(TableIdentifier identifier) {
        return this.objectMetadata(this.tableURI(identifier)).isPresent();
    }

    private void checkURI(EcsURI uri) {
        Preconditions.checkArgument((boolean)uri.bucket().equals(this.warehouseLocation.bucket()), (String)"Properties object %s should be in same bucket %s", (Object)uri.location(), (Object)this.warehouseLocation.bucket());
        Preconditions.checkArgument((boolean)uri.name().startsWith(this.warehouseLocation.name()), (String)"Properties object %s should have the expected prefix %s", (Object)uri.location(), (Object)this.warehouseLocation.name());
    }

    public Optional<S3ObjectMetadata> objectMetadata(EcsURI uri) {
        this.checkURI(uri);
        try {
            return Optional.of(this.client.getObjectMetadata(uri.bucket(), uri.name()));
        }
        catch (S3Exception e) {
            if (e.getHttpCode() == 404) {
                return Optional.empty();
            }
            throw e;
        }
    }

    Properties loadProperties(EcsURI uri) {
        Map<String, String> content;
        this.checkURI(uri);
        GetObjectResult result = this.client.getObject(uri.bucket(), uri.name());
        S3ObjectMetadata objectMetadata = result.getObjectMetadata();
        String version = objectMetadata.getUserMetadata(PROPERTIES_VERSION_USER_METADATA_KEY);
        try (InputStream input = (InputStream)result.getObject();){
            content = PropertiesSerDesUtil.read(ByteStreams.toByteArray((InputStream)input), version);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new Properties(objectMetadata.getETag(), content);
    }

    boolean putNewProperties(EcsURI uri, Map<String, String> properties) {
        this.checkURI(uri);
        PutObjectRequest request = new PutObjectRequest(uri.bucket(), uri.name(), (Object)PropertiesSerDesUtil.toBytes(properties));
        request.setObjectMetadata(new S3ObjectMetadata().addUserMetadata(PROPERTIES_VERSION_USER_METADATA_KEY, PropertiesSerDesUtil.currentVersion()));
        request.setIfNoneMatch("*");
        try {
            this.client.putObject(request);
            return true;
        }
        catch (S3Exception e) {
            if ("PreconditionFailed".equals(e.getErrorCode())) {
                return false;
            }
            throw e;
        }
    }

    boolean updatePropertiesObject(EcsURI uri, String eTag, Map<String, String> properties) {
        this.checkURI(uri);
        LinkedHashMap<String, String> newProperties = new LinkedHashMap<String, String>(properties);
        PutObjectRequest request = new PutObjectRequest(uri.bucket(), uri.name(), (Object)PropertiesSerDesUtil.toBytes(newProperties));
        request.setObjectMetadata(new S3ObjectMetadata().addUserMetadata(PROPERTIES_VERSION_USER_METADATA_KEY, PropertiesSerDesUtil.currentVersion()));
        request.setIfMatch(eTag);
        try {
            this.client.putObject(request);
            return true;
        }
        catch (S3Exception e) {
            if ("PreconditionFailed".equals(e.getErrorCode())) {
                return false;
            }
            throw e;
        }
    }

    public String name() {
        return this.catalogName;
    }

    public void close() throws IOException {
        this.closeableGroup.close();
    }

    public void setConf(Object conf) {
        this.hadoopConf = conf;
    }

    protected Map<String, String> properties() {
        return this.catalogProperties == null ? ImmutableMap.of() : this.catalogProperties;
    }

    static class Properties {
        private final String eTag;
        private final Map<String, String> content;

        Properties(String eTag, Map<String, String> content) {
            this.eTag = eTag;
            this.content = content;
        }

        public String eTag() {
            return this.eTag;
        }

        public Map<String, String> content() {
            return this.content;
        }
    }
}

