/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.dell.ecs;

import com.emc.object.s3.S3Client;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iceberg.common.DynConstructors;
import org.apache.iceberg.dell.DellClientFactories;
import org.apache.iceberg.dell.DellClientFactory;
import org.apache.iceberg.dell.DellProperties;
import org.apache.iceberg.dell.ecs.EcsInputFile;
import org.apache.iceberg.dell.ecs.EcsOutputFile;
import org.apache.iceberg.dell.ecs.EcsURI;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.metrics.MetricsContext;
import org.apache.iceberg.util.SerializableSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EcsFileIO
implements FileIO {
    private static final Logger LOG = LoggerFactory.getLogger(EcsFileIO.class);
    private static final String DEFAULT_METRICS_IMPL = "org.apache.iceberg.hadoop.HadoopMetricsContext";
    private SerializableSupplier<S3Client> s3;
    private DellProperties dellProperties;
    private DellClientFactory dellClientFactory;
    private volatile transient S3Client client;
    private final AtomicBoolean isResourceClosed = new AtomicBoolean(false);
    private MetricsContext metrics = MetricsContext.nullMetrics();

    public InputFile newInputFile(String path) {
        return EcsInputFile.fromLocation(path, this.client(), this.dellProperties, this.metrics);
    }

    public OutputFile newOutputFile(String path) {
        return EcsOutputFile.fromLocation(path, this.client(), this.dellProperties, this.metrics);
    }

    public void deleteFile(String path) {
        EcsURI uri = new EcsURI(path);
        this.client().deleteObject(uri.bucket(), uri.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private S3Client client() {
        if (this.client == null) {
            EcsFileIO ecsFileIO = this;
            synchronized (ecsFileIO) {
                if (this.client == null) {
                    this.client = (S3Client)this.s3.get();
                }
            }
        }
        return this.client;
    }

    public void initialize(Map<String, String> properties) {
        this.dellProperties = new DellProperties(properties);
        this.dellClientFactory = DellClientFactories.from(properties);
        this.s3 = this.dellClientFactory::ecsS3;
        this.initMetrics(properties);
    }

    private void initMetrics(Map<String, String> properties) {
        try {
            DynConstructors.Ctor ctor = DynConstructors.builder(MetricsContext.class).hiddenImpl(DEFAULT_METRICS_IMPL, new Class[]{String.class}).buildChecked();
            MetricsContext context = (MetricsContext)ctor.newInstance(new Object[]{"ecs"});
            context.initialize(properties);
            this.metrics = context;
        }
        catch (ClassCastException | NoClassDefFoundError | NoSuchMethodException e) {
            LOG.warn("Unable to load metrics class: '{}', falling back to null metrics", (Object)DEFAULT_METRICS_IMPL);
        }
    }

    public void close() {
        if (this.isResourceClosed.compareAndSet(false, true)) {
            this.client.destroy();
        }
    }
}

