/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.dell.ecs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesSerDesUtil {
    private static final String CURRENT_VERSION = "0";
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesSerDesUtil.class);

    private PropertiesSerDesUtil() {
    }

    public static Map<String, String> read(byte[] content, String version) {
        Preconditions.checkArgument((boolean)CURRENT_VERSION.equals(version), (String)"Properties version is not match", (Object)version);
        Properties jdkProperties = new Properties();
        try (InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(content), StandardCharsets.UTF_8);){
            jdkProperties.load(reader);
        }
        catch (IOException e) {
            LOG.error("Fail to read properties", (Throwable)e);
            throw new UncheckedIOException(e);
        }
        Set<String> propertyNames = jdkProperties.stringPropertyNames();
        HashMap properties = Maps.newHashMap();
        for (String name : propertyNames) {
            properties.put(name, jdkProperties.getProperty(name));
        }
        return Collections.unmodifiableMap(properties);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] toBytes(Map<String, String> value) {
        Properties jdkProperties = new Properties();
        for (Map.Entry<String, String> entry : value.entrySet()) {
            jdkProperties.setProperty(entry.getKey(), entry.getValue());
        }
        try {
            Throwable throwable = null;
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                byte[] byArray;
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)output, StandardCharsets.UTF_8);
                Throwable throwable2 = null;
                try {
                    jdkProperties.store(writer, null);
                    byArray = output.toByteArray();
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            PropertiesSerDesUtil.$closeResource(throwable2, writer);
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                PropertiesSerDesUtil.$closeResource(throwable2, writer);
                return byArray;
            }
        }
        catch (IOException e) {
            LOG.error("Fail to store properties {} to file", value, (Object)e);
            throw new UncheckedIOException(e);
        }
    }

    public static String currentVersion() {
        return CURRENT_VERSION;
    }
}

