/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.actions;

import java.util.List;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.Table;
import org.apache.iceberg.actions.BaseRewriteDataFilesAction;
import org.apache.iceberg.flink.source.RowDataRewriter;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class RewriteDataFilesAction
extends BaseRewriteDataFilesAction<RewriteDataFilesAction> {
    private StreamExecutionEnvironment env;
    private int maxParallelism;

    public RewriteDataFilesAction(StreamExecutionEnvironment env, Table table) {
        super(table);
        this.env = env;
        this.maxParallelism = env.getParallelism();
    }

    protected FileIO fileIO() {
        return this.table().io();
    }

    protected List<DataFile> rewriteDataForTasks(List<CombinedScanTask> combinedScanTasks) {
        int size = combinedScanTasks.size();
        int parallelism = Math.min(size, this.maxParallelism);
        DataStreamSource dataStream = this.env.fromCollection(combinedScanTasks);
        RowDataRewriter rowDataRewriter = new RowDataRewriter(this.table(), this.caseSensitive(), this.fileIO(), this.encryptionManager());
        try {
            return rowDataRewriter.rewriteDataForTasks((DataStream<CombinedScanTask>)dataStream, parallelism);
        }
        catch (Exception e) {
            throw new RuntimeException("Rewrite data file error.", e);
        }
    }

    protected RewriteDataFilesAction self() {
        return this;
    }

    public RewriteDataFilesAction maxParallelism(int parallelism) {
        Preconditions.checkArgument((parallelism > 0 ? 1 : 0) != 0, (String)"Invalid max parallelism %s", (int)parallelism);
        this.maxParallelism = parallelism;
        return this;
    }
}

