/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.assigner;

import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;
import org.apache.iceberg.flink.source.split.IcebergSourceSplit;

@Internal
public class GetSplitResult {
    private final Status status;
    private final IcebergSourceSplit split;
    private static final GetSplitResult UNAVAILABLE = new GetSplitResult(Status.UNAVAILABLE);
    private static final GetSplitResult CONSTRAINED = new GetSplitResult(Status.CONSTRAINED);

    private GetSplitResult(Status status) {
        this.status = status;
        this.split = null;
    }

    private GetSplitResult(IcebergSourceSplit split) {
        Preconditions.checkNotNull((Object)split, (String)"Split cannot be null");
        this.status = Status.AVAILABLE;
        this.split = split;
    }

    public Status status() {
        return this.status;
    }

    public IcebergSourceSplit split() {
        return this.split;
    }

    public static GetSplitResult unavailable() {
        return UNAVAILABLE;
    }

    public static GetSplitResult constrained() {
        return CONSTRAINED;
    }

    public static GetSplitResult forSplit(IcebergSourceSplit split) {
        return new GetSplitResult(split);
    }

    public static enum Status {
        AVAILABLE,
        CONSTRAINED,
        UNAVAILABLE;

    }
}

