/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.split;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.iceberg.flink.source.split.IcebergSourceSplit;

@Internal
public class IcebergSourceSplitSerializer
implements SimpleVersionedSerializer<IcebergSourceSplit> {
    private static final int VERSION = 2;
    private final boolean caseSensitive;

    public IcebergSourceSplitSerializer(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public int getVersion() {
        return 2;
    }

    public byte[] serialize(IcebergSourceSplit split) throws IOException {
        return split.serializeV2();
    }

    public IcebergSourceSplit deserialize(int version, byte[] serialized) throws IOException {
        switch (version) {
            case 1: {
                return IcebergSourceSplit.deserializeV1(serialized);
            }
            case 2: {
                return IcebergSourceSplit.deserializeV2(serialized, this.caseSensitive);
            }
        }
        throw new IOException(String.format("Failed to deserialize IcebergSourceSplit. Encountered unsupported version: %d. Supported version are [1]", version));
    }
}

