/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.flink.util.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.flink.TestBase;
import org.apache.iceberg.hadoop.HadoopCatalog;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={ParameterizedTestExtension.class})
public abstract class CatalogTestBase
extends TestBase {
    protected static final String DATABASE = "db";
    @TempDir
    protected File hiveWarehouse;
    @TempDir
    protected File hadoopWarehouse;
    @Parameter(index=0)
    protected String catalogName;
    @Parameter(index=1)
    protected Namespace baseNamespace;
    protected Catalog validationCatalog;
    protected SupportsNamespaces validationNamespaceCatalog;
    protected Map<String, String> config = Maps.newHashMap();
    protected String flinkDatabase;
    protected Namespace icebergNamespace;
    protected boolean isHadoopCatalog;

    @Parameters(name="catalogName={0}, baseNamespace={1}")
    protected static List<Object[]> parameters() {
        return Arrays.asList({"testhive", Namespace.empty()}, {"testhadoop", Namespace.empty()}, {"testhadoop_basenamespace", Namespace.of((String[])new String[]{"l0", "l1"})});
    }

    @BeforeEach
    public void before() {
        this.isHadoopCatalog = this.catalogName.startsWith("testhadoop");
        this.validationCatalog = this.isHadoopCatalog ? new HadoopCatalog((Configuration)hiveConf, "file:" + this.hadoopWarehouse.getPath()) : catalog;
        this.validationNamespaceCatalog = (SupportsNamespaces)this.validationCatalog;
        this.config.put("type", "iceberg");
        if (!this.baseNamespace.isEmpty()) {
            this.config.put("base-namespace", this.baseNamespace.toString());
        }
        if (this.isHadoopCatalog) {
            this.config.put("catalog-type", "hadoop");
        } else {
            this.config.put("catalog-type", "hive");
            this.config.put("uri", CatalogTestBase.getURI(hiveConf));
        }
        this.config.put("warehouse", String.format("file://%s", this.warehouseRoot()));
        this.flinkDatabase = this.catalogName + "." + DATABASE;
        this.icebergNamespace = Namespace.of((String[])ArrayUtils.concat((String[])this.baseNamespace.levels(), (String[])new String[]{DATABASE}));
        this.sql("CREATE CATALOG %s WITH %s", this.catalogName, CatalogTestBase.toWithClause(this.config));
    }

    @AfterEach
    public void clean() {
        this.dropCatalog(this.catalogName, true);
    }

    protected String warehouseRoot() {
        if (this.isHadoopCatalog) {
            return this.hadoopWarehouse.getAbsolutePath();
        }
        return this.hiveWarehouse.getAbsolutePath();
    }

    protected String getFullQualifiedTableName(String tableName) {
        ArrayList levels = Lists.newArrayList((Object[])this.icebergNamespace.levels());
        levels.add(tableName);
        return Joiner.on((char)'.').join((Iterable)levels);
    }

    static String getURI(HiveConf conf) {
        return conf.get(HiveConf.ConfVars.METASTOREURIS.varname);
    }

    static String toWithClause(Map<String, String> props) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        int propCount = 0;
        for (Map.Entry<String, String> entry : props.entrySet()) {
            if (propCount > 0) {
                builder.append(",");
            }
            builder.append("'").append(entry.getKey()).append("'").append("=").append("'").append(entry.getValue()).append("'");
            ++propCount;
        }
        builder.append(")");
        return builder.toString();
    }
}

