/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.io.File;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.flink.CatalogLoader;
import org.apache.iceberg.flink.TableLoader;
import org.apache.iceberg.hadoop.HadoopCatalog;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.junit.Assert;
import org.junit.rules.ExternalResource;
import org.junit.rules.TemporaryFolder;

public class HadoopCatalogResource
extends ExternalResource {
    protected final TemporaryFolder temporaryFolder;
    protected final String database;
    protected final String tableName;
    protected Catalog catalog;
    protected CatalogLoader catalogLoader;
    protected String warehouse;
    protected TableLoader tableLoader;

    public HadoopCatalogResource(TemporaryFolder temporaryFolder, String database, String tableName) {
        this.temporaryFolder = temporaryFolder;
        this.database = database;
        this.tableName = tableName;
    }

    protected void before() throws Throwable {
        File warehouseFile = this.temporaryFolder.newFolder();
        Assert.assertTrue((boolean)warehouseFile.delete());
        this.warehouse = "file:" + warehouseFile;
        this.catalogLoader = CatalogLoader.hadoop((String)"hadoop", (Configuration)new Configuration(), (Map)ImmutableMap.of((Object)"warehouse", (Object)this.warehouse));
        this.catalog = this.catalogLoader.loadCatalog();
        this.tableLoader = TableLoader.fromCatalog((CatalogLoader)this.catalogLoader, (TableIdentifier)TableIdentifier.of((String[])new String[]{this.database, this.tableName}));
    }

    protected void after() {
        try {
            this.catalog.dropTable(TableIdentifier.of((String[])new String[]{this.database, this.tableName}));
            ((HadoopCatalog)this.catalog).close();
            this.tableLoader.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to close catalog resource");
        }
    }

    public TableLoader tableLoader() {
        return this.tableLoader;
    }

    public Catalog catalog() {
        return this.catalog;
    }

    public CatalogLoader catalogLoader() {
        return this.catalogLoader;
    }

    public String warehouse() {
        return this.warehouse;
    }
}

