/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.flink.CatalogLoader;
import org.apache.iceberg.flink.TableLoader;
import org.apache.iceberg.flink.TestBase;
import org.apache.iceberg.hadoop.HadoopFileIO;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestCatalogTableLoader
extends TestBase {
    private static File warehouse = null;
    private static final TableIdentifier IDENTIFIER = TableIdentifier.of((String[])new String[]{"default", "my_table"});
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"f1", (Type)Types.StringType.get())});

    @BeforeAll
    public static void createWarehouse() throws IOException {
        warehouse = File.createTempFile("warehouse", null);
        Assertions.assertThat((boolean)warehouse.delete()).isTrue();
        hiveConf.set("my_key", "my_value");
    }

    @AfterAll
    public static void dropWarehouse() throws IOException {
        if (warehouse != null && warehouse.exists()) {
            Path warehousePath = new Path(warehouse.getAbsolutePath());
            FileSystem fs = warehousePath.getFileSystem((Configuration)hiveConf);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.delete(warehousePath, true)).as("Failed to delete " + warehousePath, new Object[0])).isTrue();
        }
    }

    @Test
    public void testHadoopTableLoader() throws IOException, ClassNotFoundException {
        String location = "file:" + warehouse + "/my_table";
        new HadoopTables((Configuration)hiveConf).create(SCHEMA, location);
        TestCatalogTableLoader.validateTableLoader(TableLoader.fromHadoopTable((String)location, (Configuration)hiveConf));
    }

    @Test
    public void testHiveCatalogTableLoader() throws IOException, ClassNotFoundException {
        CatalogLoader loader = CatalogLoader.hive((String)"my_catalog", (Configuration)hiveConf, (Map)Maps.newHashMap());
        TestCatalogTableLoader.javaSerdes(loader).loadCatalog().createTable(IDENTIFIER, SCHEMA);
        CatalogLoader catalogLoader = CatalogLoader.hive((String)"my_catalog", (Configuration)hiveConf, (Map)Maps.newHashMap());
        TestCatalogTableLoader.validateTableLoader(TableLoader.fromCatalog((CatalogLoader)catalogLoader, (TableIdentifier)IDENTIFIER));
    }

    private static void validateTableLoader(TableLoader loader) throws IOException, ClassNotFoundException {
        copied.open();
        try (TableLoader copied = TestCatalogTableLoader.javaSerdes(loader);){
            TestCatalogTableLoader.validateHadoopConf(copied.loadTable());
        }
    }

    private static void validateHadoopConf(Table table) {
        FileIO io = table.io();
        ((ObjectAssert)Assertions.assertThat((Object)io).as("FileIO should be a HadoopFileIO", new Object[0])).isInstanceOf(HadoopFileIO.class);
        HadoopFileIO hadoopIO = (HadoopFileIO)io;
        Assertions.assertThat((String)hadoopIO.conf().get("my_key")).isEqualTo("my_value");
    }

    private static <T> T javaSerdes(T object) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(bytes);){
            out.writeObject(object);
        }
        var3_3 = null;
        try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes.toByteArray()));){
            Object object2 = in.readObject();
            return (T)object2;
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }
}

