/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.table.catalog.exceptions.DatabaseNotEmptyException;
import org.apache.flink.types.Row;
import org.apache.iceberg.Schema;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.flink.CatalogTestBase;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.TestTemplate;

public class TestFlinkCatalogDatabase
extends CatalogTestBase {
    @Override
    @AfterEach
    public void clean() {
        this.sql("DROP TABLE IF EXISTS %s.tl", this.flinkDatabase);
        this.sql("DROP DATABASE IF EXISTS %s", this.flinkDatabase);
        super.clean();
    }

    @TestTemplate
    public void testCreateNamespace() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace)).as("Database should not already exist", new Object[0])).isFalse();
        this.sql("CREATE DATABASE %s", this.flinkDatabase);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace)).as("Database should exist", new Object[0])).isTrue();
        this.sql("CREATE DATABASE IF NOT EXISTS %s", this.flinkDatabase);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace)).as("Database should still exist", new Object[0])).isTrue();
        this.sql("DROP DATABASE IF EXISTS %s", this.flinkDatabase);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace)).as("Database should be dropped", new Object[0])).isFalse();
        this.sql("CREATE DATABASE IF NOT EXISTS %s", this.flinkDatabase);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace)).as("Database should be created", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testDropEmptyDatabase() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace)).as("Namespace should not already exist", new Object[0])).isFalse();
        this.sql("CREATE DATABASE %s", this.flinkDatabase);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace)).as("Namespace should exist", new Object[0])).isTrue();
        this.sql("DROP DATABASE %s", this.flinkDatabase);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace)).as("Namespace should have been dropped", new Object[0])).isFalse();
    }

    @TestTemplate
    public void testDropNonEmptyNamespace() {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isHadoopCatalog).as("Hadoop catalog throws IOException: Directory is not empty.", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace)).as("Namespace should not already exist", new Object[0])).isFalse();
        this.sql("CREATE DATABASE %s", this.flinkDatabase);
        this.validationCatalog.createTable(TableIdentifier.of((Namespace)this.icebergNamespace, (String)"tl"), new Schema(new Types.NestedField[]{Types.NestedField.optional((int)0, (String)"id", (Type)Types.LongType.get())}));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace)).as("Namespace should exist", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationCatalog.tableExists(TableIdentifier.of((Namespace)this.icebergNamespace, (String)"tl"))).as("Table should exist", new Object[0])).isTrue();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("DROP DATABASE %s", this.flinkDatabase)).cause().isInstanceOf(DatabaseNotEmptyException.class)).hasMessage(String.format("Database %s in catalog %s is not empty.", "db", this.catalogName));
        this.sql("DROP TABLE %s.tl", this.flinkDatabase);
    }

    @TestTemplate
    public void testListTables() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace)).as("Namespace should not already exist", new Object[0])).isFalse();
        this.sql("CREATE DATABASE %s", this.flinkDatabase);
        this.sql("USE CATALOG %s", this.catalogName);
        this.sql("USE %s", "db");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace)).as("Namespace should exist", new Object[0])).isTrue();
        Assertions.assertThat(this.sql("SHOW TABLES", new Object[0])).isEmpty();
        this.validationCatalog.createTable(TableIdentifier.of((Namespace)this.icebergNamespace, (String)"tl"), new Schema(new Types.NestedField[]{Types.NestedField.optional((int)0, (String)"id", (Type)Types.LongType.get())}));
        List<Row> tables = this.sql("SHOW TABLES", new Object[0]);
        Assertions.assertThat(tables).hasSize(1);
        ((AbstractStringAssert)Assertions.assertThat((String)"tl").as("Table name should match", new Object[0])).isEqualTo(tables.get(0).getField(0));
    }

    @TestTemplate
    public void testListNamespace() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace)).as("Namespace should not already exist", new Object[0])).isFalse();
        this.sql("CREATE DATABASE %s", this.flinkDatabase);
        this.sql("USE CATALOG %s", this.catalogName);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace)).as("Namespace should exist", new Object[0])).isTrue();
        List<Row> databases = this.sql("SHOW DATABASES", new Object[0]);
        if (this.isHadoopCatalog) {
            Assertions.assertThat(databases).hasSize(1);
            ((ObjectAssert)Assertions.assertThat((Object)databases.get(0).getField(0)).as("Should have db database", new Object[0])).isEqualTo((Object)"db");
            if (!this.baseNamespace.isEmpty()) {
                this.validationNamespaceCatalog.createNamespace(Namespace.of((String[])new String[]{this.baseNamespace.level(0), "UNKNOWN_NAMESPACE"}));
                databases = this.sql("SHOW DATABASES", new Object[0]);
                Assertions.assertThat(databases).hasSize(1);
                ((ObjectAssert)Assertions.assertThat((Object)databases.get(0).getField(0)).as("Should have db database", new Object[0])).isEqualTo((Object)"db");
            }
        } else {
            ((ListAssert)Assertions.assertThat(databases).as("Should have db database", new Object[0])).anyMatch(d -> Objects.equals(d.getField(0), "db"));
        }
    }

    @TestTemplate
    public void testCreateNamespaceWithMetadata() {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isHadoopCatalog).as("HadoopCatalog does not support namespace metadata", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace)).as("Namespace should not already exist", new Object[0])).isFalse();
        this.sql("CREATE DATABASE %s WITH ('prop'='value')", this.flinkDatabase);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace)).as("Namespace should exist", new Object[0])).isTrue();
        Map nsMetadata = this.validationNamespaceCatalog.loadNamespaceMetadata(this.icebergNamespace);
        Assertions.assertThat((Map)nsMetadata).containsEntry((Object)"prop", (Object)"value");
    }

    @TestTemplate
    public void testCreateNamespaceWithComment() {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isHadoopCatalog).as("HadoopCatalog does not support namespace metadata", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace)).as("Namespace should not already exist", new Object[0])).isFalse();
        this.sql("CREATE DATABASE %s COMMENT 'namespace doc'", this.flinkDatabase);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace)).as("Namespace should exist", new Object[0])).isTrue();
        Map nsMetadata = this.validationNamespaceCatalog.loadNamespaceMetadata(this.icebergNamespace);
        Assertions.assertThat((Map)nsMetadata).containsEntry((Object)"comment", (Object)"namespace doc");
    }

    @TestTemplate
    public void testCreateNamespaceWithLocation() throws Exception {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isHadoopCatalog).as("HadoopCatalog does not support namespace metadata", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace)).as("Namespace should not already exist", new Object[0])).isFalse();
        Path location = this.temporaryDirectory.getRoot();
        this.sql("CREATE DATABASE %s WITH ('location'='%s')", this.flinkDatabase, location);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace)).as("Namespace should exist", new Object[0])).isTrue();
        Map nsMetadata = this.validationNamespaceCatalog.loadNamespaceMetadata(this.icebergNamespace);
        Assertions.assertThat((Map)nsMetadata).containsEntry((Object)"location", (Object)("file:" + location.getRoot()));
    }

    @TestTemplate
    public void testSetProperties() {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isHadoopCatalog).as("HadoopCatalog does not support namespace metadata", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace)).as("Namespace should not already exist", new Object[0])).isFalse();
        this.sql("CREATE DATABASE %s", this.flinkDatabase);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace)).as("Namespace should exist", new Object[0])).isTrue();
        Map defaultMetadata = this.validationNamespaceCatalog.loadNamespaceMetadata(this.icebergNamespace);
        Assertions.assertThat((Map)defaultMetadata).doesNotContainKey((Object)"prop");
        this.sql("ALTER DATABASE %s SET ('prop'='value')", this.flinkDatabase);
        Map nsMetadata = this.validationNamespaceCatalog.loadNamespaceMetadata(this.icebergNamespace);
        Assertions.assertThat((Map)nsMetadata).containsEntry((Object)"prop", (Object)"value");
    }

    @TestTemplate
    public void testHadoopNotSupportMeta() {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isHadoopCatalog).as("HadoopCatalog does not support namespace metadata", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace)).as("Namespace should not already exist", new Object[0])).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CREATE DATABASE %s WITH ('prop'='value')", this.flinkDatabase)).cause().isInstanceOf(UnsupportedOperationException.class)).hasMessage(String.format("Cannot create namespace %s: metadata is not supported", this.icebergNamespace));
    }
}

