/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.ReplacePartitions;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.flink.CatalogTestBase;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;

public class TestFlinkCatalogTable
extends CatalogTestBase {
    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.sql("CREATE DATABASE %s", this.flinkDatabase);
        this.sql("USE CATALOG %s", this.catalogName);
        this.sql("USE %s", "db");
    }

    @AfterEach
    public void cleanNamespaces() {
        this.sql("DROP TABLE IF EXISTS %s.tl", this.flinkDatabase);
        this.sql("DROP TABLE IF EXISTS %s.tl2", this.flinkDatabase);
        this.sql("DROP DATABASE IF EXISTS %s", this.flinkDatabase);
        super.clean();
    }

    @TestTemplate
    public void testGetTable() {
        this.sql("CREATE TABLE tl(id BIGINT, strV STRING)", new Object[0]);
        Table table = this.validationCatalog.loadTable(TableIdentifier.of((Namespace)this.icebergNamespace, (String)"tl"));
        Schema iSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"strV", (Type)Types.StringType.get())});
        ((AbstractStringAssert)Assertions.assertThat((String)table.schema().toString()).as("Should load the expected iceberg schema", new Object[0])).isEqualTo(iSchema.toString());
    }

    @TestTemplate
    public void testRenameTable() {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isHadoopCatalog).as("HadoopCatalog does not support rename table", new Object[0])).isFalse();
        Schema tableSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)0, (String)"id", (Type)Types.LongType.get())});
        this.validationCatalog.createTable(TableIdentifier.of((Namespace)this.icebergNamespace, (String)"tl"), tableSchema);
        this.sql("ALTER TABLE tl RENAME TO tl2", new Object[0]);
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> this.getTableEnv().from("tl")).isInstanceOf(ValidationException.class)).hasMessage("Table `tl` was not found.");
        Schema actualSchema = FlinkSchemaUtil.convert((TableSchema)this.getTableEnv().from("tl2").getSchema());
        Assertions.assertThat((Object)tableSchema.asStruct()).isEqualTo((Object)actualSchema.asStruct());
    }

    @TestTemplate
    public void testCreateTable() throws TableNotExistException {
        this.sql("CREATE TABLE tl(id BIGINT)", new Object[0]);
        Table table = this.table("tl");
        Assertions.assertThat((Object)table.schema().asStruct()).isEqualTo((Object)new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get())}).asStruct());
        CatalogTable catalogTable = this.catalogTable("tl");
        Assertions.assertThat((Object)catalogTable.getSchema()).isEqualTo((Object)TableSchema.builder().field("id", DataTypes.BIGINT()).build());
    }

    @TestTemplate
    public void testCreateTableWithPrimaryKey() throws Exception {
        this.sql("CREATE TABLE tl(id BIGINT, data STRING, key STRING PRIMARY KEY NOT ENFORCED)", new Object[0]);
        Table table = this.table("tl");
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)table.schema().identifierFieldIds()).as("Should have the expected row key.", new Object[0])).isEqualTo((Object)Sets.newHashSet((Object[])new Integer[]{table.schema().findField("key").fieldId()}));
        CatalogTable catalogTable = this.catalogTable("tl");
        Optional uniqueConstraintOptional = catalogTable.getSchema().getPrimaryKey();
        Assertions.assertThat((Optional)uniqueConstraintOptional).isPresent();
        Assertions.assertThat((List)((UniqueConstraint)uniqueConstraintOptional.get()).getColumns()).containsExactly((Object[])new String[]{"key"});
    }

    @TestTemplate
    public void testCreateTableWithMultiColumnsInPrimaryKey() throws Exception {
        this.sql("CREATE TABLE tl(id BIGINT, data STRING, CONSTRAINT pk_constraint PRIMARY KEY(data, id) NOT ENFORCED)", new Object[0]);
        Table table = this.table("tl");
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)table.schema().identifierFieldIds()).as("Should have the expected RowKey", new Object[0])).isEqualTo((Object)Sets.newHashSet((Object[])new Integer[]{table.schema().findField("id").fieldId(), table.schema().findField("data").fieldId()}));
        CatalogTable catalogTable = this.catalogTable("tl");
        Optional uniqueConstraintOptional = catalogTable.getSchema().getPrimaryKey();
        Assertions.assertThat((Optional)uniqueConstraintOptional).isPresent();
        Assertions.assertThat((List)((UniqueConstraint)uniqueConstraintOptional.get()).getColumns()).containsExactly((Object[])new String[]{"id", "data"});
    }

    @TestTemplate
    public void testCreateTableIfNotExists() {
        this.sql("CREATE TABLE tl(id BIGINT)", new Object[0]);
        Assertions.assertThat((Object)this.table("tl")).isNotNull();
        this.sql("DROP TABLE tl", new Object[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.table("tl")).isInstanceOf(NoSuchTableException.class)).hasMessage("Table does not exist: " + this.getFullQualifiedTableName("tl"));
        this.sql("CREATE TABLE IF NOT EXISTS tl(id BIGINT)", new Object[0]);
        Assertions.assertThat((Map)this.table("tl").properties()).doesNotContainKey((Object)"key");
        this.table("tl").updateProperties().set("key", "value").commit();
        Assertions.assertThat((Map)this.table("tl").properties()).containsEntry((Object)"key", (Object)"value");
        this.sql("CREATE TABLE IF NOT EXISTS tl(id BIGINT)", new Object[0]);
        Assertions.assertThat((Map)this.table("tl").properties()).containsEntry((Object)"key", (Object)"value");
    }

    @TestTemplate
    public void testCreateTableLike() throws TableNotExistException {
        this.sql("CREATE TABLE tl(id BIGINT)", new Object[0]);
        this.sql("CREATE TABLE tl2 LIKE tl", new Object[0]);
        Table table = this.table("tl2");
        Assertions.assertThat((Object)table.schema().asStruct()).isEqualTo((Object)new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get())}).asStruct());
        CatalogTable catalogTable = this.catalogTable("tl2");
        Assertions.assertThat((Object)catalogTable.getSchema()).isEqualTo((Object)TableSchema.builder().field("id", DataTypes.BIGINT()).build());
    }

    @TestTemplate
    public void testCreateTableLocation() {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isHadoopCatalog).as("HadoopCatalog does not support creating table with location", new Object[0])).isFalse();
        this.sql("CREATE TABLE tl(id BIGINT) WITH ('location'='file:///tmp/location')", new Object[0]);
        Table table = this.table("tl");
        Assertions.assertThat((Object)table.schema().asStruct()).isEqualTo((Object)new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get())}).asStruct());
        Assertions.assertThat((String)table.location()).isEqualTo("file:///tmp/location");
    }

    @TestTemplate
    public void testCreatePartitionTable() throws TableNotExistException {
        this.sql("CREATE TABLE tl(id BIGINT, dt STRING) PARTITIONED BY(dt)", new Object[0]);
        Table table = this.table("tl");
        Assertions.assertThat((Object)table.schema().asStruct()).isEqualTo((Object)new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"dt", (Type)Types.StringType.get())}).asStruct());
        Assertions.assertThat((Object)table.spec()).isEqualTo((Object)PartitionSpec.builderFor((Schema)table.schema()).identity("dt").build());
        CatalogTable catalogTable = this.catalogTable("tl");
        Assertions.assertThat((Object)catalogTable.getSchema()).isEqualTo((Object)TableSchema.builder().field("id", DataTypes.BIGINT()).field("dt", DataTypes.STRING()).build());
        Assertions.assertThat((List)catalogTable.getPartitionKeys()).isEqualTo(Collections.singletonList("dt"));
    }

    @TestTemplate
    public void testCreateTableWithFormatV2ThroughTableProperty() throws Exception {
        this.sql("CREATE TABLE tl(id BIGINT) WITH ('format-version'='2')", new Object[0]);
        Table table = this.table("tl");
        Assertions.assertThat((int)((BaseTable)table).operations().current().formatVersion()).isEqualTo(2);
    }

    @TestTemplate
    public void testUpgradeTableWithFormatV2ThroughTableProperty() throws Exception {
        this.sql("CREATE TABLE tl(id BIGINT) WITH ('format-version'='1')", new Object[0]);
        Table table = this.table("tl");
        TableOperations ops = ((BaseTable)table).operations();
        ((AbstractIntegerAssert)Assertions.assertThat((int)ops.refresh().formatVersion()).as("should create table using format v1", new Object[0])).isEqualTo(1);
        this.sql("ALTER TABLE tl SET('format-version'='2')", new Object[0]);
        ((AbstractIntegerAssert)Assertions.assertThat((int)ops.refresh().formatVersion()).as("should update table to use format v2", new Object[0])).isEqualTo(2);
    }

    @TestTemplate
    public void testDowngradeTableToFormatV1ThroughTablePropertyFails() throws Exception {
        this.sql("CREATE TABLE tl(id BIGINT) WITH ('format-version'='2')", new Object[0]);
        Table table = this.table("tl");
        TableOperations ops = ((BaseTable)table).operations();
        ((AbstractIntegerAssert)Assertions.assertThat((int)ops.refresh().formatVersion()).as("should create table using format v2", new Object[0])).isEqualTo(2);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE tl SET('format-version'='1')", new Object[0])).rootCause().isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot downgrade v2 table to v1");
    }

    @TestTemplate
    public void testLoadTransformPartitionTable() throws TableNotExistException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)0, (String)"id", (Type)Types.LongType.get())});
        this.validationCatalog.createTable(TableIdentifier.of((Namespace)this.icebergNamespace, (String)"tl"), schema, PartitionSpec.builderFor((Schema)schema).bucket("id", 100).build());
        CatalogTable catalogTable = this.catalogTable("tl");
        Assertions.assertThat((Object)catalogTable.getSchema()).isEqualTo((Object)TableSchema.builder().field("id", DataTypes.BIGINT()).build());
        Assertions.assertThat((List)catalogTable.getPartitionKeys()).isEmpty();
    }

    @TestTemplate
    public void testAlterTable() throws TableNotExistException {
        this.sql("CREATE TABLE tl(id BIGINT) WITH ('oldK'='oldV')", new Object[0]);
        HashMap properties = Maps.newHashMap();
        properties.put("oldK", "oldV");
        this.sql("ALTER TABLE tl SET('newK'='newV')", new Object[0]);
        properties.put("newK", "newV");
        Assertions.assertThat((Map)this.table("tl").properties()).containsAllEntriesOf((Map)properties);
        this.sql("ALTER TABLE tl SET('oldK'='oldV2')", new Object[0]);
        properties.put("oldK", "oldV2");
        Assertions.assertThat((Map)this.table("tl").properties()).containsAllEntriesOf((Map)properties);
        CatalogTable catalogTable = this.catalogTable("tl");
        properties.remove("oldK");
        ((Catalog)this.getTableEnv().getCatalog(this.getTableEnv().getCurrentCatalog()).get()).alterTable(new ObjectPath("db", "tl"), (CatalogBaseTable)catalogTable.copy((Map)properties), false);
        Assertions.assertThat((Map)this.table("tl").properties()).containsAllEntriesOf((Map)properties);
    }

    @TestTemplate
    public void testAlterTableWithPrimaryKey() throws TableNotExistException {
        this.sql("CREATE TABLE tl(id BIGINT, PRIMARY KEY(id) NOT ENFORCED) WITH ('oldK'='oldV')", new Object[0]);
        HashMap properties = Maps.newHashMap();
        properties.put("oldK", "oldV");
        this.sql("ALTER TABLE tl SET('newK'='newV')", new Object[0]);
        properties.put("newK", "newV");
        Assertions.assertThat((Map)this.table("tl").properties()).containsAllEntriesOf((Map)properties);
        this.sql("ALTER TABLE tl SET('oldK'='oldV2')", new Object[0]);
        properties.put("oldK", "oldV2");
        Assertions.assertThat((Map)this.table("tl").properties()).containsAllEntriesOf((Map)properties);
        CatalogTable catalogTable = this.catalogTable("tl");
        properties.remove("oldK");
        ((Catalog)this.getTableEnv().getCatalog(this.getTableEnv().getCurrentCatalog()).get()).alterTable(new ObjectPath("db", "tl"), (CatalogBaseTable)catalogTable.copy((Map)properties), false);
        Assertions.assertThat((Map)this.table("tl").properties()).containsAllEntriesOf((Map)properties);
    }

    @TestTemplate
    public void testRelocateTable() {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isHadoopCatalog).as("HadoopCatalog does not support relocate table", new Object[0])).isFalse();
        this.sql("CREATE TABLE tl(id BIGINT)", new Object[0]);
        this.sql("ALTER TABLE tl SET('location'='file:///tmp/location')", new Object[0]);
        Assertions.assertThat((String)this.table("tl").location()).isEqualTo("file:///tmp/location");
    }

    @TestTemplate
    public void testSetCurrentAndCherryPickSnapshotId() {
        this.sql("CREATE TABLE tl(c1 INT, c2 STRING, c3 STRING) PARTITIONED BY (c1)", new Object[0]);
        Table table = this.table("tl");
        DataFile fileA = DataFiles.builder((PartitionSpec)table.spec()).withPath("/path/to/data-a.parquet").withFileSizeInBytes(10L).withPartitionPath("c1=0").withRecordCount(1L).build();
        DataFile fileB = DataFiles.builder((PartitionSpec)table.spec()).withPath("/path/to/data-b.parquet").withFileSizeInBytes(10L).withPartitionPath("c1=1").withRecordCount(1L).build();
        DataFile replacementFile = DataFiles.builder((PartitionSpec)table.spec()).withPath("/path/to/data-a-replacement.parquet").withFileSizeInBytes(10L).withPartitionPath("c1=0").withRecordCount(1L).build();
        table.newAppend().appendFile(fileA).commit();
        long snapshotId = table.currentSnapshot().snapshotId();
        ((ReplacePartitions)table.newReplacePartitions().addFile(replacementFile).stageOnly()).commit();
        Snapshot staged = (Snapshot)Iterables.getLast((Iterable)table.snapshots());
        ((AbstractStringAssert)Assertions.assertThat((String)staged.operation()).as("Should find the staged overwrite snapshot", new Object[0])).isEqualTo("overwrite");
        table.newAppend().appendFile(fileB).commit();
        this.sql("ALTER TABLE tl SET('cherry-pick-snapshot-id'='%s')", staged.snapshotId());
        this.validateTableFiles(table, fileB, replacementFile);
        this.sql("ALTER TABLE tl SET('current-snapshot-id'='%s')", snapshotId);
        this.validateTableFiles(table, fileA);
    }

    private void validateTableFiles(Table tbl, DataFile ... expectedFiles) {
        tbl.refresh();
        Set expectedFilePaths = Arrays.stream(expectedFiles).map(ContentFile::path).collect(Collectors.toSet());
        Set actualFilePaths = StreamSupport.stream(tbl.newScan().planFiles().spliterator(), false).map(ContentScanTask::file).map(ContentFile::path).collect(Collectors.toSet());
        ((AbstractCollectionAssert)Assertions.assertThat(actualFilePaths).as("Files should match", new Object[0])).isEqualTo(expectedFilePaths);
    }

    private Table table(String name) {
        return this.validationCatalog.loadTable(TableIdentifier.of((Namespace)this.icebergNamespace, (String)name));
    }

    private CatalogTable catalogTable(String name) throws TableNotExistException {
        return (CatalogTable)((Catalog)this.getTableEnv().getCatalog(this.getTableEnv().getCurrentCatalog()).get()).getTable(new ObjectPath("db", name));
    }
}

