/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.iceberg.Schema;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestFlinkSchemaUtil {
    @Test
    public void testConvertFlinkSchemaToIcebergSchema() {
        TableSchema flinkSchema = TableSchema.builder().field("id", (DataType)DataTypes.INT().notNull()).field("name", DataTypes.STRING()).field("salary", (DataType)DataTypes.DOUBLE().notNull()).field("locations", DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"posX", (DataType)((DataType)DataTypes.DOUBLE().notNull()), (String)"X field"), DataTypes.FIELD((String)"posY", (DataType)((DataType)DataTypes.DOUBLE().notNull()), (String)"Y field")}))).field("strArray", (DataType)DataTypes.ARRAY((DataType)DataTypes.STRING()).nullable()).field("intArray", (DataType)DataTypes.ARRAY((DataType)DataTypes.INT()).nullable()).field("char", (DataType)DataTypes.CHAR((int)10).notNull()).field("varchar", (DataType)DataTypes.VARCHAR((int)10).notNull()).field("boolean", (DataType)DataTypes.BOOLEAN().nullable()).field("tinyint", DataTypes.TINYINT()).field("smallint", DataTypes.SMALLINT()).field("bigint", DataTypes.BIGINT()).field("varbinary", DataTypes.VARBINARY((int)10)).field("binary", DataTypes.BINARY((int)10)).field("time", DataTypes.TIME()).field("timestampWithoutZone", DataTypes.TIMESTAMP()).field("timestampWithZone", DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE()).field("date", DataTypes.DATE()).field("decimal", DataTypes.DECIMAL((int)2, (int)2)).field("decimal2", DataTypes.DECIMAL((int)38, (int)2)).field("decimal3", DataTypes.DECIMAL((int)10, (int)1)).field("multiset", DataTypes.MULTISET((DataType)((DataType)DataTypes.STRING().notNull()))).build();
        Schema icebergSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.IntegerType.get(), null), Types.NestedField.optional((int)1, (String)"name", (Type)Types.StringType.get(), null), Types.NestedField.required((int)2, (String)"salary", (Type)Types.DoubleType.get(), null), Types.NestedField.optional((int)3, (String)"locations", (Type)Types.MapType.ofOptional((int)24, (int)25, (Type)Types.StringType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)22, (String)"posX", (Type)Types.DoubleType.get(), (String)"X field"), Types.NestedField.required((int)23, (String)"posY", (Type)Types.DoubleType.get(), (String)"Y field")}))), Types.NestedField.optional((int)4, (String)"strArray", (Type)Types.ListType.ofOptional((int)26, (Type)Types.StringType.get())), Types.NestedField.optional((int)5, (String)"intArray", (Type)Types.ListType.ofOptional((int)27, (Type)Types.IntegerType.get())), Types.NestedField.required((int)6, (String)"char", (Type)Types.StringType.get()), Types.NestedField.required((int)7, (String)"varchar", (Type)Types.StringType.get()), Types.NestedField.optional((int)8, (String)"boolean", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)9, (String)"tinyint", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)10, (String)"smallint", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)11, (String)"bigint", (Type)Types.LongType.get()), Types.NestedField.optional((int)12, (String)"varbinary", (Type)Types.BinaryType.get()), Types.NestedField.optional((int)13, (String)"binary", (Type)Types.FixedType.ofLength((int)10)), Types.NestedField.optional((int)14, (String)"time", (Type)Types.TimeType.get()), Types.NestedField.optional((int)15, (String)"timestampWithoutZone", (Type)Types.TimestampType.withoutZone()), Types.NestedField.optional((int)16, (String)"timestampWithZone", (Type)Types.TimestampType.withZone()), Types.NestedField.optional((int)17, (String)"date", (Type)Types.DateType.get()), Types.NestedField.optional((int)18, (String)"decimal", (Type)Types.DecimalType.of((int)2, (int)2)), Types.NestedField.optional((int)19, (String)"decimal2", (Type)Types.DecimalType.of((int)38, (int)2)), Types.NestedField.optional((int)20, (String)"decimal3", (Type)Types.DecimalType.of((int)10, (int)1)), Types.NestedField.optional((int)21, (String)"multiset", (Type)Types.MapType.ofRequired((int)28, (int)29, (Type)Types.StringType.get(), (Type)Types.IntegerType.get()))});
        this.checkSchema(flinkSchema, icebergSchema);
    }

    @Test
    public void testMapField() {
        TableSchema flinkSchema = TableSchema.builder().field("map_int_long", (DataType)DataTypes.MAP((DataType)DataTypes.INT(), (DataType)DataTypes.BIGINT()).notNull()).field("map_int_array_string", DataTypes.MAP((DataType)DataTypes.ARRAY((DataType)DataTypes.INT()), (DataType)DataTypes.STRING())).field("map_decimal_string", DataTypes.MAP((DataType)DataTypes.DECIMAL((int)10, (int)2), (DataType)DataTypes.STRING())).field("map_fields_fields", (DataType)DataTypes.MAP((DataType)((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"field_int", (DataType)DataTypes.INT(), (String)"doc - int"), DataTypes.FIELD((String)"field_string", (DataType)DataTypes.STRING(), (String)"doc - string")}).notNull()), (DataType)((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"field_array", (DataType)DataTypes.ARRAY((DataType)DataTypes.STRING()), (String)"doc - array")}).notNull())).notNull()).build();
        Schema icebergSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"map_int_long", (Type)Types.MapType.ofOptional((int)4, (int)5, (Type)Types.IntegerType.get(), (Type)Types.LongType.get()), null), Types.NestedField.optional((int)1, (String)"map_int_array_string", (Type)Types.MapType.ofOptional((int)7, (int)8, (Type)Types.ListType.ofOptional((int)6, (Type)Types.IntegerType.get()), (Type)Types.StringType.get()), null), Types.NestedField.optional((int)2, (String)"map_decimal_string", (Type)Types.MapType.ofOptional((int)9, (int)10, (Type)Types.DecimalType.of((int)10, (int)2), (Type)Types.StringType.get())), Types.NestedField.required((int)3, (String)"map_fields_fields", (Type)Types.MapType.ofRequired((int)15, (int)16, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)11, (String)"field_int", (Type)Types.IntegerType.get(), (String)"doc - int"), Types.NestedField.optional((int)12, (String)"field_string", (Type)Types.StringType.get(), (String)"doc - string")}), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)14, (String)"field_array", (Type)Types.ListType.ofOptional((int)13, (Type)Types.StringType.get()), (String)"doc - array")})))});
        this.checkSchema(flinkSchema, icebergSchema);
    }

    @Test
    public void testStructField() {
        TableSchema flinkSchema = TableSchema.builder().field("struct_int_string_decimal", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"field_int", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"field_string", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"field_decimal", (DataType)DataTypes.DECIMAL((int)19, (int)2)), DataTypes.FIELD((String)"field_struct", (DataType)((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"inner_struct_int", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"inner_struct_float_array", (DataType)DataTypes.ARRAY((DataType)DataTypes.FLOAT()))}).notNull()))}).notNull()).field("struct_map_int_int", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"field_map", (DataType)DataTypes.MAP((DataType)DataTypes.INT(), (DataType)DataTypes.INT()))}).nullable()).build();
        Schema icebergSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"struct_int_string_decimal", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)5, (String)"field_int", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)6, (String)"field_string", (Type)Types.StringType.get()), Types.NestedField.optional((int)7, (String)"field_decimal", (Type)Types.DecimalType.of((int)19, (int)2)), Types.NestedField.required((int)8, (String)"field_struct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)3, (String)"inner_struct_int", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)4, (String)"inner_struct_float_array", (Type)Types.ListType.ofOptional((int)2, (Type)Types.FloatType.get()))}))})), Types.NestedField.optional((int)1, (String)"struct_map_int_int", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)11, (String)"field_map", (Type)Types.MapType.ofOptional((int)9, (int)10, (Type)Types.IntegerType.get(), (Type)Types.IntegerType.get()))}))});
        this.checkSchema(flinkSchema, icebergSchema);
    }

    @Test
    public void testListField() {
        TableSchema flinkSchema = TableSchema.builder().field("list_struct_fields", (DataType)DataTypes.ARRAY((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"field_int", (DataType)DataTypes.INT())})).notNull()).field("list_optional_struct_fields", (DataType)DataTypes.ARRAY((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"field_timestamp_with_local_time_zone", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE())})).nullable()).field("list_map_fields", (DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.MAP((DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.INT().notNull())), (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"field_0", (DataType)DataTypes.INT(), (String)"doc - int")})).notNull())).notNull()).build();
        Schema icebergSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"list_struct_fields", (Type)Types.ListType.ofOptional((int)4, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)3, (String)"field_int", (Type)Types.IntegerType.get())}))), Types.NestedField.optional((int)1, (String)"list_optional_struct_fields", (Type)Types.ListType.ofOptional((int)6, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)5, (String)"field_timestamp_with_local_time_zone", (Type)Types.TimestampType.withZone())}))), Types.NestedField.required((int)2, (String)"list_map_fields", (Type)Types.ListType.ofRequired((int)11, (Type)Types.MapType.ofOptional((int)9, (int)10, (Type)Types.ListType.ofRequired((int)7, (Type)Types.IntegerType.get()), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)8, (String)"field_0", (Type)Types.IntegerType.get(), (String)"doc - int")}))))});
        this.checkSchema(flinkSchema, icebergSchema);
    }

    private void checkSchema(TableSchema flinkSchema, Schema icebergSchema) {
        Assert.assertEquals((Object)icebergSchema.asStruct(), (Object)FlinkSchemaUtil.convert((TableSchema)flinkSchema).asStruct());
        Assert.assertEquals((Object)icebergSchema.asStruct(), (Object)FlinkSchemaUtil.convert((TableSchema)FlinkSchemaUtil.toSchema((RowType)FlinkSchemaUtil.convert((Schema)icebergSchema))).asStruct());
    }

    @Test
    public void testInconsistentTypes() {
        this.checkInconsistentType((Type)Types.UUIDType.get(), (LogicalType)new BinaryType(16), (LogicalType)new BinaryType(16), (Type)Types.FixedType.ofLength((int)16));
        this.checkInconsistentType((Type)Types.StringType.get(), (LogicalType)new VarCharType(Integer.MAX_VALUE), (LogicalType)new CharType(100), (Type)Types.StringType.get());
        this.checkInconsistentType((Type)Types.BinaryType.get(), (LogicalType)new VarBinaryType(Integer.MAX_VALUE), (LogicalType)new VarBinaryType(100), (Type)Types.BinaryType.get());
        this.checkInconsistentType((Type)Types.TimeType.get(), (LogicalType)new TimeType(), (LogicalType)new TimeType(3), (Type)Types.TimeType.get());
        this.checkInconsistentType((Type)Types.TimestampType.withoutZone(), (LogicalType)new TimestampType(6), (LogicalType)new TimestampType(3), (Type)Types.TimestampType.withoutZone());
        this.checkInconsistentType((Type)Types.TimestampType.withZone(), (LogicalType)new LocalZonedTimestampType(6), (LogicalType)new LocalZonedTimestampType(3), (Type)Types.TimestampType.withZone());
    }

    private void checkInconsistentType(Type icebergType, LogicalType flinkExpectedType, LogicalType flinkType, Type icebergExpectedType) {
        Assert.assertEquals((Object)flinkExpectedType, (Object)FlinkSchemaUtil.convert((Type)icebergType));
        Assert.assertEquals((Object)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)0, (String)"f0", (Type)icebergExpectedType)}), (Object)FlinkSchemaUtil.convert((TableSchema)FlinkSchemaUtil.toSchema((RowType)RowType.of((LogicalType[])new LogicalType[]{flinkType}))).asStruct());
    }

    @Test
    public void testConvertFlinkSchemaBaseOnIcebergSchema() {
        Schema baseSchema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)101, (String)"int", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)102, (String)"string", (Type)Types.StringType.get())}), (Set)Sets.newHashSet((Object[])new Integer[]{101}));
        TableSchema flinkSchema = TableSchema.builder().field("int", (DataType)DataTypes.INT().notNull()).field("string", (DataType)DataTypes.STRING().nullable()).primaryKey(new String[]{"int"}).build();
        Schema convertedSchema = FlinkSchemaUtil.convert((Schema)baseSchema, (TableSchema)flinkSchema);
        Assert.assertEquals((Object)baseSchema.asStruct(), (Object)convertedSchema.asStruct());
        Assert.assertEquals((Object)ImmutableSet.of((Object)101), (Object)convertedSchema.identifierFieldIds());
    }

    @Test
    public void testConvertFlinkSchemaWithPrimaryKeys() {
        Schema icebergSchema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"int", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"string", (Type)Types.StringType.get())}), (Set)Sets.newHashSet((Object[])new Integer[]{1, 2}));
        TableSchema tableSchema = FlinkSchemaUtil.toSchema((Schema)icebergSchema);
        Assert.assertTrue((boolean)tableSchema.getPrimaryKey().isPresent());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"int", (Object)"string"), (Object)ImmutableSet.copyOf((Collection)((UniqueConstraint)tableSchema.getPrimaryKey().get()).getColumns()));
    }

    @Test
    public void testConvertFlinkSchemaWithNestedColumnInPrimaryKeys() {
        Schema icebergSchema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"struct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)2, (String)"inner", (Type)Types.IntegerType.get())}))}), (Set)Sets.newHashSet((Object[])new Integer[]{2}));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> FlinkSchemaUtil.toSchema((Schema)icebergSchema)).isInstanceOf(ValidationException.class)).hasMessageStartingWith("Could not create a PRIMARY KEY").hasMessageContaining("Column 'struct.inner' does not exist");
    }
}

