/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.data;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.iceberg.Files;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.AvroIterable;
import org.apache.iceberg.data.DataTest;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.RandomGenericData;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.avro.DataReader;
import org.apache.iceberg.data.avro.DataWriter;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.TestHelpers;
import org.apache.iceberg.flink.data.FlinkAvroReader;
import org.apache.iceberg.flink.data.FlinkAvroWriter;
import org.apache.iceberg.flink.data.RandomRowData;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.DateTimeUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestFlinkAvroReaderWriter
extends DataTest {
    private static final int NUM_RECORDS = 100;
    private static final Schema SCHEMA_NUM_TYPE = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"int", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)3, (String)"float", (Type)Types.FloatType.get()), Types.NestedField.optional((int)4, (String)"double", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)5, (String)"date", (Type)Types.DateType.get()), Types.NestedField.optional((int)6, (String)"time", (Type)Types.TimeType.get()), Types.NestedField.optional((int)7, (String)"timestamp", (Type)Types.TimestampType.withoutZone()), Types.NestedField.optional((int)8, (String)"bigint", (Type)Types.LongType.get()), Types.NestedField.optional((int)9, (String)"decimal", (Type)Types.DecimalType.of((int)4, (int)2))});

    protected void writeAndValidate(Schema schema) throws IOException {
        List expectedRecords = RandomGenericData.generate((Schema)schema, (int)100, (long)1991L);
        this.writeAndValidate(schema, expectedRecords, 100);
    }

    private void writeAndValidate(Schema schema, List<Record> expectedRecords, int numRecord) throws IOException {
        RowType flinkSchema = FlinkSchemaUtil.convert((Schema)schema);
        ArrayList expectedRows = Lists.newArrayList(RandomRowData.convert(schema, expectedRecords));
        File recordsFile = this.temp.newFile();
        Assert.assertTrue((String)"Delete should succeed", (boolean)recordsFile.delete());
        try (FileAppender writer = Avro.write((OutputFile)Files.localOutput((File)recordsFile)).schema(schema).createWriterFunc(DataWriter::create).build();){
            writer.addAll(expectedRecords);
        }
        var8_8 = null;
        try (AvroIterable reader = Avro.read((InputFile)Files.localInput((File)recordsFile)).project(schema).createReaderFunc(FlinkAvroReader::new).build();){
            Iterator<Record> expected = expectedRecords.iterator();
            CloseableIterator rows = reader.iterator();
            for (int i = 0; i < numRecord; ++i) {
                Assert.assertTrue((String)"Should have expected number of records", (boolean)rows.hasNext());
                TestHelpers.assertRowData(schema.asStruct(), (LogicalType)flinkSchema, (StructLike)expected.next(), (RowData)rows.next());
            }
            Assert.assertFalse((String)"Should not have extra records", (boolean)rows.hasNext());
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        File rowDataFile = this.temp.newFile();
        Assert.assertTrue((String)"Delete should succeed", (boolean)rowDataFile.delete());
        try (FileAppender writer = Avro.write((OutputFile)Files.localOutput((File)rowDataFile)).schema(schema).createWriterFunc(ignore -> new FlinkAvroWriter(flinkSchema)).build();){
            writer.addAll((Iterable)expectedRows);
        }
        var9_10 = null;
        try (AvroIterable reader = Avro.read((InputFile)Files.localInput((File)rowDataFile)).project(schema).createReaderFunc(DataReader::create).build();){
            Iterator expected = expectedRows.iterator();
            CloseableIterator records = reader.iterator();
            for (int i = 0; i < numRecord; ++i) {
                Assert.assertTrue((String)"Should have expected number of records", (boolean)records.hasNext());
                TestHelpers.assertRowData(schema.asStruct(), (LogicalType)flinkSchema, (StructLike)records.next(), (RowData)expected.next());
            }
            Assert.assertFalse((String)"Should not have extra records", (boolean)records.hasNext());
        }
        catch (Throwable throwable) {
            var9_10 = throwable;
            throw throwable;
        }
    }

    private Record recordNumType(int id, int intV, float floatV, double doubleV, long date, long time, long timestamp, long bigint, double decimal) {
        GenericRecord record = GenericRecord.create((Schema)SCHEMA_NUM_TYPE);
        record.setField("id", (Object)id);
        record.setField("int", (Object)intV);
        record.setField("float", (Object)Float.valueOf(floatV));
        record.setField("double", (Object)doubleV);
        record.setField("date", (Object)DateTimeUtil.dateFromDays((int)((int)new Date(date).toLocalDate().toEpochDay())));
        record.setField("time", (Object)new Time(time).toLocalTime());
        record.setField("timestamp", (Object)DateTimeUtil.timestampFromMicros((long)(timestamp * 1000L)));
        record.setField("bigint", (Object)bigint);
        record.setField("decimal", (Object)BigDecimal.valueOf(decimal));
        return record;
    }

    @Test
    public void testNumericTypes() throws IOException {
        ImmutableList expected = ImmutableList.of((Object)this.recordNumType(2, Integer.MAX_VALUE, Float.MAX_VALUE, Double.MAX_VALUE, Long.MAX_VALUE, 1643811742000L, 1643811742000L, 1643811742000L, 10.24), (Object)this.recordNumType(2, Integer.MIN_VALUE, Float.MIN_VALUE, Double.MIN_VALUE, Long.MIN_VALUE, 1643811742000L, 1643811742000L, 1643811742000L, 10.24));
        this.writeAndValidate(SCHEMA_NUM_TYPE, (List<Record>)expected, 2);
    }
}

