/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.data;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.iceberg.Files;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.data.DataTest;
import org.apache.iceberg.data.RandomGenericData;
import org.apache.iceberg.data.parquet.GenericParquetReaders;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.TestHelpers;
import org.apache.iceberg.flink.data.FlinkParquetWriters;
import org.apache.iceberg.flink.data.RandomRowData;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.parquet.ParquetValueWriter;
import org.apache.parquet.schema.MessageType;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;

public class TestFlinkParquetWriter
extends DataTest {
    private static final int NUM_RECORDS = 100;
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    private void writeAndValidate(Iterable<RowData> iterable, Schema schema) throws IOException {
        File testFile = this.temp.newFile();
        Assert.assertTrue((String)"Delete should succeed", (boolean)testFile.delete());
        RowType logicalType = FlinkSchemaUtil.convert((Schema)schema);
        try (FileAppender writer = Parquet.write((OutputFile)Files.localOutput((File)testFile)).schema(schema).createWriterFunc(arg_0 -> TestFlinkParquetWriter.lambda$writeAndValidate$0((LogicalType)logicalType, arg_0)).build();){
            writer.addAll(iterable);
        }
        var6_6 = null;
        try (CloseableIterable reader = Parquet.read((InputFile)Files.localInput((File)testFile)).project(schema).createReaderFunc(msgType -> GenericParquetReaders.buildReader((Schema)schema, (MessageType)msgType)).build();){
            Iterator<RowData> expected = iterable.iterator();
            CloseableIterator actual = reader.iterator();
            RowType rowType = FlinkSchemaUtil.convert((Schema)schema);
            for (int i = 0; i < 100; ++i) {
                Assert.assertTrue((String)"Should have expected number of rows", (boolean)actual.hasNext());
                TestHelpers.assertRowData(schema.asStruct(), (LogicalType)rowType, (StructLike)actual.next(), expected.next());
            }
            Assert.assertFalse((String)"Should not have extra rows", (boolean)actual.hasNext());
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
    }

    protected void writeAndValidate(Schema schema) throws IOException {
        this.writeAndValidate(RandomRowData.generate(schema, 100, 19981L), schema);
        this.writeAndValidate(RandomRowData.convert(schema, RandomGenericData.generateDictionaryEncodableRecords((Schema)schema, (int)100, (long)21124L)), schema);
        this.writeAndValidate(RandomRowData.convert(schema, RandomGenericData.generateFallbackRecords((Schema)schema, (int)100, (long)21124L, (long)5L)), schema);
    }

    private static /* synthetic */ ParquetValueWriter lambda$writeAndValidate$0(LogicalType logicalType, MessageType msgType) {
        return FlinkParquetWriters.buildWriter((LogicalType)logicalType, (MessageType)msgType);
    }
}

