/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.data;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.iceberg.Files;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.AvroIterable;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.data.FlinkAvroReader;
import org.apache.iceberg.flink.data.FlinkAvroWriter;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestRowProjection {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    private RowData writeAndRead(String desc, Schema writeSchema, Schema readSchema, RowData row) throws IOException {
        File file = this.temp.newFile(desc + ".avro");
        Assert.assertTrue((boolean)file.delete());
        try (FileAppender appender = Avro.write((OutputFile)Files.localOutput((File)file)).schema(writeSchema).createWriterFunc(ignore -> new FlinkAvroWriter(FlinkSchemaUtil.convert((Schema)writeSchema))).build();){
            appender.add((Object)row);
        }
        AvroIterable records = Avro.read((InputFile)Files.localInput((File)file)).project(readSchema).createReaderFunc(FlinkAvroReader::new).build();
        return (RowData)Iterables.getOnlyElement((Iterable)records);
    }

    @Test
    public void testFullProjection() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        GenericRowData row = GenericRowData.of((Object[])new Object[]{34L, StringData.fromString((String)"test")});
        RowData projected = this.writeAndRead("full_projection", schema, schema, (RowData)row);
        Assert.assertEquals((String)"Should contain the correct id value", (long)34L, (long)projected.getLong(0));
        int cmp = Comparators.charSequences().compare("test", projected.getString(1).toString());
        Assert.assertEquals((String)"Should contain the correct data value", (long)cmp, (long)0L);
    }

    @Test
    public void testSpecialCharacterProjection() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"user id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data%0", (Type)Types.StringType.get())});
        GenericRowData row = GenericRowData.of((Object[])new Object[]{34L, StringData.fromString((String)"test")});
        RowData full = this.writeAndRead("special_chars", schema, schema, (RowData)row);
        Assert.assertEquals((String)"Should contain the correct id value", (long)34L, (long)full.getLong(0));
        Assert.assertEquals((String)"Should contain the correct data value", (long)0L, (long)Comparators.charSequences().compare("test", full.getString(1).toString()));
        RowData projected = this.writeAndRead("special_characters", schema, schema.select(new String[]{"data%0"}), full);
        Assert.assertEquals((String)"Should not contain id value", (long)1L, (long)projected.getArity());
        Assert.assertEquals((String)"Should contain the correct data value", (long)0L, (long)Comparators.charSequences().compare("test", projected.getString(0).toString()));
    }

    @Test
    public void testReorderedFullProjection() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        GenericRowData row = GenericRowData.of((Object[])new Object[]{34L, StringData.fromString((String)"test")});
        Schema reordered = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())});
        RowData projected = this.writeAndRead("full_projection", schema, reordered, (RowData)row);
        Assert.assertEquals((String)"Should contain the correct 0 value", (Object)"test", (Object)projected.getString(0).toString());
        Assert.assertEquals((String)"Should contain the correct 1 value", (long)34L, (long)projected.getLong(1));
    }

    @Test
    public void testReorderedProjection() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        GenericRowData row = GenericRowData.of((Object[])new Object[]{34L, StringData.fromString((String)"test")});
        Schema reordered = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)2, (String)"missing_1", (Type)Types.StringType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"missing_2", (Type)Types.LongType.get())});
        RowData projected = this.writeAndRead("full_projection", schema, reordered, (RowData)row);
        Assert.assertTrue((String)"Should contain the correct 0 value", (boolean)projected.isNullAt(0));
        Assert.assertEquals((String)"Should contain the correct 1 value", (Object)"test", (Object)projected.getString(1).toString());
        Assert.assertTrue((String)"Should contain the correct 2 value", (boolean)projected.isNullAt(2));
    }

    @Test
    public void testRenamedAddedField() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"a", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"b", (Type)Types.LongType.get()), Types.NestedField.required((int)3, (String)"d", (Type)Types.LongType.get())});
        GenericRowData row = GenericRowData.of((Object[])new Object[]{100L, 200L, 300L});
        Schema renamedAdded = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"a", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"b", (Type)Types.LongType.get()), Types.NestedField.optional((int)3, (String)"c", (Type)Types.LongType.get()), Types.NestedField.optional((int)4, (String)"d", (Type)Types.LongType.get())});
        RowData projected = this.writeAndRead("rename_and_add_column_projection", schema, renamedAdded, (RowData)row);
        Assert.assertEquals((String)"Should contain the correct value in column 1", (long)projected.getLong(0), (long)100L);
        Assert.assertEquals((String)"Should contain the correct value in column 2", (long)projected.getLong(1), (long)200L);
        Assert.assertEquals((String)"Should contain the correct value in column 3", (long)projected.getLong(2), (long)300L);
        Assert.assertTrue((String)"Should contain empty value on new column 4", (boolean)projected.isNullAt(3));
    }

    @Test
    public void testEmptyProjection() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        GenericRowData row = GenericRowData.of((Object[])new Object[]{34L, StringData.fromString((String)"test")});
        RowData projected = this.writeAndRead("empty_projection", schema, schema.select(new String[0]), (RowData)row);
        Assert.assertNotNull((String)"Should read a non-null record", (Object)projected);
        Assert.assertEquals((long)0L, (long)projected.getArity());
    }

    @Test
    public void testBasicProjection() throws Exception {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        GenericRowData row = GenericRowData.of((Object[])new Object[]{34L, StringData.fromString((String)"test")});
        Schema idOnly = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())});
        RowData projected = this.writeAndRead("basic_projection_id", writeSchema, idOnly, (RowData)row);
        Assert.assertEquals((String)"Should not project data", (long)1L, (long)projected.getArity());
        Assert.assertEquals((String)"Should contain the correct id value", (long)34L, (long)projected.getLong(0));
        Schema dataOnly = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        projected = this.writeAndRead("basic_projection_data", writeSchema, dataOnly, (RowData)row);
        Assert.assertEquals((String)"Should not project id", (long)1L, (long)projected.getArity());
        int cmp = Comparators.charSequences().compare("test", projected.getString(0).toString());
        Assert.assertEquals((String)"Should contain the correct data value", (long)0L, (long)cmp);
    }

    @Test
    public void testRename() throws Exception {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        GenericRowData row = GenericRowData.of((Object[])new Object[]{34L, StringData.fromString((String)"test")});
        Schema readSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"renamed", (Type)Types.StringType.get())});
        RowData projected = this.writeAndRead("project_and_rename", writeSchema, readSchema, (RowData)row);
        Assert.assertEquals((String)"Should contain the correct id value", (long)34L, (long)projected.getLong(0));
        int cmp = Comparators.charSequences().compare("test", projected.getString(1).toString());
        Assert.assertEquals((String)"Should contain the correct data/renamed value", (long)0L, (long)cmp);
    }

    @Test
    public void testNestedStructProjection() throws Exception {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)3, (String)"location", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"lat", (Type)Types.FloatType.get()), Types.NestedField.required((int)2, (String)"long", (Type)Types.FloatType.get())}))});
        GenericRowData location = GenericRowData.of((Object[])new Object[]{Float.valueOf(52.995144f), Float.valueOf(-1.539054f)});
        GenericRowData record = GenericRowData.of((Object[])new Object[]{34L, location});
        Schema idOnly = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())});
        RowData projected = this.writeAndRead("id_only", writeSchema, idOnly, (RowData)record);
        Assert.assertEquals((String)"Should not project location", (long)1L, (long)projected.getArity());
        Assert.assertEquals((String)"Should contain the correct id value", (long)34L, (long)projected.getLong(0));
        Schema latOnly = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)3, (String)"location", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"lat", (Type)Types.FloatType.get())}))});
        projected = this.writeAndRead("latitude_only", writeSchema, latOnly, (RowData)record);
        RowData projectedLocation = projected.getRow(0, 1);
        Assert.assertEquals((String)"Should not project id", (long)1L, (long)projected.getArity());
        Assert.assertFalse((String)"Should project location", (boolean)projected.isNullAt(0));
        Assert.assertEquals((String)"Should not project longitude", (long)1L, (long)projectedLocation.getArity());
        Assert.assertEquals((String)"Should project latitude", (float)52.995144f, (float)projectedLocation.getFloat(0), (float)1.0E-6f);
        Schema longOnly = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)3, (String)"location", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)2, (String)"long", (Type)Types.FloatType.get())}))});
        projected = this.writeAndRead("longitude_only", writeSchema, longOnly, (RowData)record);
        projectedLocation = projected.getRow(0, 1);
        Assert.assertEquals((String)"Should not project id", (long)1L, (long)projected.getArity());
        Assert.assertFalse((String)"Should project location", (boolean)projected.isNullAt(0));
        Assert.assertEquals((String)"Should not project latitutde", (long)1L, (long)projectedLocation.getArity());
        Assert.assertEquals((String)"Should project longitude", (float)-1.539054f, (float)projectedLocation.getFloat(0), (float)1.0E-6f);
        Schema locationOnly = writeSchema.select(new String[]{"location"});
        projected = this.writeAndRead("location_only", writeSchema, locationOnly, (RowData)record);
        projectedLocation = projected.getRow(0, 1);
        Assert.assertEquals((String)"Should not project id", (long)1L, (long)projected.getArity());
        Assert.assertFalse((String)"Should project location", (boolean)projected.isNullAt(0));
        Assert.assertEquals((String)"Should project latitude", (float)52.995144f, (float)projectedLocation.getFloat(0), (float)1.0E-6f);
        Assert.assertEquals((String)"Should project longitude", (float)-1.539054f, (float)projectedLocation.getFloat(1), (float)1.0E-6f);
    }

    @Test
    public void testMapProjection() throws IOException {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)5, (String)"properties", (Type)Types.MapType.ofOptional((int)6, (int)7, (Type)Types.StringType.get(), (Type)Types.StringType.get()))});
        GenericMapData properties = new GenericMapData((Map)ImmutableMap.of((Object)StringData.fromString((String)"a"), (Object)StringData.fromString((String)"A"), (Object)StringData.fromString((String)"b"), (Object)StringData.fromString((String)"B")));
        GenericRowData row = GenericRowData.of((Object[])new Object[]{34L, properties});
        Schema idOnly = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())});
        RowData projected = this.writeAndRead("id_only", writeSchema, idOnly, (RowData)row);
        Assert.assertEquals((String)"Should contain the correct id value", (long)34L, (long)projected.getLong(0));
        Assert.assertEquals((String)"Should not project properties map", (long)1L, (long)projected.getArity());
        Schema keyOnly = writeSchema.select(new String[]{"properties.key"});
        projected = this.writeAndRead("key_only", writeSchema, keyOnly, (RowData)row);
        Assert.assertEquals((String)"Should not project id", (long)1L, (long)projected.getArity());
        Assert.assertEquals((String)"Should project entire map", (Object)properties, (Object)projected.getMap(0));
        Schema valueOnly = writeSchema.select(new String[]{"properties.value"});
        projected = this.writeAndRead("value_only", writeSchema, valueOnly, (RowData)row);
        Assert.assertEquals((String)"Should not project id", (long)1L, (long)projected.getArity());
        Assert.assertEquals((String)"Should project entire map", (Object)properties, (Object)projected.getMap(0));
        Schema mapOnly = writeSchema.select(new String[]{"properties"});
        projected = this.writeAndRead("map_only", writeSchema, mapOnly, (RowData)row);
        Assert.assertEquals((String)"Should not project id", (long)1L, (long)projected.getArity());
        Assert.assertEquals((String)"Should project entire map", (Object)properties, (Object)projected.getMap(0));
    }

    private Map<String, ?> toStringMap(Map<?, ?> map) {
        HashMap stringMap = Maps.newHashMap();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (entry.getValue() instanceof CharSequence) {
                stringMap.put(entry.getKey().toString(), entry.getValue().toString());
                continue;
            }
            stringMap.put(entry.getKey().toString(), entry.getValue());
        }
        return stringMap;
    }

    @Test
    public void testMapOfStructsProjection() throws IOException {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)5, (String)"locations", (Type)Types.MapType.ofOptional((int)6, (int)7, (Type)Types.StringType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"lat", (Type)Types.FloatType.get()), Types.NestedField.required((int)2, (String)"long", (Type)Types.FloatType.get())})))});
        GenericRowData l1 = GenericRowData.of((Object[])new Object[]{Float.valueOf(53.99281f), Float.valueOf(-1.542616f)});
        GenericRowData l2 = GenericRowData.of((Object[])new Object[]{Float.valueOf(52.995144f), Float.valueOf(-1.539054f)});
        GenericMapData map = new GenericMapData((Map)ImmutableMap.of((Object)StringData.fromString((String)"L1"), (Object)l1, (Object)StringData.fromString((String)"L2"), (Object)l2));
        GenericRowData row = GenericRowData.of((Object[])new Object[]{34L, map});
        Schema idOnly = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())});
        RowData projected = this.writeAndRead("id_only", writeSchema, idOnly, (RowData)row);
        Assert.assertEquals((String)"Should contain the correct id value", (long)34L, (long)projected.getLong(0));
        Assert.assertEquals((String)"Should not project locations map", (long)1L, (long)projected.getArity());
        projected = this.writeAndRead("all_locations", writeSchema, writeSchema.select(new String[]{"locations"}), (RowData)row);
        Assert.assertEquals((String)"Should not project id", (long)1L, (long)projected.getArity());
        Assert.assertEquals((String)"Should project locations map", (Object)row.getMap(1), (Object)projected.getMap(0));
        projected = this.writeAndRead("lat_only", writeSchema, writeSchema.select(new String[]{"locations.lat"}), (RowData)row);
        GenericMapData locations = (GenericMapData)projected.getMap(0);
        Assert.assertNotNull((String)"Should project locations map", (Object)locations);
        GenericArrayData l1l2Array = new GenericArrayData(new Object[]{StringData.fromString((String)"L2"), StringData.fromString((String)"L1")});
        Assert.assertEquals((String)"Should contain L1 and L2", (Object)l1l2Array, (Object)locations.keyArray());
        RowData projectedL1 = (RowData)locations.get((Object)StringData.fromString((String)"L1"));
        Assert.assertNotNull((String)"L1 should not be null", (Object)projectedL1);
        Assert.assertEquals((String)"L1 should contain lat", (double)53.9928092956543, (double)projectedL1.getFloat(0), (double)1.0E-6);
        Assert.assertEquals((String)"L1 should not contain long", (long)1L, (long)projectedL1.getArity());
        RowData projectedL2 = (RowData)locations.get((Object)StringData.fromString((String)"L2"));
        Assert.assertNotNull((String)"L2 should not be null", (Object)projectedL2);
        Assert.assertEquals((String)"L2 should contain lat", (double)52.99514389038086, (double)projectedL2.getFloat(0), (double)1.0E-6);
        Assert.assertEquals((String)"L2 should not contain long", (long)1L, (long)projectedL2.getArity());
        projected = this.writeAndRead("long_only", writeSchema, writeSchema.select(new String[]{"locations.long"}), (RowData)row);
        Assert.assertEquals((String)"Should not project id", (long)1L, (long)projected.getArity());
        locations = (GenericMapData)projected.getMap(0);
        Assert.assertNotNull((String)"Should project locations map", (Object)locations);
        Assert.assertEquals((String)"Should contain L1 and L2", (Object)l1l2Array, (Object)locations.keyArray());
        projectedL1 = (RowData)locations.get((Object)StringData.fromString((String)"L1"));
        Assert.assertNotNull((String)"L1 should not be null", (Object)projectedL1);
        Assert.assertEquals((String)"L1 should not contain lat", (long)1L, (long)projectedL1.getArity());
        Assert.assertEquals((String)"L1 should contain long", (double)-1.542616f, (double)projectedL1.getFloat(0), (double)1.0E-6);
        projectedL2 = (RowData)locations.get((Object)StringData.fromString((String)"L2"));
        Assert.assertNotNull((String)"L2 should not be null", (Object)projectedL2);
        Assert.assertEquals((String)"L2 should not contain lat", (long)1L, (long)projectedL2.getArity());
        Assert.assertEquals((String)"L2 should contain long", (double)-1.539054036140442, (double)projectedL2.getFloat(0), (double)1.0E-6);
        Schema latitiudeRenamed = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)5, (String)"locations", (Type)Types.MapType.ofOptional((int)6, (int)7, (Type)Types.StringType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"latitude", (Type)Types.FloatType.get())})))});
        projected = this.writeAndRead("latitude_renamed", writeSchema, latitiudeRenamed, (RowData)row);
        Assert.assertEquals((String)"Should not project id", (long)1L, (long)projected.getArity());
        locations = (GenericMapData)projected.getMap(0);
        Assert.assertNotNull((String)"Should project locations map", (Object)locations);
        Assert.assertEquals((String)"Should contain L1 and L2", (Object)l1l2Array, (Object)locations.keyArray());
        projectedL1 = (RowData)locations.get((Object)StringData.fromString((String)"L1"));
        Assert.assertNotNull((String)"L1 should not be null", (Object)projectedL1);
        Assert.assertEquals((String)"L1 should contain latitude", (double)53.9928092956543, (double)projectedL1.getFloat(0), (double)1.0E-6);
        projectedL2 = (RowData)locations.get((Object)StringData.fromString((String)"L2"));
        Assert.assertNotNull((String)"L2 should not be null", (Object)projectedL2);
        Assert.assertEquals((String)"L2 should contain latitude", (double)52.99514389038086, (double)projectedL2.getFloat(0), (double)1.0E-6);
    }

    @Test
    public void testListProjection() throws IOException {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)10, (String)"values", (Type)Types.ListType.ofOptional((int)11, (Type)Types.LongType.get()))});
        GenericArrayData values = new GenericArrayData((Object[])new Long[]{56L, 57L, 58L});
        GenericRowData row = GenericRowData.of((Object[])new Object[]{34L, values});
        Schema idOnly = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())});
        RowData projected = this.writeAndRead("id_only", writeSchema, idOnly, (RowData)row);
        Assert.assertEquals((String)"Should contain the correct id value", (long)34L, (long)projected.getLong(0));
        Assert.assertEquals((String)"Should not project values list", (long)1L, (long)projected.getArity());
        Schema elementOnly = writeSchema.select(new String[]{"values.element"});
        projected = this.writeAndRead("element_only", writeSchema, elementOnly, (RowData)row);
        Assert.assertEquals((String)"Should not project id", (long)1L, (long)projected.getArity());
        Assert.assertEquals((String)"Should project entire list", (Object)values, (Object)projected.getArray(0));
        Schema listOnly = writeSchema.select(new String[]{"values"});
        projected = this.writeAndRead("list_only", writeSchema, listOnly, (RowData)row);
        Assert.assertEquals((String)"Should not project id", (long)1L, (long)projected.getArity());
        Assert.assertEquals((String)"Should project entire list", (Object)values, (Object)projected.getArray(0));
    }

    @Test
    public void testListOfStructsProjection() throws IOException {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)22, (String)"points", (Type)Types.ListType.ofOptional((int)21, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)19, (String)"x", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)18, (String)"y", (Type)Types.IntegerType.get())})))});
        GenericRowData p1 = GenericRowData.of((Object[])new Object[]{1, 2});
        GenericRowData p2 = GenericRowData.of((Object[])new Object[]{3, null});
        GenericArrayData arrayData = new GenericArrayData((Object[])new RowData[]{p1, p2});
        GenericRowData row = GenericRowData.of((Object[])new Object[]{34L, arrayData});
        Schema idOnly = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())});
        RowData projected = this.writeAndRead("id_only", writeSchema, idOnly, (RowData)row);
        Assert.assertEquals((String)"Should contain the correct id value", (long)34L, (long)projected.getLong(0));
        Assert.assertEquals((String)"Should not project points list", (long)1L, (long)projected.getArity());
        projected = this.writeAndRead("all_points", writeSchema, writeSchema.select(new String[]{"points"}), (RowData)row);
        Assert.assertEquals((String)"Should not project id", (long)1L, (long)projected.getArity());
        Assert.assertEquals((String)"Should project points list", (Object)row.getArray(1), (Object)projected.getArray(0));
        projected = this.writeAndRead("x_only", writeSchema, writeSchema.select(new String[]{"points.x"}), (RowData)row);
        Assert.assertEquals((String)"Should not project id", (long)1L, (long)projected.getArity());
        Assert.assertFalse((String)"Should project points list", (boolean)projected.isNullAt(0));
        ArrayData points = projected.getArray(0);
        Assert.assertEquals((String)"Should read 2 points", (long)2L, (long)points.size());
        RowData projectedP1 = points.getRow(0, 2);
        Assert.assertEquals((String)"Should project x", (long)1L, (long)projectedP1.getInt(0));
        Assert.assertEquals((String)"Should not project y", (long)1L, (long)projectedP1.getArity());
        RowData projectedP2 = points.getRow(1, 2);
        Assert.assertEquals((String)"Should not project y", (long)1L, (long)projectedP2.getArity());
        Assert.assertEquals((String)"Should project x", (long)3L, (long)projectedP2.getInt(0));
        projected = this.writeAndRead("y_only", writeSchema, writeSchema.select(new String[]{"points.y"}), (RowData)row);
        Assert.assertEquals((String)"Should not project id", (long)1L, (long)projected.getArity());
        Assert.assertFalse((String)"Should project points list", (boolean)projected.isNullAt(0));
        points = projected.getArray(0);
        Assert.assertEquals((String)"Should read 2 points", (long)2L, (long)points.size());
        projectedP1 = points.getRow(0, 2);
        Assert.assertEquals((String)"Should not project x", (long)1L, (long)projectedP1.getArity());
        Assert.assertEquals((String)"Should project y", (long)2L, (long)projectedP1.getInt(0));
        projectedP2 = points.getRow(1, 2);
        Assert.assertEquals((String)"Should not project x", (long)1L, (long)projectedP2.getArity());
        Assert.assertTrue((String)"Should project null y", (boolean)projectedP2.isNullAt(0));
        Schema yRenamed = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)22, (String)"points", (Type)Types.ListType.ofOptional((int)21, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)18, (String)"z", (Type)Types.IntegerType.get())})))});
        projected = this.writeAndRead("y_renamed", writeSchema, yRenamed, (RowData)row);
        Assert.assertEquals((String)"Should not project id", (long)1L, (long)projected.getArity());
        Assert.assertFalse((String)"Should project points list", (boolean)projected.isNullAt(0));
        points = projected.getArray(0);
        Assert.assertEquals((String)"Should read 2 points", (long)2L, (long)points.size());
        projectedP1 = points.getRow(0, 2);
        Assert.assertEquals((String)"Should not project x and y", (long)1L, (long)projectedP1.getArity());
        Assert.assertEquals((String)"Should project z", (long)2L, (long)projectedP1.getInt(0));
        projectedP2 = points.getRow(1, 2);
        Assert.assertEquals((String)"Should not project x and y", (long)1L, (long)projectedP2.getArity());
        Assert.assertTrue((String)"Should project null z", (boolean)projectedP2.isNullAt(0));
    }

    @Test
    public void testAddedFieldsWithRequiredChildren() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"a", (Type)Types.LongType.get())});
        GenericRowData row = GenericRowData.of((Object[])new Object[]{100L});
        Schema addedFields = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"a", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"b", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"c", (Type)Types.LongType.get())})), Types.NestedField.optional((int)4, (String)"d", (Type)Types.ListType.ofRequired((int)5, (Type)Types.LongType.get())), Types.NestedField.optional((int)6, (String)"e", (Type)Types.MapType.ofRequired((int)7, (int)8, (Type)Types.LongType.get(), (Type)Types.LongType.get()))});
        RowData projected = this.writeAndRead("add_fields_with_required_children_projection", schema, addedFields, (RowData)row);
        Assert.assertEquals((String)"Should contain the correct value in column 1", (long)projected.getLong(0), (long)100L);
        Assert.assertTrue((String)"Should contain empty value in new column 2", (boolean)projected.isNullAt(1));
        Assert.assertTrue((String)"Should contain empty value in new column 4", (boolean)projected.isNullAt(2));
        Assert.assertTrue((String)"Should contain empty value in new column 6", (boolean)projected.isNullAt(3));
    }
}

