/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.data;

import org.apache.flink.table.data.RowData;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.flink.DataGenerator;
import org.apache.iceberg.flink.DataGenerators;
import org.apache.iceberg.flink.TestHelpers;
import org.apache.iceberg.flink.data.StructRowData;
import org.junit.Test;

public class TestStructRowData {
    protected void testConverter(DataGenerator dataGenerator) {
        StructRowData converter = new StructRowData(dataGenerator.icebergSchema().asStruct());
        GenericRecord expected = dataGenerator.generateIcebergGenericRecord();
        StructRowData actual = converter.setStruct((StructLike)expected);
        TestHelpers.assertRowData(dataGenerator.icebergSchema(), (StructLike)expected, (RowData)actual);
    }

    @Test
    public void testPrimitiveTypes() {
        this.testConverter(new DataGenerators.Primitives());
    }

    @Test
    public void testStructOfPrimitive() {
        this.testConverter(new DataGenerators.StructOfPrimitive());
    }

    @Test
    public void testStructOfArray() {
        this.testConverter(new DataGenerators.StructOfArray());
    }

    @Test
    public void testStructOfMap() {
        this.testConverter(new DataGenerators.StructOfMap());
    }

    @Test
    public void testStructOfStruct() {
        this.testConverter(new DataGenerators.StructOfStruct());
    }

    @Test
    public void testArrayOfPrimitive() {
        this.testConverter(new DataGenerators.ArrayOfPrimitive());
    }

    @Test
    public void testArrayOfArray() {
        this.testConverter(new DataGenerators.ArrayOfArray());
    }

    @Test
    public void testArrayOfMap() {
        this.testConverter(new DataGenerators.ArrayOfMap());
    }

    @Test
    public void testArrayOfStruct() {
        this.testConverter(new DataGenerators.ArrayOfStruct());
    }

    @Test
    public void testMapOfPrimitives() {
        this.testConverter(new DataGenerators.MapOfPrimitives());
    }

    @Test
    public void testMapOfArray() {
        this.testConverter(new DataGenerators.MapOfArray());
    }

    @Test
    public void testMapOfMap() {
        this.testConverter(new DataGenerators.MapOfMap());
    }

    @Test
    public void testMapOfStruct() {
        this.testConverter(new DataGenerators.MapOfStruct());
    }
}

