/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.test.util.MiniClusterWithClientResource;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.flink.HadoopCatalogResource;
import org.apache.iceberg.flink.MiniClusterResource;
import org.apache.iceberg.flink.SimpleDataUtil;
import org.apache.iceberg.flink.TestFixtures;
import org.apache.iceberg.flink.sink.TestFlinkIcebergSinkV2Base;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestFlinkIcebergSinkV2Branch
extends TestFlinkIcebergSinkV2Base {
    @ClassRule
    public static final MiniClusterWithClientResource MINI_CLUSTER_RESOURCE = MiniClusterResource.createWithClassloaderCheckDisabled();
    @ClassRule
    public static final TemporaryFolder TEMPORARY_FOLDER = new TemporaryFolder();
    @Rule
    public final HadoopCatalogResource catalogResource = new HadoopCatalogResource(TEMPORARY_FOLDER, "default", "t");
    private final String branch;

    @Parameterized.Parameters(name="branch = {0}")
    public static Object[] parameters() {
        return new Object[]{"main", "testBranch"};
    }

    public TestFlinkIcebergSinkV2Branch(String branch) {
        this.branch = branch;
    }

    @Before
    public void before() throws IOException {
        this.table = this.catalogResource.catalog().createTable(TestFixtures.TABLE_IDENTIFIER, SimpleDataUtil.SCHEMA, PartitionSpec.unpartitioned(), (Map)ImmutableMap.of((Object)"write.format.default", (Object)FileFormat.AVRO.name(), (Object)"format-version", (Object)"2"));
        this.env = StreamExecutionEnvironment.getExecutionEnvironment((Configuration)MiniClusterResource.DISABLE_CLASSLOADER_CHECK_CONFIG).enableCheckpointing(100L);
        this.tableLoader = this.catalogResource.tableLoader();
    }

    @Test
    public void testChangeLogOnIdKey() throws Exception {
        this.testChangeLogOnIdKey(this.branch);
        this.verifyOtherBranchUnmodified();
    }

    @Test
    public void testChangeLogOnDataKey() throws Exception {
        this.testChangeLogOnDataKey(this.branch);
        this.verifyOtherBranchUnmodified();
    }

    @Test
    public void testChangeLogOnIdDataKey() throws Exception {
        this.testChangeLogOnIdDataKey(this.branch);
        this.verifyOtherBranchUnmodified();
    }

    @Test
    public void testUpsertOnIdKey() throws Exception {
        this.testUpsertOnIdKey(this.branch);
        this.verifyOtherBranchUnmodified();
    }

    @Test
    public void testUpsertOnDataKey() throws Exception {
        this.testUpsertOnDataKey(this.branch);
        this.verifyOtherBranchUnmodified();
    }

    @Test
    public void testUpsertOnIdDataKey() throws Exception {
        this.testUpsertOnIdDataKey(this.branch);
        this.verifyOtherBranchUnmodified();
    }

    private void verifyOtherBranchUnmodified() {
        String otherBranch;
        String string = otherBranch = this.branch.equals("main") ? "test-branch" : "main";
        if (otherBranch.equals("main")) {
            Assert.assertNull((Object)this.table.currentSnapshot());
        }
        Assert.assertTrue((this.table.snapshot(otherBranch) == null ? 1 : 0) != 0);
    }
}

