/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Table;
import org.apache.iceberg.flink.sink.FlinkFileWriterFactory;
import org.apache.iceberg.io.FileWriterFactory;
import org.apache.iceberg.io.TestWriterMetrics;

public class TestFlinkWriterMetrics
extends TestWriterMetrics<RowData> {
    public TestFlinkWriterMetrics(FileFormat fileFormat) {
        super(fileFormat);
    }

    protected FileWriterFactory<RowData> newWriterFactory(Table sourceTable) {
        return FlinkFileWriterFactory.builderFor((Table)sourceTable).dataSchema(sourceTable.schema()).dataFileFormat(this.fileFormat).deleteFileFormat(this.fileFormat).positionDeleteRowSchema(sourceTable.schema()).build();
    }

    protected RowData toRow(Integer id, String data, boolean boolValue, Long longValue) {
        GenericRowData nested = GenericRowData.of((Object[])new Object[]{boolValue, longValue});
        GenericRowData row = GenericRowData.of((Object[])new Object[]{id, StringData.fromString((String)data), nested});
        return row;
    }

    public RowData toGenericRow(int value, int repeated) {
        GenericRowData row = new GenericRowData(repeated);
        for (int i = 0; i < repeated; ++i) {
            row.setField(i, (Object)value);
        }
        return row;
    }
}

