/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.generic.GenericData;
import org.apache.commons.collections.ListUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.types.Row;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Files;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.MetadataTableUtils;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.AvroIterable;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.data.FileHelpers;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.flink.CatalogTestBase;
import org.apache.iceberg.flink.TestHelpers;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.SnapshotUtil;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.io.TempDir;

public class TestFlinkMetaDataTable
extends CatalogTestBase {
    private static final String TABLE_NAME = "test_table";
    private final FileFormat format = FileFormat.AVRO;
    @TempDir
    private Path temp;
    @Parameter(index=2)
    private Boolean isPartition;

    @Parameters(name="catalogName={0}, baseNamespace={1}, isPartition={2}")
    protected static List<Object[]> parameters() {
        ArrayList parameters = Lists.newArrayList();
        for (Boolean isPartition : new Boolean[]{true, false}) {
            String catalogName = "testhadoop";
            Namespace baseNamespace = Namespace.of((String[])new String[]{"default"});
            parameters.add(new Object[]{catalogName, baseNamespace, isPartition});
        }
        return parameters;
    }

    @Override
    protected TableEnvironment getTableEnv() {
        Configuration configuration = super.getTableEnv().getConfig().getConfiguration();
        configuration.set(CoreOptions.DEFAULT_PARALLELISM, (Object)1);
        return super.getTableEnv();
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.sql("USE CATALOG %s", this.catalogName);
        this.sql("CREATE DATABASE %s", this.flinkDatabase);
        this.sql("USE %s", "db");
        if (this.isPartition.booleanValue()) {
            this.sql("CREATE TABLE %s (id INT, data VARCHAR,d DOUBLE) PARTITIONED BY (data) WITH ('format-version'='2', 'write.format.default'='%s')", TABLE_NAME, this.format.name());
            this.sql("INSERT INTO %s VALUES (1,'a',10),(2,'a',20)", TABLE_NAME);
            this.sql("INSERT INTO %s VALUES (1,'b',10),(2,'b',20)", TABLE_NAME);
        } else {
            this.sql("CREATE TABLE %s (id INT, data VARCHAR,d DOUBLE) WITH ('format-version'='2', 'write.format.default'='%s')", TABLE_NAME, this.format.name());
            this.sql("INSERT INTO %s VALUES (1,'iceberg',10),(2,'b',20),(3,CAST(NULL AS VARCHAR),30)", TABLE_NAME);
            this.sql("INSERT INTO %s VALUES (4,'iceberg',10)", TABLE_NAME);
        }
    }

    @Override
    @AfterEach
    public void clean() {
        this.sql("DROP TABLE IF EXISTS %s.%s", this.flinkDatabase, TABLE_NAME);
        this.sql("DROP DATABASE IF EXISTS %s", this.flinkDatabase);
        super.clean();
    }

    @TestTemplate
    public void testSnapshots() {
        String sql = String.format("SELECT * FROM %s$snapshots ", TABLE_NAME);
        List<Row> result = this.sql(sql, new Object[0]);
        Table table = this.validationCatalog.loadTable(TableIdentifier.of((Namespace)this.icebergNamespace, (String)TABLE_NAME));
        Iterator snapshots = table.snapshots().iterator();
        for (Row row : result) {
            Snapshot next = (Snapshot)snapshots.next();
            ((AbstractLongAssert)Assertions.assertThat((long)((Instant)row.getField(0)).toEpochMilli()).as("Should have expected timestamp", new Object[0])).isEqualTo(next.timestampMillis());
            ((AbstractLongAssert)Assertions.assertThat((long)next.snapshotId()).as("Should have expected snapshot id", new Object[0])).isEqualTo(next.snapshotId());
            ((ObjectAssert)Assertions.assertThat((Object)row.getField(2)).as("Should have expected parent id", new Object[0])).isEqualTo((Object)next.parentId());
            ((ObjectAssert)Assertions.assertThat((Object)row.getField(3)).as("Should have expected operation", new Object[0])).isEqualTo((Object)next.operation());
            ((ObjectAssert)Assertions.assertThat((Object)row.getField(4)).as("Should have expected manifest list location", new Object[0])).isEqualTo((Object)next.manifestListLocation());
            ((ObjectAssert)Assertions.assertThat((Object)row.getField(5)).as("Should have expected summary", new Object[0])).isEqualTo((Object)next.summary());
        }
    }

    @TestTemplate
    public void testHistory() {
        String sql = String.format("SELECT * FROM %s$history ", TABLE_NAME);
        List<Row> result = this.sql(sql, new Object[0]);
        Table table = this.validationCatalog.loadTable(TableIdentifier.of((Namespace)this.icebergNamespace, (String)TABLE_NAME));
        Iterator snapshots = table.snapshots().iterator();
        for (Row row : result) {
            Snapshot next = (Snapshot)snapshots.next();
            ((AbstractLongAssert)Assertions.assertThat((long)((Instant)row.getField(0)).toEpochMilli()).as("Should have expected made_current_at", new Object[0])).isEqualTo(next.timestampMillis());
            ((ObjectAssert)Assertions.assertThat((Object)row.getField(1)).as("Should have expected snapshot id", new Object[0])).isEqualTo((Object)next.snapshotId());
            ((ObjectAssert)Assertions.assertThat((Object)row.getField(2)).as("Should have expected parent id", new Object[0])).isEqualTo((Object)next.parentId());
            ((ObjectAssert)Assertions.assertThat((Object)row.getField(3)).as("Should have expected is current ancestor", new Object[0])).isEqualTo((Object)SnapshotUtil.isAncestorOf((Table)table, (long)table.currentSnapshot().snapshotId(), (long)next.snapshotId()));
        }
    }

    @TestTemplate
    public void testManifests() {
        String sql = String.format("SELECT * FROM %s$manifests ", TABLE_NAME);
        List<Row> result = this.sql(sql, new Object[0]);
        Table table = this.validationCatalog.loadTable(TableIdentifier.of((Namespace)this.icebergNamespace, (String)TABLE_NAME));
        List<ManifestFile> expectedDataManifests = this.dataManifests(table);
        for (int i = 0; i < result.size(); ++i) {
            Row row = result.get(i);
            ManifestFile manifestFile = expectedDataManifests.get(i);
            ((ObjectAssert)Assertions.assertThat((Object)row.getField(0)).as("Should have expected content", new Object[0])).isEqualTo((Object)manifestFile.content().id());
            ((ObjectAssert)Assertions.assertThat((Object)row.getField(1)).as("Should have expected path", new Object[0])).isEqualTo((Object)manifestFile.path());
            ((ObjectAssert)Assertions.assertThat((Object)row.getField(2)).as("Should have expected length", new Object[0])).isEqualTo((Object)manifestFile.length());
            ((ObjectAssert)Assertions.assertThat((Object)row.getField(3)).as("Should have expected partition_spec_id", new Object[0])).isEqualTo((Object)manifestFile.partitionSpecId());
            ((ObjectAssert)Assertions.assertThat((Object)row.getField(4)).as("Should have expected added_snapshot_id", new Object[0])).isEqualTo((Object)manifestFile.snapshotId());
            ((ObjectAssert)Assertions.assertThat((Object)row.getField(5)).as("Should have expected added_data_files_count", new Object[0])).isEqualTo((Object)manifestFile.addedFilesCount());
            ((ObjectAssert)Assertions.assertThat((Object)row.getField(6)).as("Should have expected existing_data_files_count", new Object[0])).isEqualTo((Object)manifestFile.existingFilesCount());
            ((ObjectAssert)Assertions.assertThat((Object)row.getField(7)).as("Should have expected deleted_data_files_count", new Object[0])).isEqualTo((Object)manifestFile.deletedFilesCount());
        }
    }

    @TestTemplate
    public void testAllManifests() {
        Table table = this.validationCatalog.loadTable(TableIdentifier.of((Namespace)this.icebergNamespace, (String)TABLE_NAME));
        String sql = String.format("SELECT * FROM %s$all_manifests ", TABLE_NAME);
        List<Row> result = this.sql(sql, new Object[0]);
        List<ManifestFile> expectedDataManifests = this.allDataManifests(table);
        Assertions.assertThat(expectedDataManifests).hasSize(result.size());
        for (int i = 0; i < result.size(); ++i) {
            Row row = result.get(i);
            ManifestFile manifestFile = expectedDataManifests.get(i);
            ((ObjectAssert)Assertions.assertThat((Object)row.getField(0)).as("Should have expected content", new Object[0])).isEqualTo((Object)manifestFile.content().id());
            ((ObjectAssert)Assertions.assertThat((Object)row.getField(1)).as("Should have expected path", new Object[0])).isEqualTo((Object)manifestFile.path());
            ((ObjectAssert)Assertions.assertThat((Object)row.getField(2)).as("Should have expected length", new Object[0])).isEqualTo((Object)manifestFile.length());
            ((ObjectAssert)Assertions.assertThat((Object)row.getField(3)).as("Should have expected partition_spec_id", new Object[0])).isEqualTo((Object)manifestFile.partitionSpecId());
            ((ObjectAssert)Assertions.assertThat((Object)row.getField(4)).as("Should have expected added_snapshot_id", new Object[0])).isEqualTo((Object)manifestFile.snapshotId());
            ((ObjectAssert)Assertions.assertThat((Object)row.getField(5)).as("Should have expected added_data_files_count", new Object[0])).isEqualTo((Object)manifestFile.addedFilesCount());
            ((ObjectAssert)Assertions.assertThat((Object)row.getField(6)).as("Should have expected existing_data_files_count", new Object[0])).isEqualTo((Object)manifestFile.existingFilesCount());
            ((ObjectAssert)Assertions.assertThat((Object)row.getField(7)).as("Should have expected deleted_data_files_count", new Object[0])).isEqualTo((Object)manifestFile.deletedFilesCount());
        }
    }

    @TestTemplate
    public void testUnPartitionedTable() throws IOException {
        Assumptions.assumeThat((Boolean)this.isPartition).isFalse();
        Table table = this.validationCatalog.loadTable(TableIdentifier.of((Namespace)this.icebergNamespace, (String)TABLE_NAME));
        Schema deleteRowSchema = table.schema().select(new String[]{"id"});
        GenericRecord dataDelete = GenericRecord.create((Schema)deleteRowSchema);
        ArrayList dataDeletes = Lists.newArrayList((Object[])new Record[]{dataDelete.copy("id", (Object)1)});
        File testFile = File.createTempFile("junit", null, this.temp.toFile());
        DeleteFile eqDeletes = FileHelpers.writeDeleteFile((Table)table, (OutputFile)Files.localOutput((File)testFile), (List)dataDeletes, (Schema)deleteRowSchema);
        table.newRowDelta().addDeletes(eqDeletes).commit();
        List<ManifestFile> expectedDataManifests = this.dataManifests(table);
        List<ManifestFile> expectedDeleteManifests = this.deleteManifests(table);
        Assertions.assertThat(expectedDataManifests).hasSize(2);
        Assertions.assertThat(expectedDeleteManifests).hasSize(1);
        Schema entriesTableSchema = MetadataTableUtils.createMetadataTableInstance((Table)table, (MetadataTableType)MetadataTableType.from((String)"entries")).schema();
        Schema deleteFilesTableSchema = MetadataTableUtils.createMetadataTableInstance((Table)table, (MetadataTableType)MetadataTableType.from((String)"delete_files")).schema();
        List deleteColumns = deleteFilesTableSchema.columns().stream().map(Types.NestedField::name).filter(c -> !c.equals("readable_metrics")).collect(Collectors.toList());
        String deleteNames = deleteColumns.stream().map(n -> "`" + n + "`").collect(Collectors.joining(","));
        deleteFilesTableSchema = deleteFilesTableSchema.select(deleteColumns);
        List<Row> actualDeleteFiles = this.sql("SELECT %s FROM %s$delete_files", deleteNames, TABLE_NAME);
        Assertions.assertThat(actualDeleteFiles).hasSize(1);
        ((ListAssert)Assertions.assertThat(expectedDeleteManifests).as("Should have 1 delete manifest", new Object[0])).hasSize(1);
        List<GenericData.Record> expectedDeleteFiles = this.expectedEntries(table, FileContent.EQUALITY_DELETES, entriesTableSchema, expectedDeleteManifests, null);
        ((ListAssert)Assertions.assertThat(expectedDeleteFiles).as("Should be 1 delete file manifest entry", new Object[0])).hasSize(1);
        TestHelpers.assertEquals(deleteFilesTableSchema, expectedDeleteFiles.get(0), actualDeleteFiles.get(0));
        Schema filesTableSchema = MetadataTableUtils.createMetadataTableInstance((Table)table, (MetadataTableType)MetadataTableType.from((String)"files")).schema();
        List columns = filesTableSchema.columns().stream().map(Types.NestedField::name).filter(c -> !c.equals("readable_metrics")).collect(Collectors.toList());
        String names = columns.stream().map(n -> "`" + n + "`").collect(Collectors.joining(","));
        filesTableSchema = filesTableSchema.select(columns);
        List<Row> actualDataFiles = this.sql("SELECT %s FROM %s$data_files", names, TABLE_NAME);
        ((ListAssert)Assertions.assertThat(actualDataFiles).as("Metadata table should return 2 data file", new Object[0])).hasSize(2);
        List<GenericData.Record> expectedDataFiles = this.expectedEntries(table, FileContent.DATA, entriesTableSchema, expectedDataManifests, null);
        ((ListAssert)Assertions.assertThat(expectedDataFiles).as("Should be 2 data file manifest entry", new Object[0])).hasSize(2);
        TestHelpers.assertEquals(filesTableSchema, expectedDataFiles.get(0), actualDataFiles.get(0));
        List<Row> actualFiles = this.sql("SELECT %s FROM %s$files ORDER BY content", names, TABLE_NAME);
        ((ListAssert)Assertions.assertThat(actualFiles).as("Metadata table should return 3 files", new Object[0])).hasSize(3);
        List expectedFiles = Stream.concat(expectedDataFiles.stream(), expectedDeleteFiles.stream()).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat(expectedFiles).as("Should have 3 files manifest entriess", new Object[0])).hasSize(3);
        TestHelpers.assertEquals(filesTableSchema, (GenericData.Record)expectedFiles.get(0), actualFiles.get(0));
        TestHelpers.assertEquals(filesTableSchema, (GenericData.Record)expectedFiles.get(1), actualFiles.get(1));
    }

    @TestTemplate
    public void testPartitionedTable() throws Exception {
        Assumptions.assumeThat((Boolean)this.isPartition).isTrue();
        Table table = this.validationCatalog.loadTable(TableIdentifier.of((Namespace)this.icebergNamespace, (String)TABLE_NAME));
        Schema deleteRowSchema = table.schema().select(new String[]{"id", "data"});
        GenericRecord dataDelete = GenericRecord.create((Schema)deleteRowSchema);
        HashMap deleteRow = Maps.newHashMap();
        deleteRow.put("id", 1);
        deleteRow.put("data", "a");
        File testFile = File.createTempFile("junit", null, this.temp.toFile());
        DeleteFile eqDeletes = FileHelpers.writeDeleteFile((Table)table, (OutputFile)Files.localOutput((File)testFile), (StructLike)TestHelpers.Row.of((Object[])new Object[]{"a"}), (List)Lists.newArrayList((Object[])new Record[]{dataDelete.copy((Map)deleteRow)}), (Schema)deleteRowSchema);
        table.newRowDelta().addDeletes(eqDeletes).commit();
        deleteRow.put("data", "b");
        File testFile2 = File.createTempFile("junit", null, this.temp.toFile());
        DeleteFile eqDeletes2 = FileHelpers.writeDeleteFile((Table)table, (OutputFile)Files.localOutput((File)testFile2), (StructLike)TestHelpers.Row.of((Object[])new Object[]{"b"}), (List)Lists.newArrayList((Object[])new Record[]{dataDelete.copy((Map)deleteRow)}), (Schema)deleteRowSchema);
        table.newRowDelta().addDeletes(eqDeletes2).commit();
        Schema entriesTableSchema = MetadataTableUtils.createMetadataTableInstance((Table)table, (MetadataTableType)MetadataTableType.from((String)"entries")).schema();
        List<ManifestFile> expectedDataManifests = this.dataManifests(table);
        List<ManifestFile> expectedDeleteManifests = this.deleteManifests(table);
        Assertions.assertThat(expectedDataManifests).hasSize(2);
        Assertions.assertThat(expectedDeleteManifests).hasSize(2);
        Table deleteFilesTable = MetadataTableUtils.createMetadataTableInstance((Table)table, (MetadataTableType)MetadataTableType.from((String)"delete_files"));
        Schema filesTableSchema = deleteFilesTable.schema();
        List columns = filesTableSchema.columns().stream().map(Types.NestedField::name).filter(c -> !c.equals("readable_metrics")).collect(Collectors.toList());
        String names = columns.stream().map(n -> "`" + n + "`").collect(Collectors.joining(","));
        filesTableSchema = filesTableSchema.select(columns);
        List<GenericData.Record> expectedDeleteFiles = this.expectedEntries(table, FileContent.EQUALITY_DELETES, entriesTableSchema, expectedDeleteManifests, "a");
        Assertions.assertThat(expectedDeleteFiles).hasSize(1);
        List<Row> actualDeleteFiles = this.sql("SELECT %s FROM %s$delete_files WHERE `partition`.`data`='a'", names, TABLE_NAME);
        Assertions.assertThat(actualDeleteFiles).hasSize(1);
        TestHelpers.assertEquals(filesTableSchema, expectedDeleteFiles.get(0), actualDeleteFiles.get(0));
        List<GenericData.Record> expectedDataFiles = this.expectedEntries(table, FileContent.DATA, entriesTableSchema, expectedDataManifests, "a");
        Assertions.assertThat(expectedDataFiles).hasSize(1);
        List<Row> actualDataFiles = this.sql("SELECT %s FROM %s$data_files  WHERE `partition`.`data`='a'", names, TABLE_NAME);
        Assertions.assertThat(actualDataFiles).hasSize(1);
        TestHelpers.assertEquals(filesTableSchema, expectedDataFiles.get(0), actualDataFiles.get(0));
        List<Row> actualPartitionsWithProjection = this.sql("SELECT file_count FROM %s$partitions ", TABLE_NAME);
        Assertions.assertThat(actualPartitionsWithProjection).hasSize(2);
        for (int i = 0; i < 2; ++i) {
            Assertions.assertThat((Object)actualPartitionsWithProjection.get(i).getField(0)).isEqualTo((Object)1);
        }
        List expectedFiles = Stream.concat(expectedDataFiles.stream(), expectedDeleteFiles.stream()).collect(Collectors.toList());
        Assertions.assertThat(expectedFiles).hasSize(2);
        List<Row> actualFiles = this.sql("SELECT %s FROM %s$files WHERE `partition`.`data`='a' ORDER BY content", names, TABLE_NAME);
        Assertions.assertThat(actualFiles).hasSize(2);
        TestHelpers.assertEquals(filesTableSchema, (GenericData.Record)expectedFiles.get(0), actualFiles.get(0));
        TestHelpers.assertEquals(filesTableSchema, (GenericData.Record)expectedFiles.get(1), actualFiles.get(1));
    }

    @TestTemplate
    public void testAllFilesUnpartitioned() throws Exception {
        Assumptions.assumeThat((Boolean)this.isPartition).isFalse();
        Table table = this.validationCatalog.loadTable(TableIdentifier.of((Namespace)this.icebergNamespace, (String)TABLE_NAME));
        Schema deleteRowSchema = table.schema().select(new String[]{"id", "data"});
        GenericRecord dataDelete = GenericRecord.create((Schema)deleteRowSchema);
        HashMap deleteRow = Maps.newHashMap();
        deleteRow.put("id", 1);
        File testFile = File.createTempFile("junit", null, this.temp.toFile());
        DeleteFile eqDeletes = FileHelpers.writeDeleteFile((Table)table, (OutputFile)Files.localOutput((File)testFile), (List)Lists.newArrayList((Object[])new Record[]{dataDelete.copy((Map)deleteRow)}), (Schema)deleteRowSchema);
        table.newRowDelta().addDeletes(eqDeletes).commit();
        List<ManifestFile> expectedDataManifests = this.dataManifests(table);
        Assertions.assertThat(expectedDataManifests).hasSize(2);
        List<ManifestFile> expectedDeleteManifests = this.deleteManifests(table);
        Assertions.assertThat(expectedDeleteManifests).hasSize(1);
        table.newDelete().deleteFromRowFilter((Expression)Expressions.alwaysTrue()).commit();
        Schema entriesTableSchema = MetadataTableUtils.createMetadataTableInstance((Table)table, (MetadataTableType)MetadataTableType.from((String)"entries")).schema();
        Schema filesTableSchema = MetadataTableUtils.createMetadataTableInstance((Table)table, (MetadataTableType)MetadataTableType.from((String)"all_data_files")).schema();
        List columns = filesTableSchema.columns().stream().map(Types.NestedField::name).filter(c -> !c.equals("readable_metrics")).collect(Collectors.toList());
        String names = columns.stream().map(n -> "`" + n + "`").collect(Collectors.joining(","));
        filesTableSchema = filesTableSchema.select(columns);
        List<Row> actualDataFiles = this.sql("SELECT %s FROM %s$all_data_files order by record_count ", names, TABLE_NAME);
        List<GenericData.Record> expectedDataFiles = this.expectedEntries(table, FileContent.DATA, entriesTableSchema, expectedDataManifests, null);
        Assertions.assertThat(expectedDataFiles).hasSize(2);
        Assertions.assertThat(actualDataFiles).hasSize(2);
        TestHelpers.assertEquals(filesTableSchema, expectedDataFiles, actualDataFiles);
        List<Row> actualDeleteFiles = this.sql("SELECT %s FROM %s$all_delete_files", names, TABLE_NAME);
        List<GenericData.Record> expectedDeleteFiles = this.expectedEntries(table, FileContent.EQUALITY_DELETES, entriesTableSchema, expectedDeleteManifests, null);
        Assertions.assertThat(expectedDeleteFiles).hasSize(1);
        Assertions.assertThat(actualDeleteFiles).hasSize(1);
        TestHelpers.assertEquals(filesTableSchema, expectedDeleteFiles.get(0), actualDeleteFiles.get(0));
        List<Row> actualFiles = this.sql("SELECT %s FROM %s$all_files ORDER BY content, record_count asc", names, TABLE_NAME);
        List expectedFiles = ListUtils.union(expectedDataFiles, expectedDeleteFiles);
        expectedFiles.sort(Comparator.comparing(r -> (Integer)r.get("content")));
        Assertions.assertThat(actualFiles).hasSize(3);
        TestHelpers.assertEquals(filesTableSchema, expectedFiles, actualFiles);
    }

    @TestTemplate
    public void testAllFilesPartitioned() throws Exception {
        Assumptions.assumeThat((this.isPartition == false ? 1 : 0) != 0).isFalse();
        Table table = this.validationCatalog.loadTable(TableIdentifier.of((Namespace)this.icebergNamespace, (String)TABLE_NAME));
        Schema deleteRowSchema = table.schema().select(new String[]{"id"});
        GenericRecord dataDelete = GenericRecord.create((Schema)deleteRowSchema);
        HashMap deleteRow = Maps.newHashMap();
        deleteRow.put("id", 1);
        File testFile = File.createTempFile("junit", null, this.temp.toFile());
        DeleteFile eqDeletes = FileHelpers.writeDeleteFile((Table)table, (OutputFile)Files.localOutput((File)testFile), (StructLike)TestHelpers.Row.of((Object[])new Object[]{"a"}), (List)Lists.newArrayList((Object[])new Record[]{dataDelete.copy((Map)deleteRow)}), (Schema)deleteRowSchema);
        File testFile2 = File.createTempFile("junit", null, this.temp.toFile());
        DeleteFile eqDeletes2 = FileHelpers.writeDeleteFile((Table)table, (OutputFile)Files.localOutput((File)testFile2), (StructLike)TestHelpers.Row.of((Object[])new Object[]{"b"}), (List)Lists.newArrayList((Object[])new Record[]{dataDelete.copy((Map)deleteRow)}), (Schema)deleteRowSchema);
        table.newRowDelta().addDeletes(eqDeletes).addDeletes(eqDeletes2).commit();
        List<ManifestFile> expectedDataManifests = this.dataManifests(table);
        Assertions.assertThat(expectedDataManifests).hasSize(2);
        List<ManifestFile> expectedDeleteManifests = this.deleteManifests(table);
        Assertions.assertThat(expectedDeleteManifests).hasSize(1);
        table.newDelete().deleteFromRowFilter((Expression)Expressions.alwaysTrue()).commit();
        Schema entriesTableSchema = MetadataTableUtils.createMetadataTableInstance((Table)table, (MetadataTableType)MetadataTableType.from((String)"entries")).schema();
        Schema filesTableSchema = MetadataTableUtils.createMetadataTableInstance((Table)table, (MetadataTableType)MetadataTableType.from((String)"all_data_files")).schema();
        List columns = filesTableSchema.columns().stream().map(Types.NestedField::name).filter(c -> !c.equals("readable_metrics")).collect(Collectors.toList());
        String names = columns.stream().map(n -> "`" + n + "`").collect(Collectors.joining(","));
        filesTableSchema = filesTableSchema.select(columns);
        List<Row> actualDataFiles = this.sql("SELECT %s FROM %s$all_data_files WHERE `partition`.`data`='a'", names, TABLE_NAME);
        List<GenericData.Record> expectedDataFiles = this.expectedEntries(table, FileContent.DATA, entriesTableSchema, expectedDataManifests, "a");
        Assertions.assertThat(expectedDataFiles).hasSize(1);
        Assertions.assertThat(actualDataFiles).hasSize(1);
        TestHelpers.assertEquals(filesTableSchema, expectedDataFiles.get(0), actualDataFiles.get(0));
        List<Row> actualDeleteFiles = this.sql("SELECT %s FROM %s$all_delete_files WHERE `partition`.`data`='a'", names, TABLE_NAME);
        List<GenericData.Record> expectedDeleteFiles = this.expectedEntries(table, FileContent.EQUALITY_DELETES, entriesTableSchema, expectedDeleteManifests, "a");
        Assertions.assertThat(expectedDeleteFiles).hasSize(1);
        Assertions.assertThat(actualDeleteFiles).hasSize(1);
        TestHelpers.assertEquals(filesTableSchema, expectedDeleteFiles.get(0), actualDeleteFiles.get(0));
        List<Row> actualFiles = this.sql("SELECT %s FROM %s$all_files WHERE `partition`.`data`='a' ORDER BY content", names, TABLE_NAME);
        List expectedFiles = ListUtils.union(expectedDataFiles, expectedDeleteFiles);
        expectedFiles.sort(Comparator.comparing(r -> (Integer)r.get("content")));
        Assertions.assertThat(actualFiles).hasSize(2);
        TestHelpers.assertEquals(filesTableSchema, expectedFiles, actualFiles);
    }

    @TestTemplate
    public void testMetadataLogEntries() {
        Table table = this.validationCatalog.loadTable(TableIdentifier.of((Namespace)this.icebergNamespace, (String)TABLE_NAME));
        Long currentSnapshotId = table.currentSnapshot().snapshotId();
        TableMetadata tableMetadata = ((HasTableOperations)table).operations().current();
        Snapshot currentSnapshot = tableMetadata.currentSnapshot();
        Snapshot parentSnapshot = table.snapshot(currentSnapshot.parentId().longValue());
        ArrayList metadataLogEntries = Lists.newArrayList((Iterable)tableMetadata.previousFiles());
        List<Row> metadataLogs = this.sql("SELECT * FROM %s$metadata_log_entries", TABLE_NAME);
        Assertions.assertThat(metadataLogs).hasSize(3);
        Row metadataLog = metadataLogs.get(0);
        Assertions.assertThat((Object)metadataLog.getField("timestamp")).isEqualTo((Object)Instant.ofEpochMilli(((TableMetadata.MetadataLogEntry)metadataLogEntries.get(0)).timestampMillis()));
        Assertions.assertThat((Object)metadataLog.getField("file")).isEqualTo((Object)((TableMetadata.MetadataLogEntry)metadataLogEntries.get(0)).file());
        Assertions.assertThat((Object)metadataLog.getField("latest_snapshot_id")).isNull();
        Assertions.assertThat((Object)metadataLog.getField("latest_schema_id")).isNull();
        Assertions.assertThat((Object)metadataLog.getField("latest_sequence_number")).isNull();
        metadataLog = metadataLogs.get(1);
        Assertions.assertThat((Object)metadataLog.getField("timestamp")).isEqualTo((Object)Instant.ofEpochMilli(((TableMetadata.MetadataLogEntry)metadataLogEntries.get(1)).timestampMillis()));
        Assertions.assertThat((Object)metadataLog.getField("file")).isEqualTo((Object)((TableMetadata.MetadataLogEntry)metadataLogEntries.get(1)).file());
        Assertions.assertThat((Object)metadataLog.getField("latest_snapshot_id")).isEqualTo((Object)parentSnapshot.snapshotId());
        Assertions.assertThat((Object)metadataLog.getField("latest_schema_id")).isEqualTo((Object)parentSnapshot.schemaId());
        Assertions.assertThat((Object)metadataLog.getField("latest_sequence_number")).isEqualTo((Object)parentSnapshot.sequenceNumber());
        Assertions.assertThat((Object)metadataLog.getField("latest_snapshot_id")).isEqualTo((Object)parentSnapshot.snapshotId());
        metadataLog = metadataLogs.get(2);
        Assertions.assertThat((Object)metadataLog.getField("timestamp")).isEqualTo((Object)Instant.ofEpochMilli(currentSnapshot.timestampMillis()));
        Assertions.assertThat((Object)metadataLog.getField("file")).isEqualTo((Object)tableMetadata.metadataFileLocation());
        Assertions.assertThat((Object)metadataLog.getField("latest_snapshot_id")).isEqualTo((Object)currentSnapshot.snapshotId());
        Assertions.assertThat((Object)metadataLog.getField("latest_schema_id")).isEqualTo((Object)currentSnapshot.schemaId());
        Assertions.assertThat((Object)metadataLog.getField("latest_sequence_number")).isEqualTo((Object)currentSnapshot.sequenceNumber());
        List<Row> metadataLogWithFilters = this.sql("SELECT * FROM %s$metadata_log_entries WHERE latest_snapshot_id = %s", TABLE_NAME, currentSnapshotId);
        Assertions.assertThat(metadataLogWithFilters).hasSize(1);
        metadataLog = metadataLogWithFilters.get(0);
        Assertions.assertThat((Instant)Instant.ofEpochMilli(tableMetadata.currentSnapshot().timestampMillis())).isEqualTo(metadataLog.getField("timestamp"));
        Assertions.assertThat((Object)metadataLog.getField("file")).isEqualTo((Object)tableMetadata.metadataFileLocation());
        Assertions.assertThat((Object)metadataLog.getField("latest_snapshot_id")).isEqualTo((Object)tableMetadata.currentSnapshot().snapshotId());
        Assertions.assertThat((Object)metadataLog.getField("latest_schema_id")).isEqualTo((Object)tableMetadata.currentSnapshot().schemaId());
        Assertions.assertThat((Object)metadataLog.getField("latest_sequence_number")).isEqualTo((Object)tableMetadata.currentSnapshot().sequenceNumber());
        List metadataFiles = metadataLogEntries.stream().map(TableMetadata.MetadataLogEntry::file).collect(Collectors.toList());
        metadataFiles.add(tableMetadata.metadataFileLocation());
        List<Row> metadataLogWithProjection = this.sql("SELECT file FROM %s$metadata_log_entries", TABLE_NAME);
        Assertions.assertThat(metadataLogWithProjection).hasSize(3);
        for (int i = 0; i < metadataFiles.size(); ++i) {
            Assertions.assertThat((Object)metadataLogWithProjection.get(i).getField("file")).isEqualTo(metadataFiles.get(i));
        }
    }

    @TestTemplate
    public void testSnapshotReferencesMetatable() {
        Table table = this.validationCatalog.loadTable(TableIdentifier.of((Namespace)this.icebergNamespace, (String)TABLE_NAME));
        Long currentSnapshotId = table.currentSnapshot().snapshotId();
        table.manageSnapshots().createBranch("testBranch", currentSnapshotId.longValue()).setMaxRefAgeMs("testBranch", 10L).setMinSnapshotsToKeep("testBranch", 20).setMaxSnapshotAgeMs("testBranch", 30L).commit();
        table.manageSnapshots().createTag("testTag", currentSnapshotId.longValue()).setMaxRefAgeMs("testTag", 50L).commit();
        List<Row> references = this.sql("SELECT * FROM %s$refs", TABLE_NAME);
        List<Row> branches = this.sql("SELECT * FROM %s$refs WHERE type='BRANCH'", TABLE_NAME);
        Assertions.assertThat(references).hasSize(3);
        Assertions.assertThat(branches).hasSize(2);
        List<Row> tags = this.sql("SELECT * FROM %s$refs WHERE type='TAG'", TABLE_NAME);
        Assertions.assertThat(tags).hasSize(1);
        List<Row> mainBranch = this.sql("SELECT * FROM %s$refs WHERE name='main' AND type='BRANCH'", TABLE_NAME);
        Assertions.assertThat((String)((String)mainBranch.get(0).getFieldAs("name"))).isEqualTo("main");
        Assertions.assertThat((String)((String)mainBranch.get(0).getFieldAs("type"))).isEqualTo("BRANCH");
        Assertions.assertThat((Long)((Long)mainBranch.get(0).getFieldAs("snapshot_id"))).isEqualTo((Object)currentSnapshotId);
        List<Row> testBranch = this.sql("SELECT * FROM  %s$refs WHERE name='testBranch' AND type='BRANCH'", TABLE_NAME);
        Assertions.assertThat((String)((String)testBranch.get(0).getFieldAs("name"))).isEqualTo("testBranch");
        Assertions.assertThat((String)((String)testBranch.get(0).getFieldAs("type"))).isEqualTo("BRANCH");
        Assertions.assertThat((Long)((Long)testBranch.get(0).getFieldAs("snapshot_id"))).isEqualTo((Object)currentSnapshotId);
        Assertions.assertThat((Long)((Long)testBranch.get(0).getFieldAs("max_reference_age_in_ms"))).isEqualTo((Object)10L);
        Assertions.assertThat((Integer)((Integer)testBranch.get(0).getFieldAs("min_snapshots_to_keep"))).isEqualTo((Object)20);
        Assertions.assertThat((Long)((Long)testBranch.get(0).getFieldAs("max_snapshot_age_in_ms"))).isEqualTo((Object)30L);
        List<Row> testTag = this.sql("SELECT * FROM %s$refs WHERE name='testTag' AND type='TAG'", TABLE_NAME);
        Assertions.assertThat((String)((String)testTag.get(0).getFieldAs("name"))).isEqualTo("testTag");
        Assertions.assertThat((String)((String)testTag.get(0).getFieldAs("type"))).isEqualTo("TAG");
        Assertions.assertThat((Long)((Long)testTag.get(0).getFieldAs("snapshot_id"))).isEqualTo((Object)currentSnapshotId);
        Assertions.assertThat((Long)((Long)testTag.get(0).getFieldAs("max_reference_age_in_ms"))).isEqualTo((Object)50L);
        List<Row> testTagProjection = this.sql("SELECT name,type,snapshot_id,max_reference_age_in_ms,min_snapshots_to_keep FROM %s$refs where type='TAG'", TABLE_NAME);
        Assertions.assertThat((String)((String)testTagProjection.get(0).getFieldAs("name"))).isEqualTo("testTag");
        Assertions.assertThat((String)((String)testTagProjection.get(0).getFieldAs("type"))).isEqualTo("TAG");
        Assertions.assertThat((Long)((Long)testTagProjection.get(0).getFieldAs("snapshot_id"))).isEqualTo((Object)currentSnapshotId);
        Assertions.assertThat((Long)((Long)testTagProjection.get(0).getFieldAs("max_reference_age_in_ms"))).isEqualTo((Object)50L);
        Assertions.assertThat((String)((String)testTagProjection.get(0).getFieldAs("min_snapshots_to_keep"))).isNull();
        List<Row> mainBranchProjection = this.sql("SELECT name, type FROM %s$refs WHERE name='main' AND type = 'BRANCH'", TABLE_NAME);
        Assertions.assertThat((String)((String)mainBranchProjection.get(0).getFieldAs("name"))).isEqualTo("main");
        Assertions.assertThat((String)((String)mainBranchProjection.get(0).getFieldAs("type"))).isEqualTo("BRANCH");
        List<Row> testBranchProjection = this.sql("SELECT type, name, max_reference_age_in_ms, snapshot_id FROM %s$refs WHERE name='testBranch' AND type = 'BRANCH'", TABLE_NAME);
        Assertions.assertThat((String)((String)testBranchProjection.get(0).getFieldAs("name"))).isEqualTo("testBranch");
        Assertions.assertThat((String)((String)testBranchProjection.get(0).getFieldAs("type"))).isEqualTo("BRANCH");
        Assertions.assertThat((Long)((Long)testBranchProjection.get(0).getFieldAs("snapshot_id"))).isEqualTo((Object)currentSnapshotId);
        Assertions.assertThat((Long)((Long)testBranchProjection.get(0).getFieldAs("max_reference_age_in_ms"))).isEqualTo((Object)10L);
    }

    private List<GenericData.Record> expectedEntries(Table table, FileContent expectedContent, Schema entriesTableSchema, List<ManifestFile> manifestsToExplore, String partValue) throws IOException {
        ArrayList expected = Lists.newArrayList();
        for (ManifestFile manifest : manifestsToExplore) {
            InputFile in = table.io().newInputFile(manifest.path());
            AvroIterable rows = Avro.read((InputFile)in).project(entriesTableSchema).build();
            Throwable throwable = null;
            try {
                for (GenericData.Record record : rows) {
                    GenericData.Record file;
                    if ((Integer)record.get("status") >= 2 || !this.partitionMatch(file = (GenericData.Record)record.get("data_file"), partValue)) continue;
                    this.asMetadataRecord(file, expectedContent);
                    expected.add(file);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rows == null) continue;
                if (throwable != null) {
                    try {
                        rows.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                rows.close();
            }
        }
        return expected;
    }

    private void asMetadataRecord(GenericData.Record file, FileContent content) {
        file.put(0, (Object)content.id());
        file.put(3, (Object)0);
    }

    private boolean partitionMatch(GenericData.Record file, String partValue) {
        if (partValue == null) {
            return true;
        }
        GenericData.Record partition = (GenericData.Record)file.get(4);
        return partValue.equals(partition.get(0).toString());
    }

    private List<ManifestFile> dataManifests(Table table) {
        return table.currentSnapshot().dataManifests(table.io());
    }

    private List<ManifestFile> allDataManifests(Table table) {
        ArrayList manifests = Lists.newArrayList();
        for (Snapshot snapshot : table.snapshots()) {
            manifests.addAll(snapshot.dataManifests(table.io()));
        }
        return manifests;
    }

    private List<ManifestFile> deleteManifests(Table table) {
        return table.currentSnapshot().deleteManifests(table.io());
    }
}

