/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.util.List;
import org.apache.flink.types.Row;
import org.apache.iceberg.flink.FlinkReadOptions;
import org.apache.iceberg.flink.source.TestFlinkTableSource;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestFlinkSourceConfig
extends TestFlinkTableSource {
    private static final String TABLE = "test_table";

    @Test
    public void testFlinkSessionConfig() {
        this.getTableEnv().getConfig().set(FlinkReadOptions.STREAMING_OPTION, (Object)true);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("SELECT * FROM %s /*+ OPTIONS('as-of-timestamp'='1')*/", TABLE)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot set as-of-timestamp option for streaming reader");
    }

    @Test
    public void testFlinkHintConfig() {
        List<Row> result = this.sql("SELECT * FROM %s /*+ OPTIONS('as-of-timestamp'='%d','streaming'='false')*/", TABLE, System.currentTimeMillis());
        Assert.assertEquals((long)3L, (long)result.size());
    }

    @Test
    public void testReadOptionHierarchy() {
        this.getTableEnv().getConfig().set(FlinkReadOptions.LIMIT_OPTION, (Object)1L);
        List<Row> result = this.sql("SELECT * FROM %s", TABLE);
        Assert.assertEquals((long)1L, (long)result.size());
        result = this.sql("SELECT * FROM %s /*+ OPTIONS('limit'='3')*/", TABLE);
        Assert.assertEquals((long)3L, (long)result.size());
    }
}

