/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.types.Row;
import org.apache.iceberg.Schema;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.flink.FlinkConfigOptions;
import org.apache.iceberg.flink.source.SqlHelpers;
import org.apache.iceberg.flink.source.TestIcebergSourceBounded;
import org.junit.jupiter.api.BeforeEach;

public class TestIcebergSourceBoundedSql
extends TestIcebergSourceBounded {
    private volatile TableEnvironment tEnv;

    @BeforeEach
    public void before() throws IOException {
        Configuration tableConf = this.getTableEnv().getConfig().getConfiguration();
        tableConf.setBoolean(FlinkConfigOptions.TABLE_EXEC_ICEBERG_USE_FLIP27_SOURCE.key(), true);
        SqlHelpers.sql(this.getTableEnv(), "create catalog iceberg_catalog with ('type'='iceberg', 'catalog-type'='hadoop', 'warehouse'='%s')", catalogExtension.warehouse());
        SqlHelpers.sql(this.getTableEnv(), "use catalog iceberg_catalog", new Object[0]);
        this.getTableEnv().getConfig().getConfiguration().set(TableConfigOptions.TABLE_DYNAMIC_TABLE_OPTIONS_ENABLED, (Object)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableEnvironment getTableEnv() {
        if (this.tEnv == null) {
            TestIcebergSourceBoundedSql testIcebergSourceBoundedSql = this;
            synchronized (testIcebergSourceBoundedSql) {
                if (this.tEnv == null) {
                    this.tEnv = TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.newInstance().inBatchMode().build());
                }
            }
        }
        return this.tEnv;
    }

    @Override
    protected List<Row> run(Schema projectedSchema, List<Expression> filters, Map<String, String> options, String sqlFilter, String ... sqlSelectedFields) throws Exception {
        String select = String.join((CharSequence)",", sqlSelectedFields);
        String optionStr = SqlHelpers.sqlOptionsToString(options);
        return SqlHelpers.sql(this.getTableEnv(), "select %s from t %s %s", select, optionStr, sqlFilter);
    }
}

