/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.types.Row;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.Files;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.data.FileHelpers;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.flink.CatalogTestBase;
import org.apache.iceberg.flink.TestHelpers;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.io.TempDir;

public class TestMetadataTableReadableMetrics
extends CatalogTestBase {
    private static final String TABLE_NAME = "test_table";
    @TempDir
    private Path temp;
    private static final Types.StructType LEAF_STRUCT_TYPE = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"leafLongCol", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"leafDoubleCol", (Type)Types.DoubleType.get())});
    private static final Types.StructType NESTED_STRUCT_TYPE = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"leafStructCol", (Type)LEAF_STRUCT_TYPE)});
    private static final Schema NESTED_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)4, (String)"nestedStructCol", (Type)NESTED_STRUCT_TYPE)});
    private static final Schema PRIMITIVE_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"booleanCol", (Type)Types.BooleanType.get()), Types.NestedField.required((int)2, (String)"intCol", (Type)Types.IntegerType.get()), Types.NestedField.required((int)3, (String)"longCol", (Type)Types.LongType.get()), Types.NestedField.required((int)4, (String)"floatCol", (Type)Types.FloatType.get()), Types.NestedField.required((int)5, (String)"doubleCol", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)6, (String)"decimalCol", (Type)Types.DecimalType.of((int)10, (int)2)), Types.NestedField.optional((int)7, (String)"stringCol", (Type)Types.StringType.get()), Types.NestedField.optional((int)8, (String)"fixedCol", (Type)Types.FixedType.ofLength((int)3)), Types.NestedField.optional((int)9, (String)"binaryCol", (Type)Types.BinaryType.get())});

    @Parameters(name="catalogName={0}, baseNamespace={1}")
    protected static List<Object[]> parameters() {
        ArrayList parameters = Lists.newArrayList();
        String catalogName = "testhive";
        Namespace baseNamespace = Namespace.empty();
        parameters.add(new Object[]{catalogName, baseNamespace});
        return parameters;
    }

    @Override
    protected TableEnvironment getTableEnv() {
        Configuration configuration = super.getTableEnv().getConfig().getConfiguration();
        configuration.set(CoreOptions.DEFAULT_PARALLELISM, (Object)1);
        return super.getTableEnv();
    }

    private Table createPrimitiveTable() throws IOException {
        Table table = catalog.createTable(TableIdentifier.of((String[])new String[]{"db", TABLE_NAME}), PRIMITIVE_SCHEMA, PartitionSpec.unpartitioned(), (Map)ImmutableMap.of());
        ArrayList records = Lists.newArrayList((Object[])new Record[]{this.createPrimitiveRecord(false, 1, 1L, 0.0f, 1.0, new BigDecimal("1.00"), "1", Base64.getDecoder().decode("1111"), ByteBuffer.wrap(Base64.getDecoder().decode("1111"))), this.createPrimitiveRecord(true, 2, 2L, 0.0f, 2.0, new BigDecimal("2.00"), "2", Base64.getDecoder().decode("2222"), ByteBuffer.wrap(Base64.getDecoder().decode("2222"))), this.createPrimitiveRecord(false, 1, 1L, Float.NaN, Double.NaN, null, "1", null, null), this.createPrimitiveRecord(false, 2, 2L, Float.NaN, 2.0, new BigDecimal("2.00"), "2", null, null)});
        File testFile = File.createTempFile("junit", null, this.temp.toFile());
        DataFile dataFile = FileHelpers.writeDataFile((Table)table, (OutputFile)Files.localOutput((File)testFile), (List)records);
        table.newAppend().appendFile(dataFile).commit();
        return table;
    }

    private void createNestedTable() throws IOException {
        Table table = this.validationCatalog.createTable(TableIdentifier.of((String[])new String[]{"db", TABLE_NAME}), NESTED_SCHEMA, PartitionSpec.unpartitioned(), (Map)ImmutableMap.of());
        ArrayList records = Lists.newArrayList((Object[])new Record[]{this.createNestedRecord(0L, 0.0), this.createNestedRecord(1L, Double.NaN), this.createNestedRecord(null, null)});
        File testFile = File.createTempFile("junit", null, this.temp.toFile());
        DataFile dataFile = FileHelpers.writeDataFile((Table)table, (OutputFile)Files.localOutput((File)testFile), (List)records);
        table.newAppend().appendFile(dataFile).commit();
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.sql("USE CATALOG %s", this.catalogName);
        this.sql("CREATE DATABASE %s", "db");
        this.sql("USE %s", "db");
    }

    @Override
    @AfterEach
    public void clean() {
        this.sql("DROP TABLE IF EXISTS %s.%s", this.flinkDatabase, TABLE_NAME);
        this.sql("DROP DATABASE IF EXISTS %s", this.flinkDatabase);
        super.clean();
    }

    protected GenericRecord createPrimitiveRecord(boolean booleanCol, int intCol, long longCol, float floatCol, double doubleCol, BigDecimal decimalCol, String stringCol, byte[] fixedCol, ByteBuffer binaryCol) {
        GenericRecord record = GenericRecord.create((Schema)PRIMITIVE_SCHEMA);
        record.set(0, (Object)booleanCol);
        record.set(1, (Object)intCol);
        record.set(2, (Object)longCol);
        record.set(3, (Object)Float.valueOf(floatCol));
        record.set(4, (Object)doubleCol);
        record.set(5, (Object)decimalCol);
        record.set(6, (Object)stringCol);
        record.set(7, (Object)fixedCol);
        record.set(8, (Object)binaryCol);
        return record;
    }

    private GenericRecord createNestedRecord(Long longCol, Double doubleCol) {
        GenericRecord record = GenericRecord.create((Schema)NESTED_SCHEMA);
        GenericRecord nested = GenericRecord.create((Types.StructType)NESTED_STRUCT_TYPE);
        GenericRecord leaf = GenericRecord.create((Types.StructType)LEAF_STRUCT_TYPE);
        leaf.set(0, (Object)longCol);
        leaf.set(1, (Object)doubleCol);
        nested.set(0, (Object)leaf);
        record.set(0, (Object)nested);
        return record;
    }

    protected Object[] row(Object ... values) {
        return values;
    }

    @TestTemplate
    public void testPrimitiveColumns() throws Exception {
        this.createPrimitiveTable();
        List<Row> result = this.sql("SELECT readable_metrics FROM %s$files", TABLE_NAME);
        Row binaryCol = Row.of((Object[])new Object[]{52L, 4L, 2L, null, Base64.getDecoder().decode("1111"), Base64.getDecoder().decode("2222")});
        Row booleanCol = Row.of((Object[])new Object[]{32L, 4L, 0L, null, false, true});
        Row decimalCol = Row.of((Object[])new Object[]{85L, 4L, 1L, null, new BigDecimal("1.00"), new BigDecimal("2.00")});
        Row doubleCol = Row.of((Object[])new Object[]{85L, 4L, 0L, 1L, 1.0, 2.0});
        Row fixedCol = Row.of((Object[])new Object[]{44L, 4L, 2L, null, Base64.getDecoder().decode("1111"), Base64.getDecoder().decode("2222")});
        Row floatCol = Row.of((Object[])new Object[]{71L, 4L, 0L, 2L, Float.valueOf(0.0f), Float.valueOf(0.0f)});
        Row intCol = Row.of((Object[])new Object[]{71L, 4L, 0L, null, 1, 2});
        Row longCol = Row.of((Object[])new Object[]{79L, 4L, 0L, null, 1L, 2L});
        Row stringCol = Row.of((Object[])new Object[]{79L, 4L, 0L, null, "1", "2"});
        ArrayList expected = Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{Row.of((Object[])new Object[]{binaryCol, booleanCol, decimalCol, doubleCol, fixedCol, floatCol, intCol, longCol, stringCol})})});
        TestHelpers.assertRows(result, expected);
    }

    @TestTemplate
    public void testSelectPrimitiveValues() throws Exception {
        this.createPrimitiveTable();
        TestHelpers.assertRows(this.sql("SELECT readable_metrics.intCol.lower_bound, readable_metrics.booleanCol.upper_bound FROM %s$files", TABLE_NAME), (List<Row>)ImmutableList.of((Object)Row.of((Object[])new Object[]{1, true})));
        TestHelpers.assertRows(this.sql("SELECT content, readable_metrics.longCol.value_count FROM %s$files", TABLE_NAME), (List<Row>)ImmutableList.of((Object)Row.of((Object[])new Object[]{0, 4L})));
        TestHelpers.assertRows(this.sql("SELECT readable_metrics.longCol.value_count, content FROM %s$files", TABLE_NAME), (List<Row>)ImmutableList.of((Object)Row.of((Object[])new Object[]{4L, 0})));
    }

    @TestTemplate
    public void testSelectNestedValues() throws Exception {
        this.createNestedTable();
        TestHelpers.assertRows(this.sql("SELECT readable_metrics.`nestedStructCol.leafStructCol.leafLongCol`.lower_bound, readable_metrics.`nestedStructCol.leafStructCol.leafDoubleCol`.value_count FROM %s$files", TABLE_NAME), (List<Row>)ImmutableList.of((Object)Row.of((Object[])new Object[]{0L, 3L})));
    }

    @TestTemplate
    public void testNestedValues() throws Exception {
        this.createNestedTable();
        Row leafDoubleCol = Row.of((Object[])new Object[]{46L, 3L, 1L, 1L, 0.0, 0.0});
        Row leafLongCol = Row.of((Object[])new Object[]{54L, 3L, 1L, null, 0L, 1L});
        Row metrics = Row.of((Object[])new Object[]{Row.of((Object[])new Object[]{leafDoubleCol, leafLongCol})});
        TestHelpers.assertRows(this.sql("SELECT readable_metrics FROM %s$files", TABLE_NAME), (List<Row>)ImmutableList.of((Object)metrics));
    }
}

