/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.enumerator;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.data.GenericAppenderHelper;
import org.apache.iceberg.data.RandomGenericData;
import org.apache.iceberg.flink.HadoopTableResource;
import org.apache.iceberg.flink.TestFixtures;
import org.apache.iceberg.flink.source.ScanContext;
import org.apache.iceberg.flink.source.StreamingStartingStrategy;
import org.apache.iceberg.flink.source.enumerator.ContinuousEnumerationResult;
import org.apache.iceberg.flink.source.enumerator.ContinuousSplitPlannerImpl;
import org.apache.iceberg.flink.source.enumerator.IcebergEnumeratorPosition;
import org.apache.iceberg.flink.source.split.IcebergSourceSplit;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestName;

public class TestContinuousSplitPlannerImpl {
    @ClassRule
    public static final TemporaryFolder TEMPORARY_FOLDER = new TemporaryFolder();
    private static final FileFormat fileFormat = FileFormat.PARQUET;
    private static final AtomicLong randomSeed = new AtomicLong();
    @Rule
    public final HadoopTableResource tableResource = new HadoopTableResource(TEMPORARY_FOLDER, "default", "t", TestFixtures.SCHEMA);
    @Rule
    public TestName testName = new TestName();
    private GenericAppenderHelper dataAppender;
    private DataFile dataFile1;
    private Snapshot snapshot1;
    private DataFile dataFile2;
    private Snapshot snapshot2;

    @Before
    public void before() throws IOException {
        this.dataAppender = new GenericAppenderHelper(this.tableResource.table(), fileFormat, TEMPORARY_FOLDER);
    }

    private void appendTwoSnapshots() throws IOException {
        List batch1 = RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)2, (long)0L);
        this.dataFile1 = this.dataAppender.writeFile(null, batch1);
        this.dataAppender.appendToTable(new DataFile[]{this.dataFile1});
        this.snapshot1 = this.tableResource.table().currentSnapshot();
        List batch2 = RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)2, (long)1L);
        this.dataFile2 = this.dataAppender.writeFile(null, batch2);
        this.dataAppender.appendToTable(new DataFile[]{this.dataFile2});
        this.snapshot2 = this.tableResource.table().currentSnapshot();
    }

    private CycleResult verifyOneCycle(ContinuousSplitPlannerImpl splitPlanner, IcebergEnumeratorPosition lastPosition) throws Exception {
        List batch = RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)2, (long)randomSeed.incrementAndGet());
        DataFile dataFile = this.dataAppender.writeFile(null, batch);
        this.dataAppender.appendToTable(new DataFile[]{dataFile});
        Snapshot snapshot = this.tableResource.table().currentSnapshot();
        ContinuousEnumerationResult result = splitPlanner.planSplits(lastPosition);
        Assert.assertEquals((Object)lastPosition.snapshotId(), (Object)result.fromPosition().snapshotId());
        Assert.assertEquals((Object)lastPosition.snapshotTimestampMs(), (Object)result.fromPosition().snapshotTimestampMs());
        Assert.assertEquals((long)snapshot.snapshotId(), (long)result.toPosition().snapshotId());
        Assert.assertEquals((long)snapshot.timestampMillis(), (long)result.toPosition().snapshotTimestampMs());
        Assert.assertEquals((long)1L, (long)result.splits().size());
        IcebergSourceSplit split = (IcebergSourceSplit)Iterables.getOnlyElement((Iterable)result.splits());
        Assert.assertEquals((long)1L, (long)split.task().files().size());
        Assert.assertEquals((Object)dataFile.path().toString(), (Object)((DataFile)((FileScanTask)Iterables.getOnlyElement((Iterable)split.task().files())).file()).path().toString());
        return new CycleResult(result.toPosition(), split);
    }

    @Test
    public void testTableScanThenIncrementalWithEmptyTable() throws Exception {
        ScanContext scanContext = ScanContext.builder().startingStrategy(StreamingStartingStrategy.TABLE_SCAN_THEN_INCREMENTAL).build();
        ContinuousSplitPlannerImpl splitPlanner = new ContinuousSplitPlannerImpl(this.tableResource.tableLoader().clone(), scanContext, null);
        ContinuousEnumerationResult emptyTableInitialDiscoveryResult = splitPlanner.planSplits(null);
        Assert.assertTrue((boolean)emptyTableInitialDiscoveryResult.splits().isEmpty());
        Assert.assertNull((Object)emptyTableInitialDiscoveryResult.fromPosition());
        Assert.assertTrue((boolean)emptyTableInitialDiscoveryResult.toPosition().isEmpty());
        Assert.assertNull((Object)emptyTableInitialDiscoveryResult.toPosition().snapshotTimestampMs());
        ContinuousEnumerationResult emptyTableSecondDiscoveryResult = splitPlanner.planSplits(emptyTableInitialDiscoveryResult.toPosition());
        Assert.assertTrue((boolean)emptyTableSecondDiscoveryResult.splits().isEmpty());
        Assert.assertTrue((boolean)emptyTableSecondDiscoveryResult.fromPosition().isEmpty());
        Assert.assertNull((Object)emptyTableSecondDiscoveryResult.fromPosition().snapshotTimestampMs());
        Assert.assertTrue((boolean)emptyTableSecondDiscoveryResult.toPosition().isEmpty());
        Assert.assertNull((Object)emptyTableSecondDiscoveryResult.toPosition().snapshotTimestampMs());
        IcebergEnumeratorPosition lastPosition = emptyTableSecondDiscoveryResult.toPosition();
        for (int i = 0; i < 3; ++i) {
            lastPosition = this.verifyOneCycle((ContinuousSplitPlannerImpl)splitPlanner, (IcebergEnumeratorPosition)lastPosition).lastPosition;
        }
    }

    @Test
    public void testTableScanThenIncrementalWithNonEmptyTable() throws Exception {
        this.appendTwoSnapshots();
        ScanContext scanContext = ScanContext.builder().startingStrategy(StreamingStartingStrategy.TABLE_SCAN_THEN_INCREMENTAL).build();
        ContinuousSplitPlannerImpl splitPlanner = new ContinuousSplitPlannerImpl(this.tableResource.tableLoader().clone(), scanContext, null);
        ContinuousEnumerationResult initialResult = splitPlanner.planSplits(null);
        Assert.assertNull((Object)initialResult.fromPosition());
        Assert.assertEquals((long)this.snapshot2.snapshotId(), (long)initialResult.toPosition().snapshotId());
        Assert.assertEquals((long)this.snapshot2.timestampMillis(), (long)initialResult.toPosition().snapshotTimestampMs());
        Assert.assertEquals((long)1L, (long)initialResult.splits().size());
        IcebergSourceSplit split = (IcebergSourceSplit)Iterables.getOnlyElement((Iterable)initialResult.splits());
        Assert.assertEquals((long)2L, (long)split.task().files().size());
        Set discoveredFiles = split.task().files().stream().map(fileScanTask -> ((DataFile)fileScanTask.file()).path().toString()).collect(Collectors.toSet());
        ImmutableSet expectedFiles = ImmutableSet.of((Object)this.dataFile1.path().toString(), (Object)this.dataFile2.path().toString());
        Assert.assertEquals((Object)expectedFiles, discoveredFiles);
        IcebergEnumeratorPosition lastPosition = initialResult.toPosition();
        for (int i = 0; i < 3; ++i) {
            lastPosition = this.verifyOneCycle((ContinuousSplitPlannerImpl)splitPlanner, (IcebergEnumeratorPosition)lastPosition).lastPosition;
        }
    }

    @Test
    public void testIncrementalFromLatestSnapshotWithEmptyTable() throws Exception {
        ScanContext scanContext = ScanContext.builder().startingStrategy(StreamingStartingStrategy.INCREMENTAL_FROM_LATEST_SNAPSHOT).splitSize(Long.valueOf(1L)).build();
        ContinuousSplitPlannerImpl splitPlanner = new ContinuousSplitPlannerImpl(this.tableResource.tableLoader().clone(), scanContext, null);
        ContinuousEnumerationResult emptyTableInitialDiscoveryResult = splitPlanner.planSplits(null);
        Assert.assertTrue((boolean)emptyTableInitialDiscoveryResult.splits().isEmpty());
        Assert.assertNull((Object)emptyTableInitialDiscoveryResult.fromPosition());
        Assert.assertTrue((boolean)emptyTableInitialDiscoveryResult.toPosition().isEmpty());
        Assert.assertNull((Object)emptyTableInitialDiscoveryResult.toPosition().snapshotTimestampMs());
        ContinuousEnumerationResult emptyTableSecondDiscoveryResult = splitPlanner.planSplits(emptyTableInitialDiscoveryResult.toPosition());
        Assert.assertTrue((boolean)emptyTableSecondDiscoveryResult.splits().isEmpty());
        Assert.assertTrue((boolean)emptyTableSecondDiscoveryResult.fromPosition().isEmpty());
        Assert.assertNull((Object)emptyTableSecondDiscoveryResult.fromPosition().snapshotTimestampMs());
        Assert.assertTrue((boolean)emptyTableSecondDiscoveryResult.toPosition().isEmpty());
        Assert.assertNull((Object)emptyTableSecondDiscoveryResult.toPosition().snapshotTimestampMs());
        this.appendTwoSnapshots();
        ContinuousEnumerationResult afterTwoSnapshotsAppended = splitPlanner.planSplits(emptyTableSecondDiscoveryResult.toPosition());
        Assert.assertEquals((long)2L, (long)afterTwoSnapshotsAppended.splits().size());
        IcebergEnumeratorPosition lastPosition = afterTwoSnapshotsAppended.toPosition();
        for (int i = 0; i < 3; ++i) {
            lastPosition = this.verifyOneCycle((ContinuousSplitPlannerImpl)splitPlanner, (IcebergEnumeratorPosition)lastPosition).lastPosition;
        }
    }

    @Test
    public void testIncrementalFromLatestSnapshotWithNonEmptyTable() throws Exception {
        this.appendTwoSnapshots();
        ScanContext scanContext = ScanContext.builder().startingStrategy(StreamingStartingStrategy.INCREMENTAL_FROM_LATEST_SNAPSHOT).build();
        ContinuousSplitPlannerImpl splitPlanner = new ContinuousSplitPlannerImpl(this.tableResource.tableLoader().clone(), scanContext, null);
        ContinuousEnumerationResult initialResult = splitPlanner.planSplits(null);
        Assert.assertNull((Object)initialResult.fromPosition());
        Assert.assertEquals((long)this.snapshot1.snapshotId(), (long)initialResult.toPosition().snapshotId());
        Assert.assertEquals((long)this.snapshot1.timestampMillis(), (long)initialResult.toPosition().snapshotTimestampMs());
        Assert.assertEquals((long)0L, (long)initialResult.splits().size());
        ContinuousEnumerationResult secondResult = splitPlanner.planSplits(initialResult.toPosition());
        Assert.assertEquals((long)this.snapshot1.snapshotId(), (long)secondResult.fromPosition().snapshotId());
        Assert.assertEquals((long)this.snapshot1.timestampMillis(), (long)secondResult.fromPosition().snapshotTimestampMs());
        Assert.assertEquals((long)this.snapshot2.snapshotId(), (long)secondResult.toPosition().snapshotId());
        Assert.assertEquals((long)this.snapshot2.timestampMillis(), (long)secondResult.toPosition().snapshotTimestampMs());
        IcebergSourceSplit split = (IcebergSourceSplit)Iterables.getOnlyElement((Iterable)secondResult.splits());
        Assert.assertEquals((long)1L, (long)split.task().files().size());
        Set discoveredFiles = split.task().files().stream().map(fileScanTask -> ((DataFile)fileScanTask.file()).path().toString()).collect(Collectors.toSet());
        ImmutableSet expectedFiles = ImmutableSet.of((Object)this.dataFile2.path().toString());
        Assert.assertEquals((Object)expectedFiles, discoveredFiles);
        IcebergEnumeratorPosition lastPosition = secondResult.toPosition();
        for (int i = 0; i < 3; ++i) {
            lastPosition = this.verifyOneCycle((ContinuousSplitPlannerImpl)splitPlanner, (IcebergEnumeratorPosition)lastPosition).lastPosition;
        }
    }

    @Test
    public void testIncrementalFromEarliestSnapshotWithEmptyTable() throws Exception {
        ScanContext scanContext = ScanContext.builder().startingStrategy(StreamingStartingStrategy.INCREMENTAL_FROM_EARLIEST_SNAPSHOT).build();
        ContinuousSplitPlannerImpl splitPlanner = new ContinuousSplitPlannerImpl(this.tableResource.tableLoader().clone(), scanContext, null);
        ContinuousEnumerationResult emptyTableInitialDiscoveryResult = splitPlanner.planSplits(null);
        Assert.assertTrue((boolean)emptyTableInitialDiscoveryResult.splits().isEmpty());
        Assert.assertNull((Object)emptyTableInitialDiscoveryResult.fromPosition());
        Assert.assertNull((Object)emptyTableInitialDiscoveryResult.toPosition().snapshotId());
        Assert.assertNull((Object)emptyTableInitialDiscoveryResult.toPosition().snapshotTimestampMs());
        ContinuousEnumerationResult emptyTableSecondDiscoveryResult = splitPlanner.planSplits(emptyTableInitialDiscoveryResult.toPosition());
        Assert.assertTrue((boolean)emptyTableSecondDiscoveryResult.splits().isEmpty());
        Assert.assertNull((Object)emptyTableSecondDiscoveryResult.fromPosition().snapshotId());
        Assert.assertNull((Object)emptyTableSecondDiscoveryResult.fromPosition().snapshotTimestampMs());
        Assert.assertNull((Object)emptyTableSecondDiscoveryResult.toPosition().snapshotId());
        Assert.assertNull((Object)emptyTableSecondDiscoveryResult.toPosition().snapshotTimestampMs());
        IcebergEnumeratorPosition lastPosition = emptyTableSecondDiscoveryResult.toPosition();
        for (int i = 0; i < 3; ++i) {
            lastPosition = this.verifyOneCycle((ContinuousSplitPlannerImpl)splitPlanner, (IcebergEnumeratorPosition)lastPosition).lastPosition;
        }
    }

    @Test
    public void testIncrementalFromEarliestSnapshotWithNonEmptyTable() throws Exception {
        this.appendTwoSnapshots();
        ScanContext scanContext = ScanContext.builder().startingStrategy(StreamingStartingStrategy.INCREMENTAL_FROM_EARLIEST_SNAPSHOT).build();
        ContinuousSplitPlannerImpl splitPlanner = new ContinuousSplitPlannerImpl(this.tableResource.tableLoader().clone(), scanContext, null);
        ContinuousEnumerationResult initialResult = splitPlanner.planSplits(null);
        Assert.assertNull((Object)initialResult.fromPosition());
        Assert.assertNull((Object)initialResult.toPosition().snapshotId());
        Assert.assertNull((Object)initialResult.toPosition().snapshotTimestampMs());
        Assert.assertEquals((long)0L, (long)initialResult.splits().size());
        ContinuousEnumerationResult secondResult = splitPlanner.planSplits(initialResult.toPosition());
        Assert.assertNull((Object)secondResult.fromPosition().snapshotId());
        Assert.assertNull((Object)secondResult.fromPosition().snapshotTimestampMs());
        Assert.assertEquals((long)this.snapshot2.snapshotId(), (long)secondResult.toPosition().snapshotId());
        Assert.assertEquals((long)this.snapshot2.timestampMillis(), (long)secondResult.toPosition().snapshotTimestampMs());
        IcebergSourceSplit split = (IcebergSourceSplit)Iterables.getOnlyElement((Iterable)secondResult.splits());
        Assert.assertEquals((long)2L, (long)split.task().files().size());
        Set discoveredFiles = split.task().files().stream().map(fileScanTask -> ((DataFile)fileScanTask.file()).path().toString()).collect(Collectors.toSet());
        ImmutableSet expectedFiles = ImmutableSet.of((Object)this.dataFile1.path().toString(), (Object)this.dataFile2.path().toString());
        Assert.assertEquals((Object)expectedFiles, discoveredFiles);
        IcebergEnumeratorPosition lastPosition = secondResult.toPosition();
        for (int i = 0; i < 3; ++i) {
            lastPosition = this.verifyOneCycle((ContinuousSplitPlannerImpl)splitPlanner, (IcebergEnumeratorPosition)lastPosition).lastPosition;
        }
    }

    @Test
    public void testIncrementalFromSnapshotIdWithEmptyTable() {
        ScanContext scanContextWithInvalidSnapshotId = ScanContext.builder().startingStrategy(StreamingStartingStrategy.INCREMENTAL_FROM_SNAPSHOT_ID).startSnapshotId(Long.valueOf(1L)).build();
        ContinuousSplitPlannerImpl splitPlanner = new ContinuousSplitPlannerImpl(this.tableResource.tableLoader().clone(), scanContextWithInvalidSnapshotId, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> splitPlanner.planSplits(null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Start snapshot id not found in history: 1");
    }

    @Test
    public void testIncrementalFromSnapshotIdWithInvalidIds() throws Exception {
        long invalidSnapshotId;
        this.appendTwoSnapshots();
        for (invalidSnapshotId = 0L; invalidSnapshotId == this.snapshot1.snapshotId() || invalidSnapshotId == this.snapshot2.snapshotId(); ++invalidSnapshotId) {
        }
        ScanContext scanContextWithInvalidSnapshotId = ScanContext.builder().startingStrategy(StreamingStartingStrategy.INCREMENTAL_FROM_SNAPSHOT_ID).startSnapshotId(Long.valueOf(invalidSnapshotId)).build();
        ContinuousSplitPlannerImpl splitPlanner = new ContinuousSplitPlannerImpl(this.tableResource.tableLoader().clone(), scanContextWithInvalidSnapshotId, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> splitPlanner.planSplits(null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Start snapshot id not found in history: " + invalidSnapshotId);
    }

    @Test
    public void testIncrementalFromSnapshotId() throws Exception {
        this.appendTwoSnapshots();
        ScanContext scanContext = ScanContext.builder().startingStrategy(StreamingStartingStrategy.INCREMENTAL_FROM_SNAPSHOT_ID).startSnapshotId(Long.valueOf(this.snapshot2.snapshotId())).build();
        ContinuousSplitPlannerImpl splitPlanner = new ContinuousSplitPlannerImpl(this.tableResource.tableLoader().clone(), scanContext, null);
        ContinuousEnumerationResult initialResult = splitPlanner.planSplits(null);
        Assert.assertNull((Object)initialResult.fromPosition());
        Assert.assertEquals((long)this.snapshot1.snapshotId(), (long)initialResult.toPosition().snapshotId());
        Assert.assertEquals((long)this.snapshot1.timestampMillis(), (long)initialResult.toPosition().snapshotTimestampMs());
        Assert.assertEquals((long)0L, (long)initialResult.splits().size());
        ContinuousEnumerationResult secondResult = splitPlanner.planSplits(initialResult.toPosition());
        Assert.assertEquals((long)this.snapshot1.snapshotId(), (long)secondResult.fromPosition().snapshotId());
        Assert.assertEquals((long)this.snapshot1.timestampMillis(), (long)secondResult.fromPosition().snapshotTimestampMs());
        Assert.assertEquals((long)this.snapshot2.snapshotId(), (long)secondResult.toPosition().snapshotId());
        Assert.assertEquals((long)this.snapshot2.timestampMillis(), (long)secondResult.toPosition().snapshotTimestampMs());
        IcebergSourceSplit split = (IcebergSourceSplit)Iterables.getOnlyElement((Iterable)secondResult.splits());
        Assert.assertEquals((long)1L, (long)split.task().files().size());
        Set discoveredFiles = split.task().files().stream().map(fileScanTask -> ((DataFile)fileScanTask.file()).path().toString()).collect(Collectors.toSet());
        ImmutableSet expectedFiles = ImmutableSet.of((Object)this.dataFile2.path().toString());
        Assert.assertEquals((Object)expectedFiles, discoveredFiles);
        IcebergEnumeratorPosition lastPosition = secondResult.toPosition();
        for (int i = 0; i < 3; ++i) {
            lastPosition = this.verifyOneCycle((ContinuousSplitPlannerImpl)splitPlanner, (IcebergEnumeratorPosition)lastPosition).lastPosition;
        }
    }

    @Test
    public void testIncrementalFromSnapshotTimestampWithEmptyTable() {
        ScanContext scanContextWithInvalidSnapshotId = ScanContext.builder().startingStrategy(StreamingStartingStrategy.INCREMENTAL_FROM_SNAPSHOT_TIMESTAMP).startSnapshotTimestamp(Long.valueOf(1L)).build();
        ContinuousSplitPlannerImpl splitPlanner = new ContinuousSplitPlannerImpl(this.tableResource.tableLoader().clone(), scanContextWithInvalidSnapshotId, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> splitPlanner.planSplits(null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot find a snapshot after: 1");
    }

    @Test
    public void testIncrementalFromSnapshotTimestampWithInvalidIds() throws Exception {
        this.appendTwoSnapshots();
        long invalidSnapshotTimestampMs = this.snapshot2.timestampMillis() + 1000L;
        ScanContext scanContextWithInvalidSnapshotId = ScanContext.builder().startingStrategy(StreamingStartingStrategy.INCREMENTAL_FROM_SNAPSHOT_TIMESTAMP).startSnapshotTimestamp(Long.valueOf(invalidSnapshotTimestampMs)).build();
        ContinuousSplitPlannerImpl splitPlanner = new ContinuousSplitPlannerImpl(this.tableResource.tableLoader().clone(), scanContextWithInvalidSnapshotId, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> splitPlanner.planSplits(null)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Cannot find a snapshot after: ");
    }

    @Test
    public void testIncrementalFromSnapshotTimestamp() throws Exception {
        this.appendTwoSnapshots();
        ScanContext scanContext = ScanContext.builder().startingStrategy(StreamingStartingStrategy.INCREMENTAL_FROM_SNAPSHOT_TIMESTAMP).startSnapshotTimestamp(Long.valueOf(this.snapshot2.timestampMillis())).build();
        ContinuousSplitPlannerImpl splitPlanner = new ContinuousSplitPlannerImpl(this.tableResource.tableLoader().clone(), scanContext, null);
        ContinuousEnumerationResult initialResult = splitPlanner.planSplits(null);
        Assert.assertNull((Object)initialResult.fromPosition());
        Assert.assertEquals((long)this.snapshot1.snapshotId(), (long)initialResult.toPosition().snapshotId());
        Assert.assertEquals((long)this.snapshot1.timestampMillis(), (long)initialResult.toPosition().snapshotTimestampMs());
        Assert.assertEquals((long)0L, (long)initialResult.splits().size());
        ContinuousEnumerationResult secondResult = splitPlanner.planSplits(initialResult.toPosition());
        Assert.assertEquals((long)this.snapshot1.snapshotId(), (long)secondResult.fromPosition().snapshotId());
        Assert.assertEquals((long)this.snapshot1.timestampMillis(), (long)secondResult.fromPosition().snapshotTimestampMs());
        Assert.assertEquals((long)this.snapshot2.snapshotId(), (long)secondResult.toPosition().snapshotId());
        Assert.assertEquals((long)this.snapshot2.timestampMillis(), (long)secondResult.toPosition().snapshotTimestampMs());
        IcebergSourceSplit split = (IcebergSourceSplit)Iterables.getOnlyElement((Iterable)secondResult.splits());
        Assert.assertEquals((long)1L, (long)split.task().files().size());
        Set discoveredFiles = split.task().files().stream().map(fileScanTask -> ((DataFile)fileScanTask.file()).path().toString()).collect(Collectors.toSet());
        ImmutableSet expectedFiles = ImmutableSet.of((Object)this.dataFile2.path().toString());
        Assert.assertEquals((Object)expectedFiles, discoveredFiles);
        IcebergEnumeratorPosition lastPosition = secondResult.toPosition();
        for (int i = 0; i < 3; ++i) {
            lastPosition = this.verifyOneCycle((ContinuousSplitPlannerImpl)splitPlanner, (IcebergEnumeratorPosition)lastPosition).lastPosition;
        }
    }

    @Test
    public void testMaxPlanningSnapshotCount() throws Exception {
        this.appendTwoSnapshots();
        for (int i = 2; i < 5; ++i) {
            this.appendSnapshot(i, 2);
        }
        ScanContext scanContext = ScanContext.builder().startingStrategy(StreamingStartingStrategy.INCREMENTAL_FROM_EARLIEST_SNAPSHOT).maxPlanningSnapshotCount(1).build();
        ContinuousSplitPlannerImpl splitPlanner = new ContinuousSplitPlannerImpl(this.tableResource.tableLoader().clone(), scanContext, null);
        ContinuousEnumerationResult initialResult = splitPlanner.planSplits(null);
        Assert.assertNull((Object)initialResult.fromPosition());
        Assert.assertNull((Object)initialResult.toPosition().snapshotId());
        Assert.assertNull((Object)initialResult.toPosition().snapshotTimestampMs());
        Assert.assertEquals((long)0L, (long)initialResult.splits().size());
        ContinuousEnumerationResult secondResult = splitPlanner.planSplits(initialResult.toPosition());
        this.verifyMaxPlanningSnapshotCountResult(secondResult, null, this.snapshot1, (Set<String>)ImmutableSet.of((Object)this.dataFile1.path().toString()));
        ContinuousEnumerationResult thirdResult = splitPlanner.planSplits(secondResult.toPosition());
        this.verifyMaxPlanningSnapshotCountResult(thirdResult, this.snapshot1, this.snapshot2, (Set<String>)ImmutableSet.of((Object)this.dataFile2.path().toString()));
    }

    @Test
    public void testTableScanNoStats() throws Exception {
        this.appendTwoSnapshots();
        ScanContext scanContext = ScanContext.builder().includeColumnStats(false).startingStrategy(StreamingStartingStrategy.TABLE_SCAN_THEN_INCREMENTAL).build();
        ContinuousSplitPlannerImpl splitPlanner = new ContinuousSplitPlannerImpl(this.tableResource.tableLoader().clone(), scanContext, null);
        ContinuousEnumerationResult initialResult = splitPlanner.planSplits(null);
        Assert.assertEquals((long)1L, (long)initialResult.splits().size());
        IcebergSourceSplit split = (IcebergSourceSplit)Iterables.getOnlyElement((Iterable)initialResult.splits());
        Assert.assertEquals((long)2L, (long)split.task().files().size());
        this.verifyStatCount(split, 0);
        IcebergEnumeratorPosition lastPosition = initialResult.toPosition();
        for (int i = 0; i < 3; ++i) {
            CycleResult result = this.verifyOneCycle(splitPlanner, lastPosition);
            this.verifyStatCount(result.split, 0);
            lastPosition = result.lastPosition;
        }
    }

    @Test
    public void testTableScanAllStats() throws Exception {
        this.appendTwoSnapshots();
        ScanContext scanContext = ScanContext.builder().includeColumnStats(true).startingStrategy(StreamingStartingStrategy.TABLE_SCAN_THEN_INCREMENTAL).build();
        ContinuousSplitPlannerImpl splitPlanner = new ContinuousSplitPlannerImpl(this.tableResource.tableLoader().clone(), scanContext, null);
        ContinuousEnumerationResult initialResult = splitPlanner.planSplits(null);
        Assert.assertEquals((long)1L, (long)initialResult.splits().size());
        IcebergSourceSplit split = (IcebergSourceSplit)Iterables.getOnlyElement((Iterable)initialResult.splits());
        Assert.assertEquals((long)2L, (long)split.task().files().size());
        this.verifyStatCount(split, 3);
        IcebergEnumeratorPosition lastPosition = initialResult.toPosition();
        for (int i = 0; i < 3; ++i) {
            CycleResult result = this.verifyOneCycle(splitPlanner, lastPosition);
            this.verifyStatCount(result.split, 3);
            lastPosition = result.lastPosition;
        }
    }

    @Test
    public void testTableScanSingleStat() throws Exception {
        this.appendTwoSnapshots();
        ScanContext scanContext = ScanContext.builder().includeColumnStats((Collection)ImmutableSet.of((Object)"data")).startingStrategy(StreamingStartingStrategy.TABLE_SCAN_THEN_INCREMENTAL).build();
        ContinuousSplitPlannerImpl splitPlanner = new ContinuousSplitPlannerImpl(this.tableResource.tableLoader().clone(), scanContext, null);
        ContinuousEnumerationResult initialResult = splitPlanner.planSplits(null);
        Assert.assertEquals((long)1L, (long)initialResult.splits().size());
        IcebergSourceSplit split = (IcebergSourceSplit)Iterables.getOnlyElement((Iterable)initialResult.splits());
        Assert.assertEquals((long)2L, (long)split.task().files().size());
        this.verifyStatCount(split, 1);
        IcebergEnumeratorPosition lastPosition = initialResult.toPosition();
        for (int i = 0; i < 3; ++i) {
            CycleResult result = this.verifyOneCycle(splitPlanner, lastPosition);
            this.verifyStatCount(result.split, 1);
            lastPosition = result.lastPosition;
        }
    }

    private void verifyStatCount(IcebergSourceSplit split, int expected) {
        if (expected == 0) {
            split.task().files().forEach(f -> {
                Assert.assertNull((Object)((DataFile)f.file()).valueCounts());
                Assert.assertNull((Object)((DataFile)f.file()).columnSizes());
                Assert.assertNull((Object)((DataFile)f.file()).lowerBounds());
                Assert.assertNull((Object)((DataFile)f.file()).upperBounds());
                Assert.assertNull((Object)((DataFile)f.file()).nanValueCounts());
                Assert.assertNull((Object)((DataFile)f.file()).nullValueCounts());
            });
        } else {
            split.task().files().forEach(f -> {
                Assert.assertEquals((long)expected, (long)((DataFile)f.file()).valueCounts().size());
                Assert.assertEquals((long)expected, (long)((DataFile)f.file()).columnSizes().size());
                Assert.assertEquals((long)expected, (long)((DataFile)f.file()).lowerBounds().size());
                Assert.assertEquals((long)expected, (long)((DataFile)f.file()).upperBounds().size());
                Assert.assertEquals((long)expected, (long)((DataFile)f.file()).nullValueCounts().size());
                Assert.assertEquals((long)0L, (long)((DataFile)f.file()).nanValueCounts().size());
            });
        }
    }

    private void verifyMaxPlanningSnapshotCountResult(ContinuousEnumerationResult result, Snapshot fromSnapshotExclusive, Snapshot toSnapshotInclusive, Set<String> expectedFiles) {
        if (fromSnapshotExclusive == null) {
            Assert.assertNull((Object)result.fromPosition().snapshotId());
            Assert.assertNull((Object)result.fromPosition().snapshotTimestampMs());
        } else {
            Assert.assertEquals((long)fromSnapshotExclusive.snapshotId(), (long)result.fromPosition().snapshotId());
            Assert.assertEquals((long)fromSnapshotExclusive.timestampMillis(), (long)result.fromPosition().snapshotTimestampMs());
        }
        Assert.assertEquals((long)toSnapshotInclusive.snapshotId(), (long)result.toPosition().snapshotId());
        Assert.assertEquals((long)toSnapshotInclusive.timestampMillis(), (long)result.toPosition().snapshotTimestampMs());
        IcebergSourceSplit split = (IcebergSourceSplit)Iterables.getOnlyElement((Iterable)result.splits());
        Assert.assertEquals((long)1L, (long)split.task().files().size());
        Set discoveredFiles = split.task().files().stream().map(fileScanTask -> ((DataFile)fileScanTask.file()).path().toString()).collect(Collectors.toSet());
        Assert.assertEquals(expectedFiles, discoveredFiles);
    }

    private Snapshot appendSnapshot(long seed, int numRecords) throws Exception {
        List batch = RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)numRecords, (long)seed);
        DataFile dataFile = this.dataAppender.writeFile(null, batch);
        this.dataAppender.appendToTable(new DataFile[]{dataFile});
        return this.tableResource.table().currentSnapshot();
    }

    private static class CycleResult {
        IcebergEnumeratorPosition lastPosition;
        IcebergSourceSplit split;

        CycleResult(IcebergEnumeratorPosition lastPosition, IcebergSourceSplit split) {
            this.lastPosition = lastPosition;
            this.split = split;
        }
    }
}

