/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.reader;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.table.data.RowData;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.BaseCombinedScanTask;
import org.apache.iceberg.BaseFileScanTask;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.Files;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.data.GenericAppenderFactory;
import org.apache.iceberg.data.RandomGenericData;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.encryption.PlaintextEncryptionManager;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.flink.TestFixtures;
import org.apache.iceberg.flink.source.DataIterator;
import org.apache.iceberg.flink.source.FileScanTaskReader;
import org.apache.iceberg.flink.source.RowDataFileScanTaskReader;
import org.apache.iceberg.hadoop.HadoopFileIO;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.junit.rules.TemporaryFolder;

public class ReaderUtil {
    private ReaderUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileScanTask createFileTask(List<Record> records, File file, FileFormat fileFormat, FileAppenderFactory<Record> appenderFactory) throws IOException {
        try (FileAppender appender = appenderFactory.newAppender(Files.localOutput((File)file), fileFormat);){
            appender.addAll(records);
        }
        DataFile dataFile = DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withRecordCount((long)records.size()).withFileSizeInBytes(file.length()).withPath(file.toString()).withFormat(fileFormat).withMetrics(appender.metrics()).build();
        ResidualEvaluator residuals = ResidualEvaluator.unpartitioned((Expression)Expressions.alwaysTrue());
        return new BaseFileScanTask(dataFile, null, SchemaParser.toJson((Schema)TestFixtures.SCHEMA), PartitionSpecParser.toJson((PartitionSpec)PartitionSpec.unpartitioned()), residuals);
    }

    public static DataIterator<RowData> createDataIterator(CombinedScanTask combinedTask) {
        return new DataIterator((FileScanTaskReader)new RowDataFileScanTaskReader(TestFixtures.SCHEMA, TestFixtures.SCHEMA, null, true, Collections.emptyList()), combinedTask, (FileIO)new HadoopFileIO(new Configuration()), (EncryptionManager)new PlaintextEncryptionManager());
    }

    public static List<List<Record>> createRecordBatchList(Schema schema, int listSize, int batchCount) {
        return ReaderUtil.createRecordBatchList(0L, schema, listSize, batchCount);
    }

    public static List<List<Record>> createRecordBatchList(long seed, Schema schema, int listSize, int batchCount) {
        List records = RandomGenericData.generate((Schema)schema, (int)(listSize * batchCount), (long)seed);
        return Lists.partition((List)records, (int)batchCount);
    }

    public static CombinedScanTask createCombinedScanTask(List<List<Record>> recordBatchList, TemporaryFolder temporaryFolder, FileFormat fileFormat, GenericAppenderFactory appenderFactory) throws IOException {
        ArrayList fileTasks = Lists.newArrayListWithCapacity((int)recordBatchList.size());
        for (List<Record> recordBatch : recordBatchList) {
            FileScanTask fileTask = ReaderUtil.createFileTask(recordBatch, temporaryFolder.newFile(), fileFormat, (FileAppenderFactory<Record>)appenderFactory);
            fileTasks.add(fileTask);
        }
        return new BaseCombinedScanTask((List)fileTasks);
    }
}

