/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.reader;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.base.source.reader.SourceReaderOptions;
import org.apache.flink.table.data.RowData;
import org.apache.iceberg.BaseCombinedScanTask;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.data.GenericAppenderFactory;
import org.apache.iceberg.data.RandomGenericData;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.flink.FlinkConfigOptions;
import org.apache.iceberg.flink.TestFixtures;
import org.apache.iceberg.flink.TestHelpers;
import org.apache.iceberg.flink.source.DataIterator;
import org.apache.iceberg.flink.source.reader.ArrayBatchRecords;
import org.apache.iceberg.flink.source.reader.ArrayPoolDataIteratorBatcher;
import org.apache.iceberg.flink.source.reader.DataIteratorBatcher;
import org.apache.iceberg.flink.source.reader.ReaderUtil;
import org.apache.iceberg.flink.source.reader.RecordAndPosition;
import org.apache.iceberg.flink.source.reader.RecordFactory;
import org.apache.iceberg.flink.source.reader.RowDataRecordFactory;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.FileAppenderFactory;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestArrayPoolDataIteratorBatcherRowData {
    @ClassRule
    public static final TemporaryFolder TEMPORARY_FOLDER = new TemporaryFolder();
    private static final FileFormat fileFormat = FileFormat.PARQUET;
    private final GenericAppenderFactory appenderFactory;
    private final DataIteratorBatcher<RowData> batcher;

    public TestArrayPoolDataIteratorBatcherRowData() {
        Configuration config = new Configuration();
        config.set(SourceReaderOptions.ELEMENT_QUEUE_CAPACITY, (Object)1);
        config.set(FlinkConfigOptions.SOURCE_READER_FETCH_BATCH_RECORD_COUNT, (Object)2);
        this.batcher = new ArrayPoolDataIteratorBatcher((ReadableConfig)config, (RecordFactory)new RowDataRecordFactory(TestFixtures.ROW_TYPE));
        this.appenderFactory = new GenericAppenderFactory(TestFixtures.SCHEMA);
    }

    @Test
    public void testSingleFileLessThanOneFullBatch() throws Exception {
        List records = RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)1, (long)1L);
        FileScanTask fileTask = ReaderUtil.createFileTask(records, TEMPORARY_FOLDER.newFile(), fileFormat, (FileAppenderFactory<Record>)this.appenderFactory);
        BaseCombinedScanTask combinedTask = new BaseCombinedScanTask(new FileScanTask[]{fileTask});
        DataIterator<RowData> dataIterator = ReaderUtil.createDataIterator((CombinedScanTask)combinedTask);
        String splitId = "someSplitId";
        CloseableIterator recordBatchIterator = this.batcher.batch(splitId, dataIterator);
        ArrayBatchRecords batch = (ArrayBatchRecords)recordBatchIterator.next();
        Assert.assertTrue((boolean)batch.finishedSplits().isEmpty());
        Assert.assertEquals((Object)splitId, (Object)batch.nextSplit());
        Assert.assertEquals((long)2L, (long)((RowData[])batch.records()).length);
        Assert.assertEquals((long)1L, (long)batch.numberOfRecords());
        RecordAndPosition recordAndPosition = batch.nextRecordFromSplit();
        Assert.assertEquals((long)0L, (long)recordAndPosition.fileOffset());
        Assert.assertEquals((long)1L, (long)recordAndPosition.recordOffset());
        TestHelpers.assertRowData(TestFixtures.SCHEMA, (StructLike)records.get(0), (RowData)recordAndPosition.record());
        Assert.assertNull((Object)batch.nextRecordFromSplit());
        Assert.assertNull((Object)batch.nextSplit());
        batch.recycle();
        Assert.assertFalse((boolean)recordBatchIterator.hasNext());
    }

    @Test
    public void testSingleFileWithMultipleBatches() throws Exception {
        List records = RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)5, (long)1L);
        FileScanTask fileTask = ReaderUtil.createFileTask(records, TEMPORARY_FOLDER.newFile(), fileFormat, (FileAppenderFactory<Record>)this.appenderFactory);
        BaseCombinedScanTask combinedTask = new BaseCombinedScanTask(new FileScanTask[]{fileTask});
        DataIterator<RowData> dataIterator = ReaderUtil.createDataIterator((CombinedScanTask)combinedTask);
        String splitId = "someSplitId";
        CloseableIterator recordBatchIterator = this.batcher.batch(splitId, dataIterator);
        ArrayBatchRecords batch0 = (ArrayBatchRecords)recordBatchIterator.next();
        Assert.assertTrue((boolean)batch0.finishedSplits().isEmpty());
        Assert.assertEquals((Object)splitId, (Object)batch0.nextSplit());
        Assert.assertEquals((long)2L, (long)((RowData[])batch0.records()).length);
        Assert.assertEquals((long)2L, (long)batch0.numberOfRecords());
        RecordAndPosition recordAndPosition = batch0.nextRecordFromSplit();
        Assert.assertEquals((long)0L, (long)recordAndPosition.fileOffset());
        Assert.assertEquals((long)1L, (long)recordAndPosition.recordOffset());
        TestHelpers.assertRowData(TestFixtures.SCHEMA, (StructLike)records.get(0), (RowData)recordAndPosition.record());
        recordAndPosition = batch0.nextRecordFromSplit();
        Assert.assertEquals((long)0L, (long)recordAndPosition.fileOffset());
        Assert.assertEquals((long)2L, (long)recordAndPosition.recordOffset());
        TestHelpers.assertRowData(TestFixtures.SCHEMA, (StructLike)records.get(1), (RowData)recordAndPosition.record());
        Assert.assertNull((Object)batch0.nextRecordFromSplit());
        Assert.assertNull((Object)batch0.nextSplit());
        batch0.recycle();
        ArrayBatchRecords batch1 = (ArrayBatchRecords)recordBatchIterator.next();
        Assert.assertSame((Object)batch0.records(), (Object)batch1.records());
        Assert.assertTrue((boolean)batch1.finishedSplits().isEmpty());
        Assert.assertEquals((Object)splitId, (Object)batch1.nextSplit());
        Assert.assertEquals((long)2L, (long)((RowData[])batch1.records()).length);
        Assert.assertEquals((long)2L, (long)batch1.numberOfRecords());
        recordAndPosition = batch1.nextRecordFromSplit();
        Assert.assertEquals((long)0L, (long)recordAndPosition.fileOffset());
        Assert.assertEquals((long)3L, (long)recordAndPosition.recordOffset());
        TestHelpers.assertRowData(TestFixtures.SCHEMA, (StructLike)records.get(2), (RowData)recordAndPosition.record());
        recordAndPosition = batch1.nextRecordFromSplit();
        Assert.assertEquals((long)0L, (long)recordAndPosition.fileOffset());
        Assert.assertEquals((long)4L, (long)recordAndPosition.recordOffset());
        TestHelpers.assertRowData(TestFixtures.SCHEMA, (StructLike)records.get(3), (RowData)recordAndPosition.record());
        Assert.assertNull((Object)batch1.nextRecordFromSplit());
        Assert.assertNull((Object)batch1.nextSplit());
        batch1.recycle();
        ArrayBatchRecords batch2 = (ArrayBatchRecords)recordBatchIterator.next();
        Assert.assertSame((Object)batch0.records(), (Object)batch2.records());
        Assert.assertTrue((boolean)batch2.finishedSplits().isEmpty());
        Assert.assertEquals((Object)splitId, (Object)batch2.nextSplit());
        Assert.assertEquals((long)2L, (long)((RowData[])batch2.records()).length);
        Assert.assertEquals((long)1L, (long)batch2.numberOfRecords());
        recordAndPosition = batch2.nextRecordFromSplit();
        Assert.assertEquals((long)0L, (long)recordAndPosition.fileOffset());
        Assert.assertEquals((long)5L, (long)recordAndPosition.recordOffset());
        TestHelpers.assertRowData(TestFixtures.SCHEMA, (StructLike)records.get(4), (RowData)recordAndPosition.record());
        Assert.assertNull((Object)batch2.nextRecordFromSplit());
        Assert.assertNull((Object)batch2.nextSplit());
        batch2.recycle();
        Assert.assertFalse((boolean)recordBatchIterator.hasNext());
    }

    @Test
    public void testMultipleFilesWithSeekPosition() throws Exception {
        List records0 = RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)1, (long)1L);
        FileScanTask fileTask0 = ReaderUtil.createFileTask(records0, TEMPORARY_FOLDER.newFile(), fileFormat, (FileAppenderFactory<Record>)this.appenderFactory);
        List records1 = RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)4, (long)2L);
        FileScanTask fileTask1 = ReaderUtil.createFileTask(records1, TEMPORARY_FOLDER.newFile(), fileFormat, (FileAppenderFactory<Record>)this.appenderFactory);
        List records2 = RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)3, (long)3L);
        FileScanTask fileTask2 = ReaderUtil.createFileTask(records2, TEMPORARY_FOLDER.newFile(), fileFormat, (FileAppenderFactory<Record>)this.appenderFactory);
        BaseCombinedScanTask combinedTask = new BaseCombinedScanTask(Arrays.asList(fileTask0, fileTask1, fileTask2));
        DataIterator<RowData> dataIterator = ReaderUtil.createDataIterator((CombinedScanTask)combinedTask);
        dataIterator.seek(1, 1L);
        String splitId = "someSplitId";
        CloseableIterator recordBatchIterator = this.batcher.batch(splitId, dataIterator);
        ArrayBatchRecords batch10 = (ArrayBatchRecords)recordBatchIterator.next();
        Assert.assertTrue((boolean)batch10.finishedSplits().isEmpty());
        Assert.assertEquals((Object)splitId, (Object)batch10.nextSplit());
        Assert.assertEquals((long)2L, (long)((RowData[])batch10.records()).length);
        Assert.assertEquals((long)2L, (long)batch10.numberOfRecords());
        RecordAndPosition recordAndPosition = batch10.nextRecordFromSplit();
        Assert.assertEquals((long)1L, (long)recordAndPosition.fileOffset());
        Assert.assertEquals((long)2L, (long)recordAndPosition.recordOffset());
        TestHelpers.assertRowData(TestFixtures.SCHEMA, (StructLike)records1.get(1), (RowData)recordAndPosition.record());
        recordAndPosition = batch10.nextRecordFromSplit();
        Assert.assertEquals((long)1L, (long)recordAndPosition.fileOffset());
        Assert.assertEquals((long)3L, (long)recordAndPosition.recordOffset());
        TestHelpers.assertRowData(TestFixtures.SCHEMA, (StructLike)records1.get(2), (RowData)recordAndPosition.record());
        Assert.assertNull((Object)batch10.nextRecordFromSplit());
        Assert.assertNull((Object)batch10.nextSplit());
        batch10.recycle();
        ArrayBatchRecords batch11 = (ArrayBatchRecords)recordBatchIterator.next();
        Assert.assertSame((Object)batch10.records(), (Object)batch11.records());
        Assert.assertTrue((boolean)batch11.finishedSplits().isEmpty());
        Assert.assertEquals((Object)splitId, (Object)batch11.nextSplit());
        Assert.assertEquals((long)2L, (long)((RowData[])batch11.records()).length);
        Assert.assertEquals((long)1L, (long)batch11.numberOfRecords());
        recordAndPosition = batch11.nextRecordFromSplit();
        Assert.assertEquals((long)1L, (long)recordAndPosition.fileOffset());
        Assert.assertEquals((long)4L, (long)recordAndPosition.recordOffset());
        TestHelpers.assertRowData(TestFixtures.SCHEMA, (StructLike)records1.get(3), (RowData)recordAndPosition.record());
        Assert.assertNull((Object)batch11.nextRecordFromSplit());
        Assert.assertNull((Object)batch11.nextSplit());
        batch11.recycle();
        ArrayBatchRecords batch20 = (ArrayBatchRecords)recordBatchIterator.next();
        Assert.assertSame((Object)batch10.records(), (Object)batch20.records());
        Assert.assertTrue((boolean)batch20.finishedSplits().isEmpty());
        Assert.assertEquals((Object)splitId, (Object)batch20.nextSplit());
        Assert.assertEquals((long)2L, (long)((RowData[])batch20.records()).length);
        Assert.assertEquals((long)2L, (long)batch20.numberOfRecords());
        recordAndPosition = batch20.nextRecordFromSplit();
        Assert.assertEquals((long)2L, (long)recordAndPosition.fileOffset());
        Assert.assertEquals((long)1L, (long)recordAndPosition.recordOffset());
        TestHelpers.assertRowData(TestFixtures.SCHEMA, (StructLike)records2.get(0), (RowData)recordAndPosition.record());
        recordAndPosition = batch20.nextRecordFromSplit();
        Assert.assertEquals((long)2L, (long)recordAndPosition.fileOffset());
        Assert.assertEquals((long)2L, (long)recordAndPosition.recordOffset());
        TestHelpers.assertRowData(TestFixtures.SCHEMA, (StructLike)records2.get(1), (RowData)recordAndPosition.record());
        Assert.assertNull((Object)batch20.nextRecordFromSplit());
        Assert.assertNull((Object)batch20.nextSplit());
        batch20.recycle();
        ArrayBatchRecords batch21 = (ArrayBatchRecords)recordBatchIterator.next();
        Assert.assertSame((Object)batch10.records(), (Object)batch21.records());
        Assert.assertTrue((boolean)batch21.finishedSplits().isEmpty());
        Assert.assertEquals((Object)splitId, (Object)batch21.nextSplit());
        Assert.assertEquals((long)2L, (long)((RowData[])batch21.records()).length);
        Assert.assertEquals((long)1L, (long)batch21.numberOfRecords());
        recordAndPosition = batch21.nextRecordFromSplit();
        Assert.assertEquals((long)2L, (long)recordAndPosition.fileOffset());
        Assert.assertEquals((long)3L, (long)recordAndPosition.recordOffset());
        TestHelpers.assertRowData(TestFixtures.SCHEMA, (StructLike)records2.get(2), (RowData)recordAndPosition.record());
        Assert.assertNull((Object)batch21.nextRecordFromSplit());
        Assert.assertNull((Object)batch21.nextSplit());
        batch21.recycle();
        Assert.assertFalse((boolean)recordBatchIterator.hasNext());
    }
}

