/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.reader;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.conversion.DataStructureConverter;
import org.apache.flink.table.data.conversion.DataStructureConverters;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.Row;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.encryption.PlaintextEncryptionManager;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.TestFixtures;
import org.apache.iceberg.flink.TestHelpers;
import org.apache.iceberg.flink.source.reader.ReaderFunction;
import org.apache.iceberg.flink.source.reader.ReaderFunctionTestBase;
import org.apache.iceberg.flink.source.reader.RowDataReaderFunction;
import org.apache.iceberg.hadoop.HadoopFileIO;
import org.apache.iceberg.io.FileIO;

public class TestRowDataReaderFunction
extends ReaderFunctionTestBase<RowData> {
    protected static final RowType rowType = FlinkSchemaUtil.convert((Schema)TestFixtures.SCHEMA);
    private static final DataStructureConverter<Object, Object> rowDataConverter = DataStructureConverters.getConverter((DataType)TypeConversions.fromLogicalToDataType((LogicalType)rowType));

    public TestRowDataReaderFunction(FileFormat fileFormat) {
        super(fileFormat);
    }

    @Override
    protected ReaderFunction<RowData> readerFunction() {
        return new RowDataReaderFunction((ReadableConfig)new Configuration(), TestFixtures.SCHEMA, TestFixtures.SCHEMA, null, true, (FileIO)new HadoopFileIO(new org.apache.hadoop.conf.Configuration()), (EncryptionManager)new PlaintextEncryptionManager(), Collections.emptyList());
    }

    @Override
    protected void assertRecords(List<Record> expected, List<RowData> actual, Schema schema) {
        List<Row> rows = this.toRows(actual);
        TestHelpers.assertRecords(rows, expected, TestFixtures.SCHEMA);
    }

    private List<Row> toRows(List<RowData> actual) {
        return actual.stream().map(rowData -> (Row)rowDataConverter.toExternal(rowData)).collect(Collectors.toList());
    }
}

