/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.reader;

import java.util.Map;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.metrics.groups.OperatorIOMetricGroup;
import org.apache.flink.metrics.groups.SourceReaderMetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

class TestingMetricGroup
extends UnregisteredMetricsGroup
implements SourceReaderMetricGroup {
    private final Map<String, Counter> counters;

    TestingMetricGroup() {
        this.counters = Maps.newHashMap();
    }

    private TestingMetricGroup(Map<String, Counter> counters) {
        this.counters = counters;
    }

    Map<String, Counter> counters() {
        return this.counters;
    }

    public Counter counter(String name) {
        SimpleCounter counter = new SimpleCounter();
        this.counters.put(name, (Counter)counter);
        return counter;
    }

    public MetricGroup addGroup(String name) {
        return new TestingMetricGroup(this.counters);
    }

    public MetricGroup addGroup(String key, String value) {
        return new TestingMetricGroup(this.counters);
    }

    public OperatorIOMetricGroup getIOMetricGroup() {
        return new TestingOperatorIOMetricGroup();
    }

    public Counter getNumRecordsInErrorsCounter() {
        return new SimpleCounter();
    }

    public void setPendingBytesGauge(Gauge<Long> pendingBytesGauge) {
    }

    public void setPendingRecordsGauge(Gauge<Long> pendingRecordsGauge) {
    }

    private static class TestingOperatorIOMetricGroup
    extends UnregisteredMetricsGroup
    implements OperatorIOMetricGroup {
        private TestingOperatorIOMetricGroup() {
        }

        public Counter getNumRecordsInCounter() {
            return new SimpleCounter();
        }

        public Counter getNumRecordsOutCounter() {
            return new SimpleCounter();
        }

        public Counter getNumBytesInCounter() {
            return new SimpleCounter();
        }

        public Counter getNumBytesOutCounter() {
            return new SimpleCounter();
        }
    }
}

