/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.split;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.flink.source.SplitHelpers;
import org.apache.iceberg.flink.source.split.IcebergSourceSplit;
import org.apache.iceberg.flink.source.split.IcebergSourceSplitSerializer;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestIcebergSourceSplitSerializer {
    @ClassRule
    public static final TemporaryFolder TEMPORARY_FOLDER = new TemporaryFolder();
    private final IcebergSourceSplitSerializer serializer = new IcebergSourceSplitSerializer(true);

    @Test
    public void testLatestVersion() throws Exception {
        this.serializeAndDeserialize(1, 1);
        this.serializeAndDeserialize(10, 2);
    }

    private void serializeAndDeserialize(int splitCount, int filesPerSplit) throws Exception {
        List<IcebergSourceSplit> splits = SplitHelpers.createSplitsFromTransientHadoopTable(TEMPORARY_FOLDER, splitCount, filesPerSplit);
        for (IcebergSourceSplit split : splits) {
            byte[] result = this.serializer.serialize(split);
            IcebergSourceSplit deserialized = this.serializer.deserialize(this.serializer.getVersion(), result);
            this.assertSplitEquals(split, deserialized);
            byte[] cachedResult = this.serializer.serialize(split);
            Assert.assertSame((Object)result, (Object)cachedResult);
            IcebergSourceSplit deserialized2 = this.serializer.deserialize(this.serializer.getVersion(), cachedResult);
            this.assertSplitEquals(split, deserialized2);
            split.updatePosition(0, 100L);
            byte[] resultAfterUpdatePosition = this.serializer.serialize(split);
            Assert.assertNotSame((Object)cachedResult, (Object)resultAfterUpdatePosition);
            IcebergSourceSplit deserialized3 = this.serializer.deserialize(this.serializer.getVersion(), resultAfterUpdatePosition);
            this.assertSplitEquals(split, deserialized3);
        }
    }

    @Test
    public void testV1() throws Exception {
        this.serializeAndDeserializeV1(1, 1);
        this.serializeAndDeserializeV1(10, 2);
    }

    private void serializeAndDeserializeV1(int splitCount, int filesPerSplit) throws Exception {
        List<IcebergSourceSplit> splits = SplitHelpers.createSplitsFromTransientHadoopTable(TEMPORARY_FOLDER, splitCount, filesPerSplit);
        for (IcebergSourceSplit split : splits) {
            byte[] result = split.serializeV1();
            IcebergSourceSplit deserialized = IcebergSourceSplit.deserializeV1((byte[])result);
            this.assertSplitEquals(split, deserialized);
        }
    }

    @Test
    public void testV2() throws Exception {
        this.serializeAndDeserializeV2(1, 1);
        this.serializeAndDeserializeV2(10, 2);
    }

    private void serializeAndDeserializeV2(int splitCount, int filesPerSplit) throws Exception {
        List<IcebergSourceSplit> splits = SplitHelpers.createSplitsFromTransientHadoopTable(TEMPORARY_FOLDER, splitCount, filesPerSplit);
        for (IcebergSourceSplit split : splits) {
            byte[] result = split.serializeV2();
            IcebergSourceSplit deserialized = IcebergSourceSplit.deserializeV2((byte[])result, (boolean)true);
            this.assertSplitEquals(split, deserialized);
        }
    }

    @Test
    public void testDeserializeV1() throws Exception {
        List<IcebergSourceSplit> splits = SplitHelpers.createSplitsFromTransientHadoopTable(TEMPORARY_FOLDER, 1, 1);
        for (IcebergSourceSplit split : splits) {
            byte[] result = split.serializeV1();
            IcebergSourceSplit deserialized = this.serializer.deserialize(1, result);
            this.assertSplitEquals(split, deserialized);
        }
    }

    @Test
    public void testCheckpointedPosition() throws Exception {
        AtomicInteger index = new AtomicInteger();
        List splits = SplitHelpers.createSplitsFromTransientHadoopTable(TEMPORARY_FOLDER, 10, 2).stream().map(split -> {
            IcebergSourceSplit result = index.get() % 2 == 0 ? IcebergSourceSplit.fromCombinedScanTask((CombinedScanTask)split.task(), (int)1, (long)1L) : split;
            index.incrementAndGet();
            return result;
        }).collect(Collectors.toList());
        for (IcebergSourceSplit split2 : splits) {
            byte[] result = this.serializer.serialize(split2);
            IcebergSourceSplit deserialized = this.serializer.deserialize(this.serializer.getVersion(), result);
            this.assertSplitEquals(split2, deserialized);
            byte[] cachedResult = this.serializer.serialize(split2);
            Assert.assertSame((Object)result, (Object)cachedResult);
            IcebergSourceSplit deserialized2 = this.serializer.deserialize(this.serializer.getVersion(), cachedResult);
            this.assertSplitEquals(split2, deserialized2);
        }
    }

    private void assertSplitEquals(IcebergSourceSplit expected, IcebergSourceSplit actual) {
        ArrayList expectedTasks = Lists.newArrayList(expected.task().tasks().iterator());
        ArrayList actualTasks = Lists.newArrayList(actual.task().tasks().iterator());
        Assert.assertEquals((long)expectedTasks.size(), (long)actualTasks.size());
        for (int i = 0; i < expectedTasks.size(); ++i) {
            FileScanTask expectedTask = (FileScanTask)expectedTasks.get(i);
            FileScanTask actualTask = (FileScanTask)actualTasks.get(i);
            Assert.assertEquals((Object)((DataFile)expectedTask.file()).path(), (Object)((DataFile)actualTask.file()).path());
            Assert.assertEquals((long)expectedTask.sizeBytes(), (long)actualTask.sizeBytes());
            Assert.assertEquals((long)expectedTask.filesCount(), (long)actualTask.filesCount());
            Assert.assertEquals((long)expectedTask.start(), (long)actualTask.start());
            Assert.assertEquals((long)expectedTask.length(), (long)actualTask.length());
        }
        Assert.assertEquals((long)expected.fileOffset(), (long)actual.fileOffset());
        Assert.assertEquals((long)expected.recordOffset(), (long)actual.recordOffset());
    }
}

