/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.util;

import org.apache.iceberg.flink.util.FlinkPackage;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class TestFlinkPackage {
    @Test
    public void testVersion() {
        Assert.assertEquals((Object)"1.16.2", (Object)FlinkPackage.version());
    }

    @Test
    public void testDefaultVersion() {
        FlinkPackage.setVersion(null);
        try (MockedStatic mockedStatic = Mockito.mockStatic(FlinkPackage.class);){
            mockedStatic.when(FlinkPackage::versionFromJar).thenThrow(RuntimeException.class);
            mockedStatic.when(FlinkPackage::version).thenCallRealMethod();
            Assert.assertEquals((Object)"FLINK-UNKNOWN-VERSION", (Object)FlinkPackage.version());
        }
        FlinkPackage.setVersion(null);
        mockedStatic = Mockito.mockStatic(FlinkPackage.class);
        var2_2 = null;
        try {
            mockedStatic.when(FlinkPackage::versionFromJar).thenReturn(null);
            mockedStatic.when(FlinkPackage::version).thenCallRealMethod();
            FlinkPackage.setVersion(null);
            Assert.assertEquals((Object)"FLINK-UNKNOWN-VERSION", (Object)FlinkPackage.version());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (mockedStatic != null) {
                TestFlinkPackage.$closeResource(var2_2, (AutoCloseable)mockedStatic);
            }
        }
    }
}

