/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.data;

import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.NullType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.iceberg.avro.AvroWithPartnerByStructureVisitor;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.Pair;

public abstract class AvroWithFlinkSchemaVisitor<T>
extends AvroWithPartnerByStructureVisitor<LogicalType, T> {
    protected boolean isStringType(LogicalType logicalType) {
        return logicalType.getTypeRoot().getFamilies().contains(LogicalTypeFamily.CHARACTER_STRING);
    }

    protected boolean isMapType(LogicalType logicalType) {
        return logicalType instanceof MapType;
    }

    protected LogicalType arrayElementType(LogicalType arrayType) {
        Preconditions.checkArgument((boolean)(arrayType instanceof ArrayType), (String)"Invalid array: %s is not an array", (Object)arrayType);
        return ((ArrayType)arrayType).getElementType();
    }

    protected LogicalType mapKeyType(LogicalType mapType) {
        Preconditions.checkArgument((boolean)this.isMapType(mapType), (String)"Invalid map: %s is not a map", (Object)mapType);
        return ((MapType)mapType).getKeyType();
    }

    protected LogicalType mapValueType(LogicalType mapType) {
        Preconditions.checkArgument((boolean)this.isMapType(mapType), (String)"Invalid map: %s is not a map", (Object)mapType);
        return ((MapType)mapType).getValueType();
    }

    protected Pair<String, LogicalType> fieldNameAndType(LogicalType structType, int pos) {
        Preconditions.checkArgument((boolean)(structType instanceof RowType), (String)"Invalid struct: %s is not a struct", (Object)structType);
        RowType.RowField field = (RowType.RowField)((RowType)structType).getFields().get(pos);
        return Pair.of((Object)field.getName(), (Object)field.getType());
    }

    protected LogicalType nullType() {
        return new NullType();
    }
}

