/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.transforms.PartitionSpecVisitor;

final class BucketPartitionerUtil {
    static final String BAD_NUMBER_OF_BUCKETS_ERROR_MESSAGE = "Invalid number of buckets: %s (must be 1)";

    private BucketPartitionerUtil() {
    }

    static boolean hasOneBucketField(PartitionSpec partitionSpec) {
        List<Tuple2<Integer, Integer>> bucketFields = BucketPartitionerUtil.getBucketFields(partitionSpec);
        return bucketFields != null && bucketFields.size() == 1;
    }

    private static Tuple2<Integer, Integer> getBucketFieldInfo(PartitionSpec partitionSpec) {
        List<Tuple2<Integer, Integer>> bucketFields = BucketPartitionerUtil.getBucketFields(partitionSpec);
        Preconditions.checkArgument((bucketFields.size() == 1 ? 1 : 0) != 0, (String)BAD_NUMBER_OF_BUCKETS_ERROR_MESSAGE, (int)bucketFields.size());
        return bucketFields.get(0);
    }

    static int getBucketFieldId(PartitionSpec partitionSpec) {
        return (Integer)BucketPartitionerUtil.getBucketFieldInfo((PartitionSpec)partitionSpec).f0;
    }

    static int getMaxNumBuckets(PartitionSpec partitionSpec) {
        return (Integer)BucketPartitionerUtil.getBucketFieldInfo((PartitionSpec)partitionSpec).f1;
    }

    private static List<Tuple2<Integer, Integer>> getBucketFields(PartitionSpec spec) {
        return PartitionSpecVisitor.visit((PartitionSpec)spec, (PartitionSpecVisitor)new BucketPartitionSpecVisitor()).stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static class BucketPartitionSpecVisitor
    implements PartitionSpecVisitor<Tuple2<Integer, Integer>> {
        private BucketPartitionSpecVisitor() {
        }

        public Tuple2<Integer, Integer> identity(int fieldId, String sourceName, int sourceId) {
            return null;
        }

        public Tuple2<Integer, Integer> bucket(int fieldId, String sourceName, int sourceId, int numBuckets) {
            return new Tuple2((Object)fieldId, (Object)numBuckets);
        }

        public Tuple2<Integer, Integer> truncate(int fieldId, String sourceName, int sourceId, int width) {
            return null;
        }

        public Tuple2<Integer, Integer> year(int fieldId, String sourceName, int sourceId) {
            return null;
        }

        public Tuple2<Integer, Integer> month(int fieldId, String sourceName, int sourceId) {
            return null;
        }

        public Tuple2<Integer, Integer> day(int fieldId, String sourceName, int sourceId) {
            return null;
        }

        public Tuple2<Integer, Integer> hour(int fieldId, String sourceName, int sourceId) {
            return null;
        }

        public Tuple2<Integer, Integer> alwaysNull(int fieldId, String sourceName, int sourceId) {
            return null;
        }

        public Tuple2<Integer, Integer> unknown(int fieldId, String sourceName, int sourceId, String transform) {
            return null;
        }
    }
}

