/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.util;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;

public class FlinkPackage {
    private static final AtomicReference<String> VERSION = new AtomicReference();
    public static final String FLINK_UNKNOWN_VERSION = "FLINK-UNKNOWN-VERSION";

    private FlinkPackage() {
    }

    public static String version() {
        if (null == VERSION.get()) {
            String detectedVersion = null;
            try {
                detectedVersion = FlinkPackage.versionFromJar();
                detectedVersion = detectedVersion != null ? detectedVersion : FLINK_UNKNOWN_VERSION;
            }
            catch (Exception e) {
                detectedVersion = FLINK_UNKNOWN_VERSION;
            }
            VERSION.set(detectedVersion);
        }
        return VERSION.get();
    }

    @VisibleForTesting
    static String versionFromJar() {
        return DataStream.class.getPackage().getImplementationVersion();
    }

    @VisibleForTesting
    static void setVersion(String version) {
        VERSION.set(version);
    }
}

