/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.reader;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.source.SourceEvent;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.connector.base.source.reader.SingleThreadMultiplexSourceReaderBase;
import org.apache.iceberg.flink.source.reader.IcebergSourceReaderMetrics;
import org.apache.iceberg.flink.source.reader.IcebergSourceSplitReader;
import org.apache.iceberg.flink.source.reader.ReaderFunction;
import org.apache.iceberg.flink.source.reader.RecordAndPosition;
import org.apache.iceberg.flink.source.reader.SerializableRecordEmitter;
import org.apache.iceberg.flink.source.split.IcebergSourceSplit;
import org.apache.iceberg.flink.source.split.SerializableComparator;
import org.apache.iceberg.flink.source.split.SplitRequestEvent;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

@Internal
public class IcebergSourceReader<T>
extends SingleThreadMultiplexSourceReaderBase<RecordAndPosition<T>, T, IcebergSourceSplit, IcebergSourceSplit> {
    public IcebergSourceReader(SerializableRecordEmitter<T> emitter, IcebergSourceReaderMetrics metrics, ReaderFunction<T> readerFunction, SerializableComparator<IcebergSourceSplit> splitComparator, SourceReaderContext context) {
        super(() -> new IcebergSourceSplitReader(metrics, readerFunction, splitComparator, context), emitter, context.getConfiguration(), context);
    }

    public void start() {
        if (this.getNumberOfCurrentlyAssignedSplits() == 0) {
            this.requestSplit(Collections.emptyList());
        }
    }

    protected void onSplitFinished(Map<String, IcebergSourceSplit> finishedSplitIds) {
        this.requestSplit(Lists.newArrayList(finishedSplitIds.keySet()));
    }

    protected IcebergSourceSplit initializedState(IcebergSourceSplit split) {
        return split;
    }

    protected IcebergSourceSplit toSplitType(String splitId, IcebergSourceSplit splitState) {
        return splitState;
    }

    private void requestSplit(Collection<String> finishedSplitIds) {
        this.context.sendSourceEventToCoordinator((SourceEvent)new SplitRequestEvent(finishedSplitIds));
    }
}

