/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.reader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.base.source.reader.RecordsWithSplitIds;
import org.apache.iceberg.flink.FlinkConfigOptions;
import org.apache.iceberg.flink.source.DataIterator;
import org.apache.iceberg.flink.source.reader.DataIteratorBatcher;
import org.apache.iceberg.flink.source.reader.ListBatchRecords;
import org.apache.iceberg.flink.source.reader.RecordAndPosition;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

class ListDataIteratorBatcher<T>
implements DataIteratorBatcher<T> {
    private final int batchSize;

    ListDataIteratorBatcher(ReadableConfig config) {
        this.batchSize = (Integer)config.get(FlinkConfigOptions.SOURCE_READER_FETCH_BATCH_RECORD_COUNT);
    }

    @Override
    public CloseableIterator<RecordsWithSplitIds<RecordAndPosition<T>>> batch(String splitId, DataIterator<T> dataIterator) {
        return new ListBatchIterator(splitId, dataIterator);
    }

    private class ListBatchIterator
    implements CloseableIterator<RecordsWithSplitIds<RecordAndPosition<T>>> {
        private final String splitId;
        private final DataIterator<T> inputIterator;

        ListBatchIterator(String splitId, DataIterator<T> inputIterator) {
            this.splitId = splitId;
            this.inputIterator = inputIterator;
        }

        public boolean hasNext() {
            return this.inputIterator.hasNext();
        }

        public RecordsWithSplitIds<RecordAndPosition<T>> next() {
            int recordCount;
            if (!this.inputIterator.hasNext()) {
                throw new NoSuchElementException();
            }
            ArrayList batch = Lists.newArrayListWithCapacity((int)ListDataIteratorBatcher.this.batchSize);
            for (recordCount = 0; this.inputIterator.hasNext() && recordCount < ListDataIteratorBatcher.this.batchSize; ++recordCount) {
                Object nextRecord = this.inputIterator.next();
                batch.add(nextRecord);
                if (this.inputIterator.currentFileHasNext()) continue;
                break;
            }
            return ListBatchRecords.forRecords(this.splitId, batch, this.inputIterator.fileOffset(), this.inputIterator.recordOffset() - (long)recordCount);
        }

        public void close() throws IOException {
            if (this.inputIterator != null) {
                this.inputIterator.close();
            }
        }
    }
}

