/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import com.fasterxml.jackson.databind.node.IntNode;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.flink.DataGenerator;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;

public class DataGenerators {

    public static class MapOfStructStruct
    implements DataGenerator {
        private final Schema icebergSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"row_id", (Type)Types.StringType.get()), Types.NestedField.optional((int)2, (String)"map", (Type)Types.MapType.ofOptional((int)101, (int)102, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)201, (String)"key", (Type)Types.LongType.get()), Types.NestedField.optional((int)202, (String)"keyData", (Type)Types.StringType.get())}), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)203, (String)"value", (Type)Types.LongType.get()), Types.NestedField.optional((int)204, (String)"valueData", (Type)Types.StringType.get())})))});
        private final RowType flinkRowType = FlinkSchemaUtil.convert((Schema)this.icebergSchema);

        @Override
        public Schema icebergSchema() {
            return this.icebergSchema;
        }

        @Override
        public RowType flinkRowType() {
            return this.flinkRowType;
        }

        @Override
        public org.apache.avro.Schema avroSchema() {
            throw new UnsupportedOperationException("Not applicable as Avro Map only support string key type");
        }

        @Override
        public org.apache.iceberg.data.GenericRecord generateIcebergGenericRecord() {
            throw new UnsupportedOperationException("Not implemented yet");
        }

        @Override
        public GenericRowData generateFlinkRowData() {
            return GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"row_id_value"), new GenericMapData((Map)ImmutableMap.of((Object)GenericRowData.of((Object[])new Object[]{1L, StringData.fromString((String)"key_data")}), (Object)GenericRowData.of((Object[])new Object[]{1L, StringData.fromString((String)"value_data")})))});
        }

        @Override
        public GenericRecord generateAvroGenericRecord() {
            throw new UnsupportedOperationException("Avro Map only support string key type");
        }
    }

    public static class MapOfStruct
    implements DataGenerator {
        private final Types.StructType structType = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)201, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)202, (String)"name", (Type)Types.StringType.get())});
        private final Schema structIcebergSchema = new Schema(this.structType.fields());
        private final org.apache.avro.Schema structAvroSchema = (org.apache.avro.Schema)SchemaBuilder.builder().record("struct").fields().name("id").type(this.createAvroSchemaIdField()).noDefault().name("name").type(this.createAvroSchemaNameField()).noDefault().endRecord();
        private final Schema icebergSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"row_id", (Type)Types.StringType.get()), Types.NestedField.required((int)2, (String)"map_of_struct", (Type)Types.MapType.ofRequired((int)101, (int)102, (Type)Types.StringType.get(), (Type)this.structType))});
        private final RowType flinkRowType = FlinkSchemaUtil.convert((Schema)this.icebergSchema);
        org.apache.avro.Schema avroSchema = (org.apache.avro.Schema)SchemaBuilder.builder().record("table").fields().requiredString("row_id").name("map_of_struct").type((org.apache.avro.Schema)SchemaBuilder.builder().map().values(this.structAvroSchema)).noDefault().endRecord();

        private org.apache.avro.Schema createAvroSchemaIdField() {
            org.apache.avro.Schema schema = (org.apache.avro.Schema)SchemaBuilder.builder().intType();
            schema.addProp("field-id", (Object)IntNode.valueOf((int)201));
            return schema;
        }

        private org.apache.avro.Schema createAvroSchemaNameField() {
            org.apache.avro.Schema schema = (org.apache.avro.Schema)SchemaBuilder.builder().stringType();
            schema.addProp("field-id", (Object)IntNode.valueOf((int)202));
            return schema;
        }

        @Override
        public Schema icebergSchema() {
            return this.icebergSchema;
        }

        @Override
        public RowType flinkRowType() {
            return this.flinkRowType;
        }

        @Override
        public org.apache.avro.Schema avroSchema() {
            return this.avroSchema;
        }

        @Override
        public org.apache.iceberg.data.GenericRecord generateIcebergGenericRecord() {
            org.apache.iceberg.data.GenericRecord struct1 = org.apache.iceberg.data.GenericRecord.create((Schema)this.structIcebergSchema);
            struct1.setField("id", (Object)1);
            struct1.setField("name", (Object)"Jane");
            org.apache.iceberg.data.GenericRecord struct2 = org.apache.iceberg.data.GenericRecord.create((Schema)this.structIcebergSchema);
            struct2.setField("id", (Object)2);
            struct2.setField("name", (Object)"Joe");
            org.apache.iceberg.data.GenericRecord genericRecord = org.apache.iceberg.data.GenericRecord.create((Schema)this.icebergSchema);
            genericRecord.setField("row_id", (Object)"row_id_value");
            genericRecord.setField("map_of_struct", (Object)ImmutableMap.of((Object)"struct1", (Object)struct1, (Object)"struct2", (Object)struct2));
            return genericRecord;
        }

        @Override
        public GenericRowData generateFlinkRowData() {
            return GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"row_id_value"), new GenericMapData((Map)ImmutableMap.of((Object)StringData.fromString((String)"struct1"), (Object)GenericRowData.of((Object[])new Object[]{1, StringData.fromString((String)"Jane")}), (Object)StringData.fromString((String)"struct2"), (Object)GenericRowData.of((Object[])new Object[]{2, StringData.fromString((String)"Joe")})))});
        }

        @Override
        public GenericRecord generateAvroGenericRecord() {
            GenericData.Record struct1 = new GenericData.Record(this.structAvroSchema);
            struct1.put("id", (Object)1);
            struct1.put("name", (Object)new Utf8("Jane"));
            GenericData.Record struct2 = new GenericData.Record(this.structAvroSchema);
            struct2.put("id", (Object)2);
            struct2.put("name", (Object)new Utf8("Joe"));
            GenericData.Record genericRecord = new GenericData.Record(this.avroSchema);
            genericRecord.put("row_id", (Object)new Utf8("row_id_value"));
            genericRecord.put("map_of_struct", (Object)ImmutableMap.of((Object)"struct1", (Object)struct1, (Object)"struct2", (Object)struct2));
            return genericRecord;
        }
    }

    public static class MapOfMap
    implements DataGenerator {
        private final Schema icebergSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"row_id", (Type)Types.StringType.get()), Types.NestedField.required((int)2, (String)"map_of_map", (Type)Types.MapType.ofRequired((int)101, (int)102, (Type)Types.StringType.get(), (Type)Types.MapType.ofRequired((int)301, (int)302, (Type)Types.StringType.get(), (Type)Types.IntegerType.get())))});
        private final RowType flinkRowType = FlinkSchemaUtil.convert((Schema)this.icebergSchema);
        private final org.apache.avro.Schema avroSchema = AvroSchemaUtil.convert((Schema)this.icebergSchema, (String)"table");

        @Override
        public Schema icebergSchema() {
            return this.icebergSchema;
        }

        @Override
        public RowType flinkRowType() {
            return this.flinkRowType;
        }

        @Override
        public org.apache.avro.Schema avroSchema() {
            return this.avroSchema;
        }

        @Override
        public org.apache.iceberg.data.GenericRecord generateIcebergGenericRecord() {
            org.apache.iceberg.data.GenericRecord genericRecord = org.apache.iceberg.data.GenericRecord.create((Schema)this.icebergSchema);
            genericRecord.setField("row_id", (Object)"row_id_value");
            genericRecord.setField("map_of_map", (Object)ImmutableMap.of((Object)"female", (Object)ImmutableMap.of((Object)"Jane", (Object)1, (Object)"Alice", (Object)2), (Object)"male", (Object)ImmutableMap.of((Object)"Joe", (Object)3, (Object)"Bob", (Object)4)));
            return genericRecord;
        }

        @Override
        public GenericRowData generateFlinkRowData() {
            return GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"row_id_value"), new GenericMapData((Map)ImmutableMap.of((Object)StringData.fromString((String)"female"), (Object)new GenericMapData((Map)ImmutableMap.of((Object)StringData.fromString((String)"Jane"), (Object)1, (Object)StringData.fromString((String)"Alice"), (Object)2)), (Object)StringData.fromString((String)"male"), (Object)new GenericMapData((Map)ImmutableMap.of((Object)StringData.fromString((String)"Joe"), (Object)3, (Object)StringData.fromString((String)"Bob"), (Object)4))))});
        }

        @Override
        public GenericRecord generateAvroGenericRecord() {
            GenericData.Record genericRecord = new GenericData.Record(this.avroSchema);
            genericRecord.put("row_id", (Object)"row_id_value");
            genericRecord.put("map_of_map", (Object)ImmutableMap.of((Object)"female", (Object)ImmutableMap.of((Object)"Jane", (Object)1, (Object)"Alice", (Object)2), (Object)"male", (Object)ImmutableMap.of((Object)"Joe", (Object)3, (Object)"Bob", (Object)4)));
            return genericRecord;
        }
    }

    public static class MapOfArray
    implements DataGenerator {
        private final Schema icebergSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"row_id", (Type)Types.StringType.get()), Types.NestedField.required((int)2, (String)"map_of_array", (Type)Types.MapType.ofRequired((int)101, (int)102, (Type)Types.StringType.get(), (Type)Types.ListType.ofRequired((int)201, (Type)Types.IntegerType.get())))});
        private final RowType rowType = FlinkSchemaUtil.convert((Schema)this.icebergSchema);
        private final org.apache.avro.Schema avroSchema = AvroSchemaUtil.convert((Schema)this.icebergSchema, (String)"table");

        @Override
        public Schema icebergSchema() {
            return this.icebergSchema;
        }

        @Override
        public RowType flinkRowType() {
            return this.rowType;
        }

        @Override
        public org.apache.avro.Schema avroSchema() {
            return this.avroSchema;
        }

        @Override
        public org.apache.iceberg.data.GenericRecord generateIcebergGenericRecord() {
            org.apache.iceberg.data.GenericRecord genericRecord = org.apache.iceberg.data.GenericRecord.create((Schema)this.icebergSchema);
            genericRecord.setField("row_id", (Object)"row_id_value");
            genericRecord.setField("map_of_array", (Object)ImmutableMap.of((Object)"Jane", Arrays.asList(1, 2, 3), (Object)"Joe", Arrays.asList(4, 5, 6)));
            return genericRecord;
        }

        @Override
        public GenericRowData generateFlinkRowData() {
            Object[] janeArray = new Integer[]{1, 2, 3};
            Object[] joeArray = new Integer[]{4, 5, 6};
            return GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"row_id_value"), new GenericMapData((Map)ImmutableMap.of((Object)StringData.fromString((String)"Jane"), (Object)new GenericArrayData(janeArray), (Object)StringData.fromString((String)"Joe"), (Object)new GenericArrayData(joeArray)))});
        }

        @Override
        public GenericRecord generateAvroGenericRecord() {
            GenericData.Record genericRecord = new GenericData.Record(this.avroSchema);
            genericRecord.put("row_id", (Object)"row_id_value");
            genericRecord.put("map_of_array", (Object)ImmutableMap.of((Object)"Jane", Arrays.asList(1, 2, 3), (Object)"Joe", Arrays.asList(4, 5, 6)));
            return genericRecord;
        }
    }

    public static class MapOfPrimitives
    implements DataGenerator {
        private final Schema icebergSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"row_id", (Type)Types.StringType.get()), Types.NestedField.optional((int)2, (String)"map_of_primitives", (Type)Types.MapType.ofRequired((int)101, (int)102, (Type)Types.StringType.get(), (Type)Types.IntegerType.get()))});
        private final RowType flinkRowType = FlinkSchemaUtil.convert((Schema)this.icebergSchema);
        private final org.apache.avro.Schema avroSchema = AvroSchemaUtil.convert((Schema)this.icebergSchema, (String)"table");

        @Override
        public Schema icebergSchema() {
            return this.icebergSchema;
        }

        @Override
        public RowType flinkRowType() {
            return this.flinkRowType;
        }

        @Override
        public org.apache.avro.Schema avroSchema() {
            return this.avroSchema;
        }

        @Override
        public org.apache.iceberg.data.GenericRecord generateIcebergGenericRecord() {
            org.apache.iceberg.data.GenericRecord genericRecord = org.apache.iceberg.data.GenericRecord.create((Schema)this.icebergSchema);
            genericRecord.setField("row_id", (Object)"row_id_value");
            genericRecord.setField("map_of_primitives", (Object)ImmutableMap.of((Object)"Jane", (Object)1, (Object)"Joe", (Object)2));
            return genericRecord;
        }

        @Override
        public GenericRowData generateFlinkRowData() {
            return GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"row_id_value"), new GenericMapData((Map)ImmutableMap.of((Object)StringData.fromString((String)"Jane"), (Object)1, (Object)StringData.fromString((String)"Joe"), (Object)2))});
        }

        @Override
        public GenericRecord generateAvroGenericRecord() {
            GenericData.Record genericRecord = new GenericData.Record(this.avroSchema);
            genericRecord.put("row_id", (Object)"row_id_value");
            genericRecord.put("map_of_primitives", (Object)ImmutableMap.of((Object)"Jane", (Object)1, (Object)"Joe", (Object)2));
            return genericRecord;
        }
    }

    public static class ArrayOfStruct
    implements DataGenerator {
        private final Types.StructType structType = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)201, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)202, (String)"name", (Type)Types.StringType.get())});
        private final Schema structIcebergSchema = new Schema(this.structType.fields());
        private final org.apache.avro.Schema structAvroSchema = AvroSchemaUtil.convert((Schema)this.structIcebergSchema, (String)"struct");
        private final Schema icebergSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"row_id", (Type)Types.StringType.get()), Types.NestedField.optional((int)2, (String)"array_of_struct", (Type)Types.ListType.ofRequired((int)101, (Type)this.structType))});
        private final RowType flinkRowType = FlinkSchemaUtil.convert((Schema)this.icebergSchema);
        private final org.apache.avro.Schema avroSchema = AvroSchemaUtil.convert((Schema)this.icebergSchema, (String)"table");

        @Override
        public Schema icebergSchema() {
            return this.icebergSchema;
        }

        @Override
        public RowType flinkRowType() {
            return this.flinkRowType;
        }

        @Override
        public org.apache.avro.Schema avroSchema() {
            return this.avroSchema;
        }

        @Override
        public org.apache.iceberg.data.GenericRecord generateIcebergGenericRecord() {
            org.apache.iceberg.data.GenericRecord struct1 = org.apache.iceberg.data.GenericRecord.create((Schema)this.structIcebergSchema);
            struct1.setField("id", (Object)1);
            struct1.setField("name", (Object)"Jane");
            org.apache.iceberg.data.GenericRecord struct2 = org.apache.iceberg.data.GenericRecord.create((Schema)this.structIcebergSchema);
            struct2.setField("id", (Object)2);
            struct2.setField("name", (Object)"Joe");
            org.apache.iceberg.data.GenericRecord genericRecord = org.apache.iceberg.data.GenericRecord.create((Schema)this.icebergSchema);
            genericRecord.setField("row_id", (Object)"row_id_value");
            genericRecord.setField("array_of_struct", Arrays.asList(struct1, struct2));
            return genericRecord;
        }

        @Override
        public GenericRowData generateFlinkRowData() {
            Object[] structArray = new GenericRowData[]{GenericRowData.of((Object[])new Object[]{1, StringData.fromString((String)"Jane")}), GenericRowData.of((Object[])new Object[]{2, StringData.fromString((String)"Joe")})};
            return GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"row_id_value"), new GenericArrayData(structArray)});
        }

        @Override
        public GenericRecord generateAvroGenericRecord() {
            GenericData.Record struct1 = new GenericData.Record(this.structAvroSchema);
            struct1.put("id", (Object)1);
            struct1.put("name", (Object)"Jane");
            GenericData.Record struct2 = new GenericData.Record(this.structAvroSchema);
            struct2.put("id", (Object)2);
            struct2.put("name", (Object)"Joe");
            GenericData.Record genericRecord = new GenericData.Record(this.avroSchema);
            genericRecord.put("row_id", (Object)"row_id_value");
            genericRecord.put("array_of_struct", Arrays.asList(struct1, struct2));
            return genericRecord;
        }
    }

    public static class ArrayOfMap
    implements DataGenerator {
        private final Schema icebergSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"row_id", (Type)Types.StringType.get()), Types.NestedField.required((int)2, (String)"array_of_map", (Type)Types.ListType.ofRequired((int)101, (Type)Types.MapType.ofRequired((int)201, (int)202, (Type)Types.StringType.get(), (Type)Types.IntegerType.get())))});
        private final RowType flinkRowType = FlinkSchemaUtil.convert((Schema)this.icebergSchema);
        private final org.apache.avro.Schema avroSchema = AvroSchemaUtil.convert((Schema)this.icebergSchema, (String)"table");

        @Override
        public Schema icebergSchema() {
            return this.icebergSchema;
        }

        @Override
        public RowType flinkRowType() {
            return this.flinkRowType;
        }

        @Override
        public org.apache.avro.Schema avroSchema() {
            return this.avroSchema;
        }

        @Override
        public org.apache.iceberg.data.GenericRecord generateIcebergGenericRecord() {
            org.apache.iceberg.data.GenericRecord genericRecord = org.apache.iceberg.data.GenericRecord.create((Schema)this.icebergSchema);
            genericRecord.setField("row_id", (Object)"row_id_value");
            genericRecord.setField("array_of_map", Arrays.asList(ImmutableMap.of((Object)"Jane", (Object)1, (Object)"Joe", (Object)2), ImmutableMap.of((Object)"Alice", (Object)3, (Object)"Bob", (Object)4)));
            return genericRecord;
        }

        @Override
        public GenericRowData generateFlinkRowData() {
            Object[] array = new GenericMapData[]{new GenericMapData((Map)ImmutableMap.of((Object)StringData.fromString((String)"Jane"), (Object)1, (Object)StringData.fromString((String)"Joe"), (Object)2)), new GenericMapData((Map)ImmutableMap.of((Object)StringData.fromString((String)"Alice"), (Object)3, (Object)StringData.fromString((String)"Bob"), (Object)4))};
            return GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"row_id_value"), new GenericArrayData(array)});
        }

        @Override
        public GenericRecord generateAvroGenericRecord() {
            GenericData.Record genericRecord = new GenericData.Record(this.avroSchema);
            genericRecord.put("row_id", (Object)"row_id_value");
            genericRecord.put("array_of_map", Arrays.asList(ImmutableMap.of((Object)"Jane", (Object)1, (Object)"Joe", (Object)2), ImmutableMap.of((Object)"Alice", (Object)3, (Object)"Bob", (Object)4)));
            return genericRecord;
        }
    }

    public static class ArrayOfArray
    implements DataGenerator {
        private final Schema icebergSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"row_id", (Type)Types.StringType.get()), Types.NestedField.required((int)2, (String)"array_of_array", (Type)Types.ListType.ofRequired((int)101, (Type)Types.ListType.ofRequired((int)201, (Type)Types.IntegerType.get())))});
        private final RowType flinkRowType = FlinkSchemaUtil.convert((Schema)this.icebergSchema);
        private final org.apache.avro.Schema avroSchema = AvroSchemaUtil.convert((Schema)this.icebergSchema, (String)"table");

        @Override
        public Schema icebergSchema() {
            return this.icebergSchema;
        }

        @Override
        public RowType flinkRowType() {
            return this.flinkRowType;
        }

        @Override
        public org.apache.avro.Schema avroSchema() {
            return this.avroSchema;
        }

        @Override
        public org.apache.iceberg.data.GenericRecord generateIcebergGenericRecord() {
            org.apache.iceberg.data.GenericRecord genericRecord = org.apache.iceberg.data.GenericRecord.create((Schema)this.icebergSchema);
            genericRecord.setField("row_id", (Object)"row_id_value");
            genericRecord.setField("array_of_array", Arrays.asList(Arrays.asList(1, 2, 3), Arrays.asList(4, 5, 6)));
            return genericRecord;
        }

        @Override
        public GenericRowData generateFlinkRowData() {
            Object[] array1 = new Integer[]{1, 2, 3};
            Object[] array2 = new Integer[]{4, 5, 6};
            Object[] arrayOfArrays = new GenericArrayData[]{new GenericArrayData(array1), new GenericArrayData(array2)};
            return GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"row_id_value"), new GenericArrayData(arrayOfArrays)});
        }

        @Override
        public GenericRecord generateAvroGenericRecord() {
            GenericData.Record genericRecord = new GenericData.Record(this.avroSchema);
            genericRecord.put("row_id", (Object)"row_id_value");
            genericRecord.put("array_of_array", Arrays.asList(Arrays.asList(1, 2, 3), Arrays.asList(4, 5, 6)));
            return genericRecord;
        }
    }

    public static class ArrayOfPrimitive
    implements DataGenerator {
        private final Schema icebergSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"row_id", (Type)Types.StringType.get()), Types.NestedField.required((int)2, (String)"array_of_int", (Type)Types.ListType.ofOptional((int)101, (Type)Types.IntegerType.get()))});
        private final RowType flinkRowType = FlinkSchemaUtil.convert((Schema)this.icebergSchema);
        private final org.apache.avro.Schema avroSchema = AvroSchemaUtil.convert((Schema)this.icebergSchema, (String)"table");

        @Override
        public Schema icebergSchema() {
            return this.icebergSchema;
        }

        @Override
        public RowType flinkRowType() {
            return this.flinkRowType;
        }

        @Override
        public org.apache.avro.Schema avroSchema() {
            return this.avroSchema;
        }

        @Override
        public org.apache.iceberg.data.GenericRecord generateIcebergGenericRecord() {
            org.apache.iceberg.data.GenericRecord genericRecord = org.apache.iceberg.data.GenericRecord.create((Schema)this.icebergSchema);
            genericRecord.setField("row_id", (Object)"row_id_value");
            genericRecord.setField("array_of_int", Arrays.asList(1, 2, 3));
            return genericRecord;
        }

        @Override
        public GenericRowData generateFlinkRowData() {
            Object[] arr = new Integer[]{1, 2, 3};
            return GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"row_id_value"), new GenericArrayData(arr)});
        }

        @Override
        public GenericRecord generateAvroGenericRecord() {
            GenericData.Record genericRecord = new GenericData.Record(this.avroSchema);
            genericRecord.put("row_id", (Object)"row_id_value");
            genericRecord.put("array_of_int", Arrays.asList(1, 2, 3));
            return genericRecord;
        }
    }

    public static class StructOfStruct
    implements DataGenerator {
        private final Schema icebergSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"row_id", (Type)Types.StringType.get()), Types.NestedField.required((int)2, (String)"struct_of_struct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)101, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)102, (String)"person_struct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)201, (String)"name", (Type)Types.StringType.get()), Types.NestedField.required((int)202, (String)"address", (Type)Types.StringType.get())}))}))});
        private final RowType flinkRowType = FlinkSchemaUtil.convert((Schema)this.icebergSchema);
        private final org.apache.avro.Schema avroSchema = AvroSchemaUtil.convert((Schema)this.icebergSchema, (String)"table");

        @Override
        public Schema icebergSchema() {
            return this.icebergSchema;
        }

        @Override
        public RowType flinkRowType() {
            return this.flinkRowType;
        }

        @Override
        public org.apache.avro.Schema avroSchema() {
            return this.avroSchema;
        }

        @Override
        public org.apache.iceberg.data.GenericRecord generateIcebergGenericRecord() {
            Schema structSchema = new Schema(this.icebergSchema.findField("struct_of_struct").type().asStructType().fields());
            Schema personSchema = new Schema(structSchema.findField("person_struct").type().asStructType().fields());
            org.apache.iceberg.data.GenericRecord person = org.apache.iceberg.data.GenericRecord.create((Schema)personSchema);
            person.setField("name", (Object)"Jane");
            person.setField("address", (Object)"Apple Park");
            org.apache.iceberg.data.GenericRecord struct = org.apache.iceberg.data.GenericRecord.create((Schema)structSchema);
            struct.setField("id", (Object)1);
            struct.setField("person_struct", (Object)person);
            org.apache.iceberg.data.GenericRecord genericRecord = org.apache.iceberg.data.GenericRecord.create((Schema)this.icebergSchema);
            genericRecord.setField("row_id", (Object)"row_id_value");
            genericRecord.setField("struct_of_struct", (Object)struct);
            return genericRecord;
        }

        @Override
        public GenericRowData generateFlinkRowData() {
            return GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"row_id_value"), GenericRowData.of((Object[])new Object[]{1, GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"Jane"), StringData.fromString((String)"Apple Park")})})});
        }

        @Override
        public GenericRecord generateAvroGenericRecord() {
            org.apache.avro.Schema structSchema = this.avroSchema.getField("struct_of_struct").schema();
            org.apache.avro.Schema personSchema = structSchema.getField("person_struct").schema();
            GenericData.Record person = new GenericData.Record(personSchema);
            person.put("name", (Object)"Jane");
            person.put("address", (Object)"Apple Park");
            GenericData.Record struct = new GenericData.Record(structSchema);
            struct.put("id", (Object)1);
            struct.put("person_struct", (Object)person);
            GenericData.Record genericRecord = new GenericData.Record(this.avroSchema);
            genericRecord.put("row_id", (Object)"row_id_value");
            genericRecord.put("struct_of_struct", (Object)struct);
            return genericRecord;
        }
    }

    public static class StructOfMap
    implements DataGenerator {
        private final Schema icebergSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"row_id", (Type)Types.StringType.get()), Types.NestedField.required((int)2, (String)"struct_of_map", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)101, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)102, (String)"names", (Type)Types.MapType.ofRequired((int)201, (int)202, (Type)Types.StringType.get(), (Type)Types.StringType.get()))}))});
        private final RowType flinkRowType = FlinkSchemaUtil.convert((Schema)this.icebergSchema);
        private final org.apache.avro.Schema avroSchema = AvroSchemaUtil.convert((Schema)this.icebergSchema, (String)"table");

        @Override
        public Schema icebergSchema() {
            return this.icebergSchema;
        }

        @Override
        public RowType flinkRowType() {
            return this.flinkRowType;
        }

        @Override
        public org.apache.avro.Schema avroSchema() {
            return this.avroSchema;
        }

        @Override
        public org.apache.iceberg.data.GenericRecord generateIcebergGenericRecord() {
            Schema structSchema = new Schema(this.icebergSchema.findField("struct_of_map").type().asStructType().fields());
            org.apache.iceberg.data.GenericRecord struct = org.apache.iceberg.data.GenericRecord.create((Schema)structSchema);
            struct.setField("id", (Object)1);
            struct.setField("names", (Object)ImmutableMap.of((Object)"Jane", (Object)"female", (Object)"Joe", (Object)"male"));
            org.apache.iceberg.data.GenericRecord genericRecord = org.apache.iceberg.data.GenericRecord.create((Schema)this.icebergSchema);
            genericRecord.setField("row_id", (Object)"row_id_value");
            genericRecord.setField("struct_of_map", (Object)struct);
            return genericRecord;
        }

        @Override
        public GenericRowData generateFlinkRowData() {
            return GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"row_id_value"), GenericRowData.of((Object[])new Object[]{1, new GenericMapData((Map)ImmutableMap.of((Object)StringData.fromString((String)"Jane"), (Object)StringData.fromString((String)"female"), (Object)StringData.fromString((String)"Joe"), (Object)StringData.fromString((String)"male")))})});
        }

        @Override
        public GenericRecord generateAvroGenericRecord() {
            org.apache.avro.Schema structSchema = this.avroSchema.getField("struct_of_map").schema();
            GenericData.Record struct = new GenericData.Record(structSchema);
            struct.put("id", (Object)1);
            struct.put("names", (Object)ImmutableMap.of((Object)"Jane", (Object)new Utf8("female"), (Object)"Joe", (Object)new Utf8("male")));
            GenericData.Record genericRecord = new GenericData.Record(this.avroSchema);
            genericRecord.put("row_id", (Object)"row_id_value");
            genericRecord.put("struct_of_map", (Object)struct);
            return genericRecord;
        }
    }

    public static class StructOfArray
    implements DataGenerator {
        private final Schema icebergSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"row_id", (Type)Types.StringType.get()), Types.NestedField.required((int)2, (String)"struct_of_array", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)101, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)102, (String)"names", (Type)Types.ListType.ofRequired((int)201, (Type)Types.StringType.get()))}))});
        private final RowType flinkRowType = FlinkSchemaUtil.convert((Schema)this.icebergSchema);
        private final org.apache.avro.Schema avroSchema = AvroSchemaUtil.convert((Schema)this.icebergSchema, (String)"table");

        @Override
        public Schema icebergSchema() {
            return this.icebergSchema;
        }

        @Override
        public RowType flinkRowType() {
            return this.flinkRowType;
        }

        @Override
        public org.apache.avro.Schema avroSchema() {
            return this.avroSchema;
        }

        @Override
        public org.apache.iceberg.data.GenericRecord generateIcebergGenericRecord() {
            Schema structSchema = new Schema(this.icebergSchema.findField("struct_of_array").type().asStructType().fields());
            org.apache.iceberg.data.GenericRecord struct = org.apache.iceberg.data.GenericRecord.create((Schema)structSchema);
            struct.setField("id", (Object)1);
            struct.setField("names", Arrays.asList("Jane", "Joe"));
            org.apache.iceberg.data.GenericRecord genericRecord = org.apache.iceberg.data.GenericRecord.create((Schema)this.icebergSchema);
            genericRecord.setField("row_id", (Object)"row_id_value");
            genericRecord.setField("struct_of_array", (Object)struct);
            return genericRecord;
        }

        @Override
        public GenericRowData generateFlinkRowData() {
            Object[] names = new StringData[]{StringData.fromString((String)"Jane"), StringData.fromString((String)"Joe")};
            return GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"row_id_value"), GenericRowData.of((Object[])new Object[]{1, new GenericArrayData(names)})});
        }

        @Override
        public GenericRecord generateAvroGenericRecord() {
            org.apache.avro.Schema structSchema = this.avroSchema.getField("struct_of_array").schema();
            GenericData.Record struct = new GenericData.Record(structSchema);
            struct.put("id", (Object)1);
            struct.put("names", Arrays.asList("Jane", "Joe"));
            GenericData.Record genericRecord = new GenericData.Record(this.avroSchema);
            genericRecord.put("row_id", (Object)"row_id_value");
            genericRecord.put("struct_of_array", (Object)struct);
            return genericRecord;
        }
    }

    public static class StructOfPrimitive
    implements DataGenerator {
        private final Schema icebergSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"row_id", (Type)Types.StringType.get()), Types.NestedField.required((int)2, (String)"struct_of_primitive", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)101, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)102, (String)"name", (Type)Types.StringType.get())}))});
        private final RowType flinkRowType = FlinkSchemaUtil.convert((Schema)this.icebergSchema);
        private final org.apache.avro.Schema avroSchema = AvroSchemaUtil.convert((Schema)this.icebergSchema, (String)"table");

        @Override
        public Schema icebergSchema() {
            return this.icebergSchema;
        }

        @Override
        public RowType flinkRowType() {
            return this.flinkRowType;
        }

        @Override
        public org.apache.avro.Schema avroSchema() {
            return this.avroSchema;
        }

        @Override
        public org.apache.iceberg.data.GenericRecord generateIcebergGenericRecord() {
            Schema structSchema = new Schema(this.icebergSchema.findField("struct_of_primitive").type().asStructType().fields());
            org.apache.iceberg.data.GenericRecord struct = org.apache.iceberg.data.GenericRecord.create((Schema)structSchema);
            struct.setField("id", (Object)1);
            struct.setField("name", (Object)"Jane");
            org.apache.iceberg.data.GenericRecord genericRecord = org.apache.iceberg.data.GenericRecord.create((Schema)this.icebergSchema);
            genericRecord.setField("row_id", (Object)"row_id_value");
            genericRecord.setField("struct_of_primitive", (Object)struct);
            return genericRecord;
        }

        @Override
        public GenericRowData generateFlinkRowData() {
            return GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"row_id_value"), GenericRowData.of((Object[])new Object[]{1, StringData.fromString((String)"Jane")})});
        }

        @Override
        public GenericRecord generateAvroGenericRecord() {
            org.apache.avro.Schema structSchema = this.avroSchema.getField("struct_of_primitive").schema();
            GenericData.Record struct = new GenericData.Record(structSchema);
            struct.put("id", (Object)1);
            struct.put("name", (Object)"Jane");
            GenericData.Record genericRecord = new GenericData.Record(this.avroSchema);
            genericRecord.put("row_id", (Object)"row_id_value");
            genericRecord.put("struct_of_primitive", (Object)struct);
            return genericRecord;
        }
    }

    public static class Primitives
    implements DataGenerator {
        private static final DateTime JODA_DATETIME_EPOC = new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC);
        private static final DateTime JODA_DATETIME_20220110 = new DateTime(2022, 1, 10, 0, 0, 0, 0, DateTimeZone.UTC);
        private static final int DAYS_BTW_EPOC_AND_20220110 = Days.daysBetween((ReadableInstant)JODA_DATETIME_EPOC, (ReadableInstant)JODA_DATETIME_20220110).getDays();
        private static final int HOUR_8_IN_MILLI = (int)TimeUnit.HOURS.toMillis(8L);
        private static final LocalDate JAVA_LOCAL_DATE_20220110 = LocalDate.of(2022, 1, 10);
        private static final LocalTime JAVA_LOCAL_TIME_HOUR8 = LocalTime.of(8, 0);
        private static final OffsetDateTime JAVA_OFFSET_DATE_TIME_20220110 = OffsetDateTime.of(2022, 1, 10, 0, 0, 0, 0, ZoneOffset.UTC);
        private static final LocalDateTime JAVA_LOCAL_DATE_TIME_20220110 = LocalDateTime.of(2022, 1, 10, 0, 0, 0);
        private static final BigDecimal BIG_DECIMAL_NEGATIVE = new BigDecimal("-1.50");
        private static final byte[] FIXED_BYTES = "012345689012345".getBytes(StandardCharsets.UTF_8);
        private final Schema icebergSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"row_id", (Type)Types.StringType.get()), Types.NestedField.optional((int)2, (String)"boolean_field", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)3, (String)"int_field", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)4, (String)"long_field", (Type)Types.LongType.get()), Types.NestedField.optional((int)5, (String)"float_field", (Type)Types.FloatType.get()), Types.NestedField.optional((int)6, (String)"double_field", (Type)Types.DoubleType.get()), Types.NestedField.required((int)7, (String)"string_field", (Type)Types.StringType.get()), Types.NestedField.required((int)8, (String)"date_field", (Type)Types.DateType.get()), Types.NestedField.required((int)9, (String)"time_field", (Type)Types.TimeType.get()), Types.NestedField.required((int)10, (String)"ts_with_zone_field", (Type)Types.TimestampType.withZone()), Types.NestedField.required((int)11, (String)"ts_without_zone_field", (Type)Types.TimestampType.withoutZone()), Types.NestedField.required((int)12, (String)"uuid_field", (Type)Types.UUIDType.get()), Types.NestedField.required((int)13, (String)"binary_field", (Type)Types.BinaryType.get()), Types.NestedField.required((int)14, (String)"decimal_field", (Type)Types.DecimalType.of((int)9, (int)2)), Types.NestedField.required((int)15, (String)"fixed_field", (Type)Types.FixedType.ofLength((int)16))});
        private final RowType flinkRowType = FlinkSchemaUtil.convert((Schema)this.icebergSchema);
        private final org.apache.avro.Schema avroSchema = this.fixupAvroSchemaConvertedFromIcebergSchema(AvroSchemaUtil.convert((Schema)this.icebergSchema, (String)"table"));

        private org.apache.avro.Schema fixupAvroSchemaConvertedFromIcebergSchema(org.apache.avro.Schema schemaConvertedFromIceberg) {
            List fixedFields = schemaConvertedFromIceberg.getFields().stream().map(field -> {
                Schema.Field updatedField = field;
                if (field.name().equals("time_field")) {
                    org.apache.avro.Schema fieldSchema = LogicalTypes.timeMillis().addToSchema(org.apache.avro.Schema.create((Schema.Type)Schema.Type.INT));
                    updatedField = new Schema.Field("time_field", fieldSchema);
                }
                return new Schema.Field(updatedField, updatedField.schema());
            }).collect(Collectors.toList());
            return org.apache.avro.Schema.createRecord((String)schemaConvertedFromIceberg.getName(), (String)schemaConvertedFromIceberg.getDoc(), (String)schemaConvertedFromIceberg.getNamespace(), (boolean)schemaConvertedFromIceberg.isError(), fixedFields);
        }

        @Override
        public Schema icebergSchema() {
            return this.icebergSchema;
        }

        @Override
        public RowType flinkRowType() {
            return this.flinkRowType;
        }

        @Override
        public org.apache.avro.Schema avroSchema() {
            return this.avroSchema;
        }

        @Override
        public org.apache.iceberg.data.GenericRecord generateIcebergGenericRecord() {
            org.apache.iceberg.data.GenericRecord genericRecord = org.apache.iceberg.data.GenericRecord.create((Schema)this.icebergSchema);
            genericRecord.setField("row_id", (Object)"row_id_value");
            genericRecord.setField("boolean_field", (Object)false);
            genericRecord.setField("int_field", (Object)Integer.MAX_VALUE);
            genericRecord.setField("long_field", (Object)Long.MAX_VALUE);
            genericRecord.setField("float_field", (Object)Float.valueOf(Float.MAX_VALUE));
            genericRecord.setField("double_field", (Object)Double.MAX_VALUE);
            genericRecord.setField("string_field", (Object)"str");
            genericRecord.setField("date_field", (Object)JAVA_LOCAL_DATE_20220110);
            genericRecord.setField("time_field", (Object)JAVA_LOCAL_TIME_HOUR8);
            genericRecord.setField("ts_with_zone_field", (Object)JAVA_OFFSET_DATE_TIME_20220110);
            genericRecord.setField("ts_without_zone_field", (Object)JAVA_LOCAL_DATE_TIME_20220110);
            byte[] uuidBytes = new byte[16];
            for (int i = 0; i < 16; ++i) {
                uuidBytes[i] = (byte)i;
            }
            genericRecord.setField("uuid_field", (Object)UUID.nameUUIDFromBytes(uuidBytes));
            byte[] binaryBytes = new byte[7];
            for (int i = 0; i < 7; ++i) {
                binaryBytes[i] = (byte)i;
            }
            genericRecord.setField("binary_field", (Object)ByteBuffer.wrap(binaryBytes));
            genericRecord.setField("decimal_field", (Object)BIG_DECIMAL_NEGATIVE);
            genericRecord.setField("fixed_field", (Object)FIXED_BYTES);
            return genericRecord;
        }

        @Override
        public GenericRowData generateFlinkRowData() {
            byte[] uuidBytes = new byte[16];
            for (int i = 0; i < 16; ++i) {
                uuidBytes[i] = (byte)i;
            }
            byte[] binaryBytes = new byte[7];
            for (int i = 0; i < 7; ++i) {
                binaryBytes[i] = (byte)i;
            }
            return GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"row_id_value"), false, Integer.MAX_VALUE, Long.MAX_VALUE, Float.valueOf(Float.MAX_VALUE), Double.MAX_VALUE, StringData.fromString((String)"str"), DAYS_BTW_EPOC_AND_20220110, HOUR_8_IN_MILLI, TimestampData.fromEpochMillis((long)JODA_DATETIME_20220110.getMillis()), TimestampData.fromEpochMillis((long)JODA_DATETIME_20220110.getMillis()), uuidBytes, binaryBytes, DecimalData.fromBigDecimal((BigDecimal)BIG_DECIMAL_NEGATIVE, (int)9, (int)2), FIXED_BYTES});
        }

        @Override
        public GenericRecord generateAvroGenericRecord() {
            GenericData.Record genericRecord = new GenericData.Record(this.avroSchema);
            genericRecord.put("row_id", (Object)new Utf8("row_id_value"));
            genericRecord.put("boolean_field", (Object)false);
            genericRecord.put("int_field", (Object)Integer.MAX_VALUE);
            genericRecord.put("long_field", (Object)Long.MAX_VALUE);
            genericRecord.put("float_field", (Object)Float.valueOf(Float.MAX_VALUE));
            genericRecord.put("double_field", (Object)Double.MAX_VALUE);
            genericRecord.put("string_field", (Object)new Utf8("str"));
            genericRecord.put("date_field", (Object)DAYS_BTW_EPOC_AND_20220110);
            genericRecord.put("time_field", (Object)HOUR_8_IN_MILLI);
            genericRecord.put("ts_with_zone_field", (Object)JODA_DATETIME_20220110.getMillis());
            genericRecord.put("ts_without_zone_field", (Object)JODA_DATETIME_20220110.getMillis());
            byte[] uuidBytes = new byte[16];
            for (int i = 0; i < 16; ++i) {
                uuidBytes[i] = (byte)i;
            }
            genericRecord.put("uuid_field", (Object)ByteBuffer.wrap(uuidBytes));
            byte[] binaryBytes = new byte[7];
            for (int i = 0; i < 7; ++i) {
                binaryBytes[i] = (byte)i;
            }
            genericRecord.put("binary_field", (Object)ByteBuffer.wrap(binaryBytes));
            BigDecimal bigDecimal = new BigDecimal("-1.50");
            genericRecord.put("decimal_field", (Object)ByteBuffer.wrap(bigDecimal.unscaledValue().toByteArray()));
            genericRecord.put("fixed_field", (Object)ByteBuffer.wrap(FIXED_BYTES));
            return genericRecord;
        }
    }
}

