/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.flink.util.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.flink.FlinkTestBase;
import org.apache.iceberg.hadoop.HadoopCatalog;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class FlinkCatalogTestBase
extends FlinkTestBase {
    protected static final String DATABASE = "db";
    private static TemporaryFolder hiveWarehouse = new TemporaryFolder();
    private static TemporaryFolder hadoopWarehouse = new TemporaryFolder();
    protected final String catalogName;
    protected final Namespace baseNamespace;
    protected final Catalog validationCatalog;
    protected final SupportsNamespaces validationNamespaceCatalog;
    protected final Map<String, String> config = Maps.newHashMap();
    protected final String flinkDatabase;
    protected final Namespace icebergNamespace;
    protected final boolean isHadoopCatalog;

    @BeforeClass
    public static void createWarehouse() throws IOException {
        hiveWarehouse.create();
        hadoopWarehouse.create();
    }

    @AfterClass
    public static void dropWarehouse() {
        hiveWarehouse.delete();
        hadoopWarehouse.delete();
    }

    @Before
    public void before() {
        this.sql("CREATE CATALOG %s WITH %s", this.catalogName, FlinkCatalogTestBase.toWithClause(this.config));
    }

    @After
    public void clean() {
        this.dropCatalog(this.catalogName, true);
    }

    @Parameterized.Parameters(name="catalogName = {0} baseNamespace = {1}")
    public static Iterable<Object[]> parameters() {
        return Lists.newArrayList((Object[])new Object[][]{{"testhive", Namespace.empty()}, {"testhadoop", Namespace.empty()}, {"testhadoop_basenamespace", Namespace.of((String[])new String[]{"l0", "l1"})}});
    }

    public FlinkCatalogTestBase(String catalogName, Namespace baseNamespace) {
        this.catalogName = catalogName;
        this.baseNamespace = baseNamespace;
        this.isHadoopCatalog = catalogName.startsWith("testhadoop");
        this.validationCatalog = this.isHadoopCatalog ? new HadoopCatalog((Configuration)hiveConf, "file:" + hadoopWarehouse.getRoot()) : catalog;
        this.validationNamespaceCatalog = (SupportsNamespaces)this.validationCatalog;
        this.config.put("type", "iceberg");
        if (!baseNamespace.isEmpty()) {
            this.config.put("base-namespace", baseNamespace.toString());
        }
        if (this.isHadoopCatalog) {
            this.config.put("catalog-type", "hadoop");
        } else {
            this.config.put("catalog-type", "hive");
            this.config.put("uri", FlinkCatalogTestBase.getURI(hiveConf));
        }
        this.config.put("warehouse", String.format("file://%s", this.warehouseRoot()));
        this.flinkDatabase = catalogName + "." + DATABASE;
        this.icebergNamespace = Namespace.of((String[])ArrayUtils.concat((String[])baseNamespace.levels(), (String[])new String[]{DATABASE}));
    }

    protected String warehouseRoot() {
        if (this.isHadoopCatalog) {
            return hadoopWarehouse.getRoot().getAbsolutePath();
        }
        return hiveWarehouse.getRoot().getAbsolutePath();
    }

    protected String getFullQualifiedTableName(String tableName) {
        ArrayList levels = Lists.newArrayList((Object[])this.icebergNamespace.levels());
        levels.add(tableName);
        return Joiner.on((char)'.').join((Iterable)levels);
    }

    static String getURI(HiveConf conf) {
        return conf.get(HiveConf.ConfVars.METASTOREURIS.varname);
    }

    static String toWithClause(Map<String, String> props) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        int propCount = 0;
        for (Map.Entry<String, String> entry : props.entrySet()) {
            if (propCount > 0) {
                builder.append(",");
            }
            builder.append("'").append(entry.getKey()).append("'").append("=").append("'").append(entry.getValue()).append("'");
            ++propCount;
        }
        builder.append(")");
        return builder.toString();
    }
}

