/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class RowDataConverter {
    private static final OffsetDateTime EPOCH = Instant.ofEpochSecond(0L).atOffset(ZoneOffset.UTC);
    private static final LocalDate EPOCH_DAY = EPOCH.toLocalDate();

    private RowDataConverter() {
    }

    public static RowData convert(Schema iSchema, Record record) {
        return RowDataConverter.convert(iSchema.asStruct(), record);
    }

    private static RowData convert(Types.StructType struct, Record record) {
        GenericRowData rowData = new GenericRowData(struct.fields().size());
        List fields = struct.fields();
        for (int i = 0; i < fields.size(); ++i) {
            Types.NestedField field = (Types.NestedField)fields.get(i);
            Type fieldType = field.type();
            rowData.setField(i, RowDataConverter.convert(fieldType, record.get(i)));
        }
        return rowData;
    }

    private static Object convert(Type type, Object object) {
        if (object == null) {
            return null;
        }
        switch (type.typeId()) {
            case BOOLEAN: 
            case INTEGER: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case FIXED: {
                return object;
            }
            case DATE: {
                return (int)ChronoUnit.DAYS.between(EPOCH_DAY, (LocalDate)object);
            }
            case TIME: {
                LocalTime localTime = (LocalTime)object;
                return (int)TimeUnit.NANOSECONDS.toMillis(localTime.toNanoOfDay());
            }
            case TIMESTAMP: {
                if (((Types.TimestampType)type).shouldAdjustToUTC()) {
                    return TimestampData.fromInstant((Instant)((OffsetDateTime)object).toInstant());
                }
                return TimestampData.fromLocalDateTime((LocalDateTime)((LocalDateTime)object));
            }
            case STRING: {
                return StringData.fromString((String)((String)object));
            }
            case UUID: {
                UUID uuid = (UUID)object;
                ByteBuffer bb = ByteBuffer.allocate(16);
                bb.putLong(uuid.getMostSignificantBits());
                bb.putLong(uuid.getLeastSignificantBits());
                return bb.array();
            }
            case BINARY: {
                ByteBuffer buffer = (ByteBuffer)object;
                return Arrays.copyOfRange(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.arrayOffset() + buffer.remaining());
            }
            case DECIMAL: {
                Types.DecimalType decimalType = (Types.DecimalType)type;
                return DecimalData.fromBigDecimal((BigDecimal)((BigDecimal)object), (int)decimalType.precision(), (int)decimalType.scale());
            }
            case STRUCT: {
                return RowDataConverter.convert(type.asStructType(), (Record)object);
            }
            case LIST: {
                List list = (List)object;
                Object[] convertedArray = new Object[list.size()];
                for (int i = 0; i < convertedArray.length; ++i) {
                    convertedArray[i] = RowDataConverter.convert(type.asListType().elementType(), list.get(i));
                }
                return new GenericArrayData(convertedArray);
            }
            case MAP: {
                LinkedHashMap convertedMap = Maps.newLinkedHashMap();
                Map map = (Map)object;
                for (Map.Entry entry : map.entrySet()) {
                    convertedMap.put(RowDataConverter.convert(type.asMapType().keyType(), entry.getKey()), RowDataConverter.convert(type.asMapType().valueType(), entry.getValue()));
                }
                return new GenericMapData((Map)convertedMap);
            }
        }
        throw new UnsupportedOperationException("Not a supported type: " + type);
    }
}

