/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.table.catalog.exceptions.DatabaseNotEmptyException;
import org.apache.flink.types.Row;
import org.apache.iceberg.Schema;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.flink.FlinkCatalogTestBase;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestFlinkCatalogDatabase
extends FlinkCatalogTestBase {
    public TestFlinkCatalogDatabase(String catalogName, Namespace baseNamespace) {
        super(catalogName, baseNamespace);
    }

    @Override
    @After
    public void clean() {
        this.sql("DROP TABLE IF EXISTS %s.tl", this.flinkDatabase);
        this.sql("DROP DATABASE IF EXISTS %s", this.flinkDatabase);
        super.clean();
    }

    @Test
    public void testCreateNamespace() {
        Assert.assertFalse((String)"Database should not already exist", (boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace));
        this.sql("CREATE DATABASE %s", this.flinkDatabase);
        Assert.assertTrue((String)"Database should exist", (boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace));
        this.sql("CREATE DATABASE IF NOT EXISTS %s", this.flinkDatabase);
        Assert.assertTrue((String)"Database should still exist", (boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace));
        this.sql("DROP DATABASE IF EXISTS %s", this.flinkDatabase);
        Assert.assertFalse((String)"Database should be dropped", (boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace));
        this.sql("CREATE DATABASE IF NOT EXISTS %s", this.flinkDatabase);
        Assert.assertTrue((String)"Database should be created", (boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace));
    }

    @Test
    public void testDropEmptyDatabase() {
        Assert.assertFalse((String)"Namespace should not already exist", (boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace));
        this.sql("CREATE DATABASE %s", this.flinkDatabase);
        Assert.assertTrue((String)"Namespace should exist", (boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace));
        this.sql("DROP DATABASE %s", this.flinkDatabase);
        Assert.assertFalse((String)"Namespace should have been dropped", (boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace));
    }

    @Test
    public void testDropNonEmptyNamespace() {
        Assume.assumeFalse((String)"Hadoop catalog throws IOException: Directory is not empty.", (boolean)this.isHadoopCatalog);
        Assert.assertFalse((String)"Namespace should not already exist", (boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace));
        this.sql("CREATE DATABASE %s", this.flinkDatabase);
        this.validationCatalog.createTable(TableIdentifier.of((Namespace)this.icebergNamespace, (String)"tl"), new Schema(new Types.NestedField[]{Types.NestedField.optional((int)0, (String)"id", (Type)Types.LongType.get())}));
        Assert.assertTrue((String)"Namespace should exist", (boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace));
        Assert.assertTrue((String)"Table should exist", (boolean)this.validationCatalog.tableExists(TableIdentifier.of((Namespace)this.icebergNamespace, (String)"tl")));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("DROP DATABASE %s", this.flinkDatabase)).cause().isInstanceOf(DatabaseNotEmptyException.class)).hasMessage(String.format("Database %s in catalog %s is not empty.", "db", this.catalogName));
        this.sql("DROP TABLE %s.tl", this.flinkDatabase);
    }

    @Test
    public void testListTables() {
        Assert.assertFalse((String)"Namespace should not already exist", (boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace));
        this.sql("CREATE DATABASE %s", this.flinkDatabase);
        this.sql("USE CATALOG %s", this.catalogName);
        this.sql("USE %s", "db");
        Assert.assertTrue((String)"Namespace should exist", (boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace));
        Assert.assertEquals((String)"Should not list any tables", (long)0L, (long)this.sql("SHOW TABLES", new Object[0]).size());
        this.validationCatalog.createTable(TableIdentifier.of((Namespace)this.icebergNamespace, (String)"tl"), new Schema(new Types.NestedField[]{Types.NestedField.optional((int)0, (String)"id", (Type)Types.LongType.get())}));
        List<Row> tables = this.sql("SHOW TABLES", new Object[0]);
        Assert.assertEquals((String)"Only 1 table", (long)1L, (long)tables.size());
        Assert.assertEquals((String)"Table name should match", (Object)"tl", (Object)tables.get(0).getField(0));
    }

    @Test
    public void testListNamespace() {
        Assert.assertFalse((String)"Namespace should not already exist", (boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace));
        this.sql("CREATE DATABASE %s", this.flinkDatabase);
        this.sql("USE CATALOG %s", this.catalogName);
        Assert.assertTrue((String)"Namespace should exist", (boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace));
        List<Row> databases = this.sql("SHOW DATABASES", new Object[0]);
        if (this.isHadoopCatalog) {
            Assert.assertEquals((String)"Should have 1 database", (long)1L, (long)databases.size());
            Assert.assertEquals((String)"Should have db database", (Object)"db", (Object)databases.get(0).getField(0));
            if (!this.baseNamespace.isEmpty()) {
                this.validationNamespaceCatalog.createNamespace(Namespace.of((String[])new String[]{this.baseNamespace.level(0), "UNKNOWN_NAMESPACE"}));
                databases = this.sql("SHOW DATABASES", new Object[0]);
                Assert.assertEquals((String)"Should have 1 database", (long)1L, (long)databases.size());
                Assert.assertEquals((String)"Should have db and default database", (Object)"db", (Object)databases.get(0).getField(0));
            }
        } else {
            Assert.assertTrue((String)"Should have db database", (boolean)databases.stream().anyMatch(d -> Objects.equals(d.getField(0), "db")));
        }
    }

    @Test
    public void testCreateNamespaceWithMetadata() {
        Assume.assumeFalse((String)"HadoopCatalog does not support namespace metadata", (boolean)this.isHadoopCatalog);
        Assert.assertFalse((String)"Namespace should not already exist", (boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace));
        this.sql("CREATE DATABASE %s WITH ('prop'='value')", this.flinkDatabase);
        Assert.assertTrue((String)"Namespace should exist", (boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace));
        Map nsMetadata = this.validationNamespaceCatalog.loadNamespaceMetadata(this.icebergNamespace);
        Assert.assertEquals((String)"Namespace should have expected prop value", (Object)"value", nsMetadata.get("prop"));
    }

    @Test
    public void testCreateNamespaceWithComment() {
        Assume.assumeFalse((String)"HadoopCatalog does not support namespace metadata", (boolean)this.isHadoopCatalog);
        Assert.assertFalse((String)"Namespace should not already exist", (boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace));
        this.sql("CREATE DATABASE %s COMMENT 'namespace doc'", this.flinkDatabase);
        Assert.assertTrue((String)"Namespace should exist", (boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace));
        Map nsMetadata = this.validationNamespaceCatalog.loadNamespaceMetadata(this.icebergNamespace);
        Assert.assertEquals((String)"Namespace should have expected comment", (Object)"namespace doc", nsMetadata.get("comment"));
    }

    @Test
    public void testCreateNamespaceWithLocation() throws Exception {
        Assume.assumeFalse((String)"HadoopCatalog does not support namespace metadata", (boolean)this.isHadoopCatalog);
        Assert.assertFalse((String)"Namespace should not already exist", (boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace));
        File location = TEMPORARY_FOLDER.newFile();
        Assert.assertTrue((boolean)location.delete());
        this.sql("CREATE DATABASE %s WITH ('location'='%s')", this.flinkDatabase, location);
        Assert.assertTrue((String)"Namespace should exist", (boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace));
        Map nsMetadata = this.validationNamespaceCatalog.loadNamespaceMetadata(this.icebergNamespace);
        Assert.assertEquals((String)"Namespace should have expected location", (Object)("file:" + location.getPath()), nsMetadata.get("location"));
    }

    @Test
    public void testSetProperties() {
        Assume.assumeFalse((String)"HadoopCatalog does not support namespace metadata", (boolean)this.isHadoopCatalog);
        Assert.assertFalse((String)"Namespace should not already exist", (boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace));
        this.sql("CREATE DATABASE %s", this.flinkDatabase);
        Assert.assertTrue((String)"Namespace should exist", (boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace));
        Map defaultMetadata = this.validationNamespaceCatalog.loadNamespaceMetadata(this.icebergNamespace);
        Assert.assertFalse((String)"Default metadata should not have custom property", (boolean)defaultMetadata.containsKey("prop"));
        this.sql("ALTER DATABASE %s SET ('prop'='value')", this.flinkDatabase);
        Map nsMetadata = this.validationNamespaceCatalog.loadNamespaceMetadata(this.icebergNamespace);
        Assert.assertEquals((String)"Namespace should have expected prop value", (Object)"value", nsMetadata.get("prop"));
    }

    @Test
    public void testHadoopNotSupportMeta() {
        Assume.assumeTrue((String)"HadoopCatalog does not support namespace metadata", (boolean)this.isHadoopCatalog);
        Assert.assertFalse((String)"Namespace should not already exist", (boolean)this.validationNamespaceCatalog.namespaceExists(this.icebergNamespace));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CREATE DATABASE %s WITH ('prop'='value')", this.flinkDatabase)).cause().isInstanceOf(UnsupportedOperationException.class)).hasMessage(String.format("Cannot create namespace %s: metadata is not supported", this.icebergNamespace));
    }
}

