/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.ReplacePartitions;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.flink.FlinkCatalogTestBase;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class TestFlinkCatalogTable
extends FlinkCatalogTestBase {
    public TestFlinkCatalogTable(String catalogName, Namespace baseNamespace) {
        super(catalogName, baseNamespace);
    }

    @Override
    @Before
    public void before() {
        super.before();
        this.sql("CREATE DATABASE %s", this.flinkDatabase);
        this.sql("USE CATALOG %s", this.catalogName);
        this.sql("USE %s", "db");
    }

    @After
    public void cleanNamespaces() {
        this.sql("DROP TABLE IF EXISTS %s.tl", this.flinkDatabase);
        this.sql("DROP TABLE IF EXISTS %s.tl2", this.flinkDatabase);
        this.sql("DROP DATABASE IF EXISTS %s", this.flinkDatabase);
        super.clean();
    }

    @Test
    public void testGetTable() {
        this.sql("CREATE TABLE tl(id BIGINT, strV STRING)", new Object[0]);
        Table table = this.validationCatalog.loadTable(TableIdentifier.of((Namespace)this.icebergNamespace, (String)"tl"));
        Schema iSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"strV", (Type)Types.StringType.get())});
        Assert.assertEquals((String)"Should load the expected iceberg schema", (Object)iSchema.toString(), (Object)table.schema().toString());
    }

    @Test
    public void testRenameTable() {
        Assume.assumeFalse((String)"HadoopCatalog does not support rename table", (boolean)this.isHadoopCatalog);
        Schema tableSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)0, (String)"id", (Type)Types.LongType.get())});
        this.validationCatalog.createTable(TableIdentifier.of((Namespace)this.icebergNamespace, (String)"tl"), tableSchema);
        this.sql("ALTER TABLE tl RENAME TO tl2", new Object[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.getTableEnv().from("tl")).isInstanceOf(ValidationException.class)).hasMessage("Table `tl` was not found.");
        Schema actualSchema = FlinkSchemaUtil.convert((TableSchema)this.getTableEnv().from("tl2").getSchema());
        Assert.assertEquals((Object)tableSchema.asStruct(), (Object)actualSchema.asStruct());
    }

    @Test
    public void testCreateTable() throws TableNotExistException {
        this.sql("CREATE TABLE tl(id BIGINT)", new Object[0]);
        Table table = this.table("tl");
        Assert.assertEquals((Object)new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get())}).asStruct(), (Object)table.schema().asStruct());
        CatalogTable catalogTable = this.catalogTable("tl");
        Assert.assertEquals((Object)TableSchema.builder().field("id", DataTypes.BIGINT()).build(), (Object)catalogTable.getSchema());
    }

    @Test
    public void testCreateTableWithPrimaryKey() throws Exception {
        this.sql("CREATE TABLE tl(id BIGINT, data STRING, key STRING PRIMARY KEY NOT ENFORCED)", new Object[0]);
        Table table = this.table("tl");
        Assert.assertEquals((String)"Should have the expected row key.", (Object)Sets.newHashSet((Object[])new Integer[]{table.schema().findField("key").fieldId()}), (Object)table.schema().identifierFieldIds());
        CatalogTable catalogTable = this.catalogTable("tl");
        Optional uniqueConstraintOptional = catalogTable.getSchema().getPrimaryKey();
        Assert.assertTrue((String)"Should have the expected unique constraint", (boolean)uniqueConstraintOptional.isPresent());
        Assert.assertEquals((String)"Should have the expected columns", (Object)ImmutableList.of((Object)"key"), (Object)((UniqueConstraint)uniqueConstraintOptional.get()).getColumns());
    }

    @Test
    public void testCreateTableWithMultiColumnsInPrimaryKey() throws Exception {
        this.sql("CREATE TABLE tl(id BIGINT, data STRING, CONSTRAINT pk_constraint PRIMARY KEY(data, id) NOT ENFORCED)", new Object[0]);
        Table table = this.table("tl");
        Assert.assertEquals((String)"Should have the expected RowKey", (Object)Sets.newHashSet((Object[])new Integer[]{table.schema().findField("id").fieldId(), table.schema().findField("data").fieldId()}), (Object)table.schema().identifierFieldIds());
        CatalogTable catalogTable = this.catalogTable("tl");
        Optional uniqueConstraintOptional = catalogTable.getSchema().getPrimaryKey();
        Assert.assertTrue((String)"Should have the expected unique constraint", (boolean)uniqueConstraintOptional.isPresent());
        Assert.assertEquals((String)"Should have the expected columns", (Object)ImmutableSet.of((Object)"data", (Object)"id"), (Object)ImmutableSet.copyOf((Collection)((UniqueConstraint)uniqueConstraintOptional.get()).getColumns()));
    }

    @Test
    public void testCreateTableIfNotExists() {
        this.sql("CREATE TABLE tl(id BIGINT)", new Object[0]);
        Assertions.assertThat((Object)this.table("tl")).isNotNull();
        this.sql("DROP TABLE tl", new Object[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.table("tl")).isInstanceOf(NoSuchTableException.class)).hasMessage("Table does not exist: " + this.getFullQualifiedTableName("tl"));
        this.sql("CREATE TABLE IF NOT EXISTS tl(id BIGINT)", new Object[0]);
        Assertions.assertThat((Map)this.table("tl").properties()).doesNotContainKey((Object)"key");
        this.table("tl").updateProperties().set("key", "value").commit();
        Assertions.assertThat((Map)this.table("tl").properties()).containsEntry((Object)"key", (Object)"value");
        this.sql("CREATE TABLE IF NOT EXISTS tl(id BIGINT)", new Object[0]);
        Assertions.assertThat((Map)this.table("tl").properties()).containsEntry((Object)"key", (Object)"value");
    }

    @Test
    public void testCreateTableLike() throws TableNotExistException {
        this.sql("CREATE TABLE tl(id BIGINT)", new Object[0]);
        this.sql("CREATE TABLE tl2 LIKE tl", new Object[0]);
        Table table = this.table("tl2");
        Assert.assertEquals((Object)new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get())}).asStruct(), (Object)table.schema().asStruct());
        CatalogTable catalogTable = this.catalogTable("tl2");
        Assert.assertEquals((Object)TableSchema.builder().field("id", DataTypes.BIGINT()).build(), (Object)catalogTable.getSchema());
    }

    @Test
    public void testCreateTableLocation() {
        Assume.assumeFalse((String)"HadoopCatalog does not support creating table with location", (boolean)this.isHadoopCatalog);
        this.sql("CREATE TABLE tl(id BIGINT) WITH ('location'='file:///tmp/location')", new Object[0]);
        Table table = this.table("tl");
        Assert.assertEquals((Object)new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get())}).asStruct(), (Object)table.schema().asStruct());
        Assert.assertEquals((Object)"file:///tmp/location", (Object)table.location());
    }

    @Test
    public void testCreatePartitionTable() throws TableNotExistException {
        this.sql("CREATE TABLE tl(id BIGINT, dt STRING) PARTITIONED BY(dt)", new Object[0]);
        Table table = this.table("tl");
        Assert.assertEquals((Object)new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"dt", (Type)Types.StringType.get())}).asStruct(), (Object)table.schema().asStruct());
        Assert.assertEquals((Object)PartitionSpec.builderFor((Schema)table.schema()).identity("dt").build(), (Object)table.spec());
        CatalogTable catalogTable = this.catalogTable("tl");
        Assert.assertEquals((Object)TableSchema.builder().field("id", DataTypes.BIGINT()).field("dt", DataTypes.STRING()).build(), (Object)catalogTable.getSchema());
        Assert.assertEquals(Collections.singletonList("dt"), (Object)catalogTable.getPartitionKeys());
    }

    @Test
    public void testCreateTableWithFormatV2ThroughTableProperty() throws Exception {
        this.sql("CREATE TABLE tl(id BIGINT) WITH ('format-version'='2')", new Object[0]);
        Table table = this.table("tl");
        Assert.assertEquals((String)"should create table using format v2", (long)2L, (long)((BaseTable)table).operations().current().formatVersion());
    }

    @Test
    public void testUpgradeTableWithFormatV2ThroughTableProperty() throws Exception {
        this.sql("CREATE TABLE tl(id BIGINT) WITH ('format-version'='1')", new Object[0]);
        Table table = this.table("tl");
        TableOperations ops = ((BaseTable)table).operations();
        Assert.assertEquals((String)"should create table using format v1", (long)1L, (long)ops.refresh().formatVersion());
        this.sql("ALTER TABLE tl SET('format-version'='2')", new Object[0]);
        Assert.assertEquals((String)"should update table to use format v2", (long)2L, (long)ops.refresh().formatVersion());
    }

    @Test
    public void testDowngradeTableToFormatV1ThroughTablePropertyFails() throws Exception {
        this.sql("CREATE TABLE tl(id BIGINT) WITH ('format-version'='2')", new Object[0]);
        Table table = this.table("tl");
        TableOperations ops = ((BaseTable)table).operations();
        Assert.assertEquals((String)"should create table using format v2", (long)2L, (long)ops.refresh().formatVersion());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE tl SET('format-version'='1')", new Object[0])).rootCause().isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot downgrade v2 table to v1");
    }

    @Test
    public void testLoadTransformPartitionTable() throws TableNotExistException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)0, (String)"id", (Type)Types.LongType.get())});
        this.validationCatalog.createTable(TableIdentifier.of((Namespace)this.icebergNamespace, (String)"tl"), schema, PartitionSpec.builderFor((Schema)schema).bucket("id", 100).build());
        CatalogTable catalogTable = this.catalogTable("tl");
        Assert.assertEquals((Object)TableSchema.builder().field("id", DataTypes.BIGINT()).build(), (Object)catalogTable.getSchema());
        Assert.assertEquals(Collections.emptyList(), (Object)catalogTable.getPartitionKeys());
    }

    @Test
    public void testAlterTableProperties() throws TableNotExistException {
        this.sql("CREATE TABLE tl(id BIGINT) WITH ('oldK'='oldV')", new Object[0]);
        HashMap properties = Maps.newHashMap();
        properties.put("oldK", "oldV");
        this.sql("ALTER TABLE tl SET('newK'='newV')", new Object[0]);
        properties.put("newK", "newV");
        Assertions.assertThat((Map)this.table("tl").properties()).containsAllEntriesOf((Map)properties);
        this.sql("ALTER TABLE tl SET('oldK'='oldV2')", new Object[0]);
        properties.put("oldK", "oldV2");
        Assertions.assertThat((Map)this.table("tl").properties()).containsAllEntriesOf((Map)properties);
        this.sql("ALTER TABLE tl RESET('oldK')", new Object[0]);
        properties.remove("oldK");
        Assertions.assertThat((Map)this.table("tl").properties()).containsAllEntriesOf((Map)properties);
    }

    @Test
    public void testAlterTableAddColumn() {
        this.sql("CREATE TABLE tl(id BIGINT)", new Object[0]);
        Schema schemaBefore = this.table("tl").schema();
        Assert.assertEquals((Object)new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get())}).asStruct(), (Object)schemaBefore.asStruct());
        this.sql("ALTER TABLE tl ADD (dt STRING)", new Object[0]);
        Schema schemaAfter1 = this.table("tl").schema();
        Assert.assertEquals((Object)new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"dt", (Type)Types.StringType.get())}).asStruct(), (Object)schemaAfter1.asStruct());
        this.sql("ALTER TABLE tl ADD (col1 STRING, col2 BIGINT)", new Object[0]);
        Schema schemaAfter2 = this.table("tl").schema();
        Assert.assertEquals((Object)new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"dt", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"col1", (Type)Types.StringType.get()), Types.NestedField.optional((int)4, (String)"col2", (Type)Types.LongType.get())}).asStruct(), (Object)schemaAfter2.asStruct());
        Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE tl ADD (pk STRING NOT NULL)", new Object[0])).hasRootCauseInstanceOf(IllegalArgumentException.class).hasRootCauseMessage("Incompatible change: cannot add required column: pk");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE tl ADD (id STRING)", new Object[0])).isInstanceOf(ValidationException.class)).hasMessageContaining("Try to add a column `id` which already exists in the table.");
    }

    @Test
    public void testAlterTableDropColumn() {
        this.sql("CREATE TABLE tl(id BIGINT, dt STRING, col1 STRING, col2 BIGINT)", new Object[0]);
        Schema schemaBefore = this.table("tl").schema();
        Assert.assertEquals((Object)new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"dt", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"col1", (Type)Types.StringType.get()), Types.NestedField.optional((int)4, (String)"col2", (Type)Types.LongType.get())}).asStruct(), (Object)schemaBefore.asStruct());
        this.sql("ALTER TABLE tl DROP (dt)", new Object[0]);
        Schema schemaAfter1 = this.table("tl").schema();
        Assert.assertEquals((Object)new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)3, (String)"col1", (Type)Types.StringType.get()), Types.NestedField.optional((int)4, (String)"col2", (Type)Types.LongType.get())}).asStruct(), (Object)schemaAfter1.asStruct());
        this.sql("ALTER TABLE tl DROP (col1, col2)", new Object[0]);
        Schema schemaAfter2 = this.table("tl").schema();
        Assert.assertEquals((Object)new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get())}).asStruct(), (Object)schemaAfter2.asStruct());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE tl DROP (foo)", new Object[0])).isInstanceOf(ValidationException.class)).hasMessageContaining("The column `foo` does not exist in the base table.");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE tl DROP (dt)", new Object[0])).isInstanceOf(ValidationException.class)).hasMessageContaining("The column `dt` does not exist in the base table.");
    }

    @Test
    public void testAlterTableModifyColumnName() {
        this.sql("CREATE TABLE tl(id BIGINT, dt STRING)", new Object[0]);
        Schema schemaBefore = this.table("tl").schema();
        Assert.assertEquals((Object)new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"dt", (Type)Types.StringType.get())}).asStruct(), (Object)schemaBefore.asStruct());
        this.sql("ALTER TABLE tl RENAME dt TO data", new Object[0]);
        Schema schemaAfter = this.table("tl").schema();
        Assert.assertEquals((Object)new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())}).asStruct(), (Object)schemaAfter.asStruct());
    }

    @Test
    public void testAlterTableModifyColumnType() {
        this.sql("CREATE TABLE tl(id INTEGER, dt STRING)", new Object[0]);
        Schema schemaBefore = this.table("tl").schema();
        Assert.assertEquals((Object)new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"dt", (Type)Types.StringType.get())}).asStruct(), (Object)schemaBefore.asStruct());
        this.sql("ALTER TABLE tl MODIFY (id BIGINT)", new Object[0]);
        Schema schemaAfter = this.table("tl").schema();
        Assert.assertEquals((Object)new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"dt", (Type)Types.StringType.get())}).asStruct(), (Object)schemaAfter.asStruct());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE tl MODIFY (dt INTEGER)", new Object[0])).isInstanceOf(TableException.class)).hasRootCauseInstanceOf(IllegalArgumentException.class).hasRootCauseMessage("Cannot change column type: dt: string -> int");
    }

    @Test
    public void testAlterTableModifyColumnNullability() {
        this.sql("CREATE TABLE tl(id INTEGER NOT NULL, dt STRING)", new Object[0]);
        Schema schemaBefore = this.table("tl").schema();
        Assert.assertEquals((Object)new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"dt", (Type)Types.StringType.get())}).asStruct(), (Object)schemaBefore.asStruct());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE tl MODIFY (dt STRING NOT NULL)", new Object[0])).isInstanceOf(TableException.class)).hasRootCauseInstanceOf(IllegalArgumentException.class).hasRootCauseMessage("Cannot change column nullability: dt: optional -> required");
        this.sql("ALTER TABLE tl MODIFY (id INTEGER)", new Object[0]);
        Schema schemaAfter = this.table("tl").schema();
        Assert.assertEquals((Object)new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"dt", (Type)Types.StringType.get())}).asStruct(), (Object)schemaAfter.asStruct());
    }

    @Test
    public void testAlterTableModifyColumnPosition() {
        this.sql("CREATE TABLE tl(id BIGINT, dt STRING)", new Object[0]);
        Schema schemaBefore = this.table("tl").schema();
        Assert.assertEquals((Object)new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"dt", (Type)Types.StringType.get())}).asStruct(), (Object)schemaBefore.asStruct());
        this.sql("ALTER TABLE tl MODIFY (dt STRING FIRST)", new Object[0]);
        Schema schemaAfter = this.table("tl").schema();
        Assert.assertEquals((Object)new Schema(new Types.NestedField[]{Types.NestedField.optional((int)2, (String)"dt", (Type)Types.StringType.get()), Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get())}).asStruct(), (Object)schemaAfter.asStruct());
        this.sql("ALTER TABLE tl MODIFY (dt STRING AFTER id)", new Object[0]);
        Schema schemaAfterAfter = this.table("tl").schema();
        Assert.assertEquals((Object)new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"dt", (Type)Types.StringType.get())}).asStruct(), (Object)schemaAfterAfter.asStruct());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE tl MODIFY (non_existing STRING FIRST)", new Object[0])).isInstanceOf(ValidationException.class)).hasMessageContaining("Try to modify a column `non_existing` which does not exist in the table.");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE tl MODIFY (dt STRING AFTER non_existing)", new Object[0])).isInstanceOf(ValidationException.class)).hasMessageContaining("Referenced column `non_existing` by 'AFTER' does not exist in the table.");
    }

    @Test
    public void testAlterTableModifyColumnComment() {
        this.sql("CREATE TABLE tl(id BIGINT, dt STRING)", new Object[0]);
        Schema schemaBefore = this.table("tl").schema();
        Assert.assertEquals((Object)new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"dt", (Type)Types.StringType.get())}).asStruct(), (Object)schemaBefore.asStruct());
        this.sql("ALTER TABLE tl MODIFY (dt STRING COMMENT 'comment for dt field')", new Object[0]);
        Schema schemaAfter = this.table("tl").schema();
        Assert.assertEquals((Object)new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"dt", (Type)Types.StringType.get(), (String)"comment for dt field")}).asStruct(), (Object)schemaAfter.asStruct());
    }

    @Test
    public void testAlterTableConstraint() {
        this.sql("CREATE TABLE tl(id BIGINT NOT NULL, dt STRING NOT NULL, col1 STRING)", new Object[0]);
        Schema schemaBefore = this.table("tl").schema();
        Assert.assertEquals((Object)new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"dt", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"col1", (Type)Types.StringType.get())}).asStruct(), (Object)schemaBefore.asStruct());
        Assert.assertEquals((Object)ImmutableSet.of(), (Object)schemaBefore.identifierFieldNames());
        this.sql("ALTER TABLE tl ADD (PRIMARY KEY (id) NOT ENFORCED)", new Object[0]);
        Schema schemaAfterAdd = this.table("tl").schema();
        Assert.assertEquals((Object)ImmutableSet.of((Object)"id"), (Object)schemaAfterAdd.identifierFieldNames());
        this.sql("ALTER TABLE tl MODIFY (PRIMARY KEY (dt) NOT ENFORCED)", new Object[0]);
        Schema schemaAfterModify = this.table("tl").schema();
        Assert.assertEquals((Object)new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"dt", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"col1", (Type)Types.StringType.get())}).asStruct(), (Object)schemaAfterModify.asStruct());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"dt"), (Object)schemaAfterModify.identifierFieldNames());
        this.sql("ALTER TABLE tl MODIFY (PRIMARY KEY (id, dt) NOT ENFORCED)", new Object[0]);
        Schema schemaAfterComposite = this.table("tl").schema();
        Assert.assertEquals((Object)new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"dt", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"col1", (Type)Types.StringType.get())}).asStruct(), (Object)schemaAfterComposite.asStruct());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"id", (Object)"dt"), (Object)schemaAfterComposite.identifierFieldNames());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE tl MODIFY (PRIMARY KEY (col1) NOT ENFORCED)", new Object[0])).isInstanceOf(TableException.class)).hasRootCauseInstanceOf(IllegalArgumentException.class).hasRootCauseMessage("Cannot add field col1 as an identifier field: not a required field");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE tl MODIFY (PRIMARY KEY (id, col1) NOT ENFORCED)", new Object[0])).isInstanceOf(TableException.class)).hasRootCauseInstanceOf(IllegalArgumentException.class).hasRootCauseMessage("Cannot add field col1 as an identifier field: not a required field");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE tl DROP PRIMARY KEY", new Object[0])).isInstanceOf(TableException.class)).hasRootCauseInstanceOf(UnsupportedOperationException.class).hasRootCauseMessage("Unsupported table change: DropConstraint.");
    }

    @Test
    public void testRelocateTable() {
        Assume.assumeFalse((String)"HadoopCatalog does not support relocate table", (boolean)this.isHadoopCatalog);
        this.sql("CREATE TABLE tl(id BIGINT)", new Object[0]);
        this.sql("ALTER TABLE tl SET('location'='file:///tmp/location')", new Object[0]);
        Assert.assertEquals((Object)"file:///tmp/location", (Object)this.table("tl").location());
    }

    @Test
    public void testSetCurrentAndCherryPickSnapshotId() {
        this.sql("CREATE TABLE tl(c1 INT, c2 STRING, c3 STRING) PARTITIONED BY (c1)", new Object[0]);
        Table table = this.table("tl");
        DataFile fileA = DataFiles.builder((PartitionSpec)table.spec()).withPath("/path/to/data-a.parquet").withFileSizeInBytes(10L).withPartitionPath("c1=0").withRecordCount(1L).build();
        DataFile fileB = DataFiles.builder((PartitionSpec)table.spec()).withPath("/path/to/data-b.parquet").withFileSizeInBytes(10L).withPartitionPath("c1=1").withRecordCount(1L).build();
        DataFile replacementFile = DataFiles.builder((PartitionSpec)table.spec()).withPath("/path/to/data-a-replacement.parquet").withFileSizeInBytes(10L).withPartitionPath("c1=0").withRecordCount(1L).build();
        table.newAppend().appendFile(fileA).commit();
        long snapshotId = table.currentSnapshot().snapshotId();
        ((ReplacePartitions)table.newReplacePartitions().addFile(replacementFile).stageOnly()).commit();
        Snapshot staged = (Snapshot)Iterables.getLast((Iterable)table.snapshots());
        Assert.assertEquals((String)"Should find the staged overwrite snapshot", (Object)"overwrite", (Object)staged.operation());
        table.newAppend().appendFile(fileB).commit();
        this.sql("ALTER TABLE tl SET('cherry-pick-snapshot-id'='%s')", staged.snapshotId());
        this.validateTableFiles(table, fileB, replacementFile);
        this.sql("ALTER TABLE tl SET('current-snapshot-id'='%s')", snapshotId);
        this.validateTableFiles(table, fileA);
    }

    private void validateTableFiles(Table tbl, DataFile ... expectedFiles) {
        tbl.refresh();
        Set expectedFilePaths = Arrays.stream(expectedFiles).map(ContentFile::path).collect(Collectors.toSet());
        Set actualFilePaths = StreamSupport.stream(tbl.newScan().planFiles().spliterator(), false).map(ContentScanTask::file).map(ContentFile::path).collect(Collectors.toSet());
        Assert.assertEquals((String)"Files should match", expectedFilePaths, actualFilePaths);
    }

    private Table table(String name) {
        return this.validationCatalog.loadTable(TableIdentifier.of((Namespace)this.icebergNamespace, (String)name));
    }

    private CatalogTable catalogTable(String name) throws TableNotExistException {
        return (CatalogTable)((Catalog)this.getTableEnv().getCatalog(this.getTableEnv().getCurrentCatalog()).get()).getTable(new ObjectPath("db", name));
    }
}

