/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.catalog.exceptions.TableNotPartitionedException;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.flink.FlinkCatalog;
import org.apache.iceberg.flink.FlinkCatalogTestBase;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;

public class TestFlinkCatalogTablePartitions
extends FlinkCatalogTestBase {
    private String tableName = "test_table";
    private final FileFormat format;

    @Parameterized.Parameters(name="catalogName={0}, baseNamespace={1}, format={2}, cacheEnabled={3}")
    public static Iterable<Object[]> parameters() {
        ArrayList parameters = Lists.newArrayList();
        for (FileFormat format : new FileFormat[]{FileFormat.ORC, FileFormat.AVRO, FileFormat.PARQUET}) {
            for (Boolean cacheEnabled : new Boolean[]{true, false}) {
                for (Object[] catalogParams : FlinkCatalogTestBase.parameters()) {
                    String catalogName = (String)catalogParams[0];
                    Namespace baseNamespace = (Namespace)catalogParams[1];
                    parameters.add(new Object[]{catalogName, baseNamespace, format, cacheEnabled});
                }
            }
        }
        return parameters;
    }

    public TestFlinkCatalogTablePartitions(String catalogName, Namespace baseNamespace, FileFormat format, boolean cacheEnabled) {
        super(catalogName, baseNamespace);
        this.format = format;
        this.config.put("cache-enabled", String.valueOf(cacheEnabled));
    }

    @Override
    @Before
    public void before() {
        super.before();
        this.sql("CREATE DATABASE %s", this.flinkDatabase);
        this.sql("USE CATALOG %s", this.catalogName);
        this.sql("USE %s", "db");
    }

    @After
    public void cleanNamespaces() {
        this.sql("DROP TABLE IF EXISTS %s.%s", this.flinkDatabase, this.tableName);
        this.sql("DROP DATABASE IF EXISTS %s", this.flinkDatabase);
        super.clean();
    }

    @Test
    public void testListPartitionsWithUnpartitionedTable() {
        this.sql("CREATE TABLE %s (id INT, data VARCHAR) with ('write.format.default'='%s')", this.tableName, this.format.name());
        this.sql("INSERT INTO %s SELECT 1,'a'", this.tableName);
        ObjectPath objectPath = new ObjectPath("db", this.tableName);
        FlinkCatalog flinkCatalog = (FlinkCatalog)this.getTableEnv().getCatalog(this.catalogName).get();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> flinkCatalog.listPartitions(objectPath)).isInstanceOf(TableNotPartitionedException.class)).hasMessageStartingWith("Table db.test_table in catalog").hasMessageEndingWith("is not partitioned.");
    }

    @Test
    public void testListPartitionsWithPartitionedTable() throws TableNotExistException, TableNotPartitionedException {
        this.sql("CREATE TABLE %s (id INT, data VARCHAR) PARTITIONED BY (data) with ('write.format.default'='%s')", this.tableName, this.format.name());
        this.sql("INSERT INTO %s SELECT 1,'a'", this.tableName);
        this.sql("INSERT INTO %s SELECT 2,'b'", this.tableName);
        ObjectPath objectPath = new ObjectPath("db", this.tableName);
        FlinkCatalog flinkCatalog = (FlinkCatalog)this.getTableEnv().getCatalog(this.catalogName).get();
        List list = flinkCatalog.listPartitions(objectPath);
        Assert.assertEquals((String)"Should have 2 partition", (long)2L, (long)list.size());
        ArrayList expected = Lists.newArrayList();
        CatalogPartitionSpec partitionSpec1 = new CatalogPartitionSpec((Map)ImmutableMap.of((Object)"data", (Object)"a"));
        CatalogPartitionSpec partitionSpec2 = new CatalogPartitionSpec((Map)ImmutableMap.of((Object)"data", (Object)"b"));
        expected.add(partitionSpec1);
        expected.add(partitionSpec2);
        Assert.assertEquals((String)"Should produce the expected catalog partition specs.", (Object)list, (Object)expected);
    }
}

